/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.module.iot.config;

import cn.hutool.extra.spring.SpringUtil;
import cn.iocoder.yudao.module.iot.api.device.DeviceDataApi;
import cn.iocoder.yudao.module.iot.service.HttpVertxHandler;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import lombok.Generated;
import org.pf4j.PluginWrapper;
import org.pf4j.spring.SpringPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class HttpVertxPlugin
extends SpringPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpVertxPlugin.class);
    private static final int PORT = 8092;
    private Vertx vertx;

    public HttpVertxPlugin(PluginWrapper wrapper) {
        super(wrapper);
    }

    public void start() {
        log.info("HttpVertxPlugin.start()");
        DeviceDataApi deviceDataApi = (DeviceDataApi)SpringUtil.getBean(DeviceDataApi.class);
        if (deviceDataApi == null) {
            log.error("\u672a\u80fd\u4ece ServiceRegistry \u83b7\u53d6 DeviceDataApi \u5b9e\u4f8b\uff0c\u8bf7\u786e\u4fdd\u4e3b\u7a0b\u5e8f\u5df2\u6b63\u786e\u6ce8\u518c\uff01");
            return;
        }
        this.vertx = Vertx.vertx();
        Router router = Router.router((Vertx)this.vertx);
        router.route().handler((Handler)BodyHandler.create());
        router.post("/sys/:productKey/:deviceName/thing/event/property/post").handler((Handler)new HttpVertxHandler(deviceDataApi));
        this.vertx.createHttpServer().requestHandler((Handler)router).listen(8092, http -> {
            if (http.succeeded()) {
                log.info("HTTP \u670d\u52a1\u5668\u542f\u52a8\u6210\u529f\uff0c\u7aef\u53e3\u4e3a: {}", (Object)8092);
            } else {
                log.error("HTTP \u670d\u52a1\u5668\u542f\u52a8\u5931\u8d25", http.cause());
            }
        });
    }

    public void stop() {
        log.info("HttpVertxPlugin.stop()");
        if (this.vertx != null) {
            this.vertx.close(ar -> {
                if (ar.succeeded()) {
                    log.info("Vert.x \u5173\u95ed\u6210\u529f");
                } else {
                    log.error("Vert.x \u5173\u95ed\u5931\u8d25", ar.cause());
                }
            });
        }
    }

    protected ApplicationContext createApplicationContext() {
        AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext();
        applicationContext.setClassLoader(this.getWrapper().getPluginClassLoader());
        applicationContext.refresh();
        return applicationContext;
    }
}

