/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.module.iot.plugin;

import cn.iocoder.yudao.module.iot.api.ServiceRegistry;
import cn.iocoder.yudao.module.iot.api.device.DeviceDataApi;
import cn.iocoder.yudao.module.iot.plugin.HttpHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.pf4j.Plugin;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPlugin
extends Plugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpPlugin.class);
    private static final int PORT = 8092;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private DeviceDataApi deviceDataApi;

    public HttpPlugin(PluginWrapper pluginWrapper) {
        super(pluginWrapper);
    }

    public void start() {
        log.info("HttpPlugin.start()");
        if (this.executorService.isShutdown() || this.executorService.isTerminated()) {
            this.executorService = Executors.newSingleThreadExecutor();
        }
        this.deviceDataApi = (DeviceDataApi)ServiceRegistry.getService(DeviceDataApi.class);
        if (this.deviceDataApi == null) {
            log.error("\u672a\u80fd\u4ece ServiceRegistry \u83b7\u53d6 DeviceDataApi \u5b9e\u4f8b\uff0c\u8bf7\u786e\u4fdd\u4e3b\u7a0b\u5e8f\u5df2\u6b63\u786e\u6ce8\u518c\uff01");
            return;
        }
        this.executorService.submit(this::startHttpServer);
    }

    public void stop() {
        log.info("HttpPlugin.stop()");
        this.executorService.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startHttpServer() {
        NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup nioEventLoopGroup2 = new NioEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)nioEventLoopGroup, (EventLoopGroup)nioEventLoopGroup2).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    channel.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()});
                    channel.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                    channel.pipeline().addLast(new ChannelHandler[]{new HttpHandler(HttpPlugin.this.deviceDataApi)});
                }
            });
            ChannelFuture channelFuture = serverBootstrap.bind(8092).sync();
            log.info("HTTP \u670d\u52a1\u5668\u542f\u52a8\u6210\u529f\uff0c\u7aef\u53e3\u4e3a: {}", (Object)8092);
            channelFuture.channel().closeFuture().sync();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            log.warn("HTTP \u670d\u52a1\u542f\u52a8\u88ab\u4e2d\u65ad", (Throwable)interruptedException);
        }
        finally {
            nioEventLoopGroup.shutdownGracefully();
            nioEventLoopGroup2.shutdownGracefully();
        }
    }
}

