/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.jdbc;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Array;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import org.opengauss.core.BaseConnection;
import org.opengauss.jdbc.PGStruct;
import org.opengauss.jdbc.PgArray;
import org.opengauss.jdbc.PgResultSet;
import org.opengauss.util.PSQLException;
import org.opengauss.util.PSQLState;
import org.opengauss.util.csv.CSVReader;
import org.opengauss.util.csv.CSVReaderBuilder;
import org.opengauss.util.csv.CSVReaderNullFieldIndicator;
import org.opengauss.util.csv.CSVWriter;

public class PGStructAttrsConverter {
    private static final String QUOTES = "\"";
    private static final char BACKSLASH_CHAR = '\\';
    private static final String BACKSLASH_STRING = "\\";
    private static final String DOUBLE_BACKSLASH_STRING = "\\\\";

    public static String convertAttributes(Object[] attributes) throws SQLException {
        if (attributes == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        String[] dataArray = new String[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            Object attrObj = attributes[i];
            if (attrObj instanceof Struct) {
                String attrValue;
                Struct struct = (Struct)attrObj;
                dataArray[i] = attrValue = struct.toString();
                continue;
            }
            if (attributes[i] instanceof Array) {
                String attrsValue;
                dataArray[i] = attrsValue = attributes[i].toString();
                continue;
            }
            String attrValue = null;
            if (attributes[i] != null) {
                attrValue = attributes[i].toString();
            }
            dataArray[i] = attrValue;
        }
        try {
            StringWriter writer = new StringWriter();
            CSVWriter csvWriter = new CSVWriter(writer);
            csvWriter.writeNext(dataArray);
            csvWriter.flush();
            String attributeStr = writer.toString().trim();
            attributeStr = PGStructAttrsConverter.processBackslashChar(attributeStr);
            sb.append(attributeStr);
        }
        catch (IOException ioe) {
            throw new PSQLException("Invalid character data was found. CSVWriter write text error, ", PSQLState.DATA_ERROR, (Throwable)ioe);
        }
        sb.append(")");
        return sb.toString();
    }

    public static Object[] parseAttributes(BaseConnection conn, List<Integer> elementOIDs, String attributesString) throws SQLException {
        String quote = QUOTES;
        ArrayList<Object> attributeList = new ArrayList<Object>();
        if (attributesString.startsWith("(") && attributesString.endsWith(")")) {
            attributesString = attributesString.substring(1, attributesString.length() - 1);
        }
        String[] attributeValueArray = PGStructAttrsConverter.parseAttributeValueArray(attributesString);
        for (int i = 0; i < attributeValueArray.length; ++i) {
            String objectValue;
            String attributeValue = attributeValueArray[i];
            int oid = elementOIDs.get(i);
            int sqlType = conn.getTypeInfo().getSQLType(oid);
            if (sqlType == 2002) {
                objectValue = attributeValue;
                objectValue = PGStructAttrsConverter.processDoubleBackslashStr(objectValue);
                attributeList.add(new PGStruct(conn, oid, objectValue));
                continue;
            }
            if (sqlType == 2003) {
                objectValue = attributeValue;
                attributeList.add(new PgArray(conn, oid, objectValue));
                continue;
            }
            objectValue = attributeValue;
            if (objectValue != null) {
                if (!objectValue.isEmpty() && objectValue.length() > 1 && objectValue.startsWith(quote) && objectValue.endsWith(quote)) {
                    objectValue = objectValue.substring(1, objectValue.length() - 1);
                }
                Object obj = PGStructAttrsConverter.getObject(conn, objectValue, oid, sqlType);
                attributeList.add(obj);
                continue;
            }
            attributeList.add(null);
        }
        return attributeList.toArray();
    }

    public static String[] parseAttributeValueArray(String attributesString) throws PSQLException {
        if (attributesString.isEmpty()) {
            return new String[0];
        }
        try {
            StringReader strReader = new StringReader(attributesString);
            CSVReader csvReader = new CSVReaderBuilder(strReader).withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS).build();
            return csvReader.readNext();
        }
        catch (IOException ioe) {
            throw new PSQLException("Invalid character data was found. csvReader read text error, ", PSQLState.DATA_ERROR, (Throwable)ioe);
        }
    }

    private static Object getObject(BaseConnection connection, String text, int oid, int type) throws SQLException {
        switch (type) {
            case 4: 
            case 5: {
                return PgResultSet.toInt(text);
            }
            case -5: {
                return PgResultSet.toLong(text);
            }
            case 2: {
                return PgResultSet.toBigDecimal(text);
            }
            case 7: {
                return Float.valueOf(PgResultSet.toFloat(text));
            }
            case 8: {
                return PgResultSet.toDouble(text);
            }
            case 91: {
                if (oid == 3807) {
                    return text;
                }
                return connection.getTimestampUtils().toDate(null, text);
            }
            case 92: {
                if (oid == 3807) {
                    return text;
                }
                return connection.getTimestampUtils().toTime(null, text);
            }
            case 93: {
                if (oid == 3807) {
                    return text;
                }
                return connection.getTimestampUtils().toTimestamp(null, text);
            }
        }
        return text;
    }

    private static String processBackslashChar(String attributeValue) {
        if (attributeValue.contains(BACKSLASH_STRING)) {
            char[] charArray;
            StringBuilder sb = new StringBuilder();
            for (char ch : charArray = attributeValue.toCharArray()) {
                if (ch == '\\') {
                    sb.append(DOUBLE_BACKSLASH_STRING);
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
        return attributeValue;
    }

    private static String processDoubleBackslashStr(String attributeValue) {
        if (attributeValue.contains(DOUBLE_BACKSLASH_STRING)) {
            attributeValue = attributeValue.replace(DOUBLE_BACKSLASH_STRING, BACKSLASH_STRING);
        }
        return attributeValue;
    }
}

