/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DmdbDataSource;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class DmdbDataSourceFactory
implements ObjectFactory {
    protected static final String dataSourceClassName = DmdbDataSource.class.getName();

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        DmdbDataSource retObject = null;
        String className = ref.getClassName();
        if (className.equals(dataSourceClassName)) {
            retObject = new DmdbDataSource();
        }
        if (retObject == null) {
            return null;
        }
        DmdbDataSource ds = retObject;
        StringRefAddr stringRefAddr = null;
        stringRefAddr = (StringRefAddr)ref.get(Configuration.host.getName());
        if (stringRefAddr != null) {
            ds.setServer((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)ref.get(Configuration.port.getName())) != null) {
            String port = (String)stringRefAddr.getContent();
            ds.setPort(Integer.parseInt(port));
        }
        if ((stringRefAddr = (StringRefAddr)ref.get(Configuration.url.getName())) != null) {
            ds.setURL((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)ref.get(Configuration.user.getName())) != null) {
            ds.setUser((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)ref.get(Configuration.password.getName())) != null) {
            ds.setPassword((String)stringRefAddr.getContent());
        }
        return ds;
    }
}

