/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.aeprocessor.aetree.value;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.support.exceptions.ErrorException;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AEProxyColumn
extends AEValueExpr {
    private static final int NUM_CHILDREN = 0;
    private AEValueExpr m_refToValue;
    private AEQueryScope m_resolvedQueryScope;
    private int m_columnNumber;
    private AERelationalExpr m_relExpr;

    public AEProxyColumn(AEValueExpr aEValueExpr, AEQueryScope aEQueryScope, int n) {
        assert (null != aEQueryScope && null != aEValueExpr);
        this.m_refToValue = aEValueExpr;
        this.m_resolvedQueryScope = aEQueryScope;
        this.m_columnNumber = n;
    }

    public AEProxyColumn(AEProxyColumn aEProxyColumn) {
        this.m_columnNumber = aEProxyColumn.m_columnNumber;
        this.m_resolvedQueryScope = aEProxyColumn.m_resolvedQueryScope;
        this.m_refToValue = null;
        this.m_relExpr = aEProxyColumn.m_relExpr;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public Iterator<? extends IAENode> getChildItr() {
        return Collections.emptyList().iterator();
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (iAENode == this) {
            return true;
        }
        if (!(iAENode instanceof AEProxyColumn)) {
            return false;
        }
        AEProxyColumn aEProxyColumn = (AEProxyColumn)iAENode;
        return aEProxyColumn.m_relExpr == this.m_relExpr && aEProxyColumn.m_columnNumber == this.m_columnNumber;
    }

    @Override
    public IColumn getColumn() {
        return this.m_refToValue.getColumn();
    }

    public AEValueExpr getReferToValue() {
        return this.m_refToValue;
    }

    public AEQueryScope getResolvedQueryScope() {
        return this.m_resolvedQueryScope;
    }

    public int getColumnNumber() {
        return this.m_columnNumber;
    }

    @Override
    public AEProxyColumn copy() {
        return new AEProxyColumn(this);
    }

    public AERelationalExpr getRelationalExpr() {
        return this.m_relExpr;
    }

    @Override
    public String getLogString() {
        String string = super.getLogString();
        IColumn iColumn = this.getColumn();
        if (iColumn.isUnnamed()) {
            string = string + ": column #" + Integer.toString(this.getColumnNumber());
        } else {
            String string2;
            String string3;
            StringBuilder stringBuilder = new StringBuilder(30);
            stringBuilder.append(string);
            stringBuilder.append(": ");
            String string4 = iColumn.getCatalogName();
            if (null != string4 && string4.length() > 0) {
                stringBuilder.append(string4);
                stringBuilder.append(".");
            }
            if (null != (string3 = iColumn.getSchemaName()) && string3.length() > 0) {
                stringBuilder.append(string3);
                stringBuilder.append(".");
            }
            if (null != (string2 = iColumn.getTableName()) && string2.length() > 0) {
                stringBuilder.append(string2);
                stringBuilder.append(".");
            }
            stringBuilder.append(iColumn.getName());
            string = stringBuilder.toString();
        }
        return string;
    }

    public void setRelationalExpr(AERelationalExpr aERelationalExpr) {
        this.m_relExpr = aERelationalExpr;
    }

    @Override
    public void updateColumn() throws ErrorException {
    }
}

