/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.jdbc.jdbc41;

import com.cloudera.dsi.core.utilities.ClientInfoData;
import com.cloudera.dsi.dataengine.interfaces.IResultSet;
import com.cloudera.dsi.dataengine.utilities.MetadataSourceID;
import com.cloudera.dsi.dataengine.utilities.OrderType;
import com.cloudera.exceptions.ExceptionConverter;
import com.cloudera.jdbc.common.SConnection;
import com.cloudera.jdbc.common.SStatement;
import com.cloudera.jdbc.common4.C4SDatabaseMetaData;
import com.cloudera.jdbc.common4.utilities.ClientInfoPropertiesMetadataSource;
import com.cloudera.jdbc.jdbc41.S41MetaDataProxy;
import com.cloudera.jdbc.jdbc41.utilities.ClientInfoPropertiesResultSet;
import com.cloudera.support.ILogger;
import com.cloudera.support.LogUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class S41DatabaseMetaData
extends C4SDatabaseMetaData {
    protected static final Map<Long, String> STRING_FUNCTION_NAME_MAP = new LinkedHashMap<Long, String>(){
        private static final long serialVersionUID = 3820949621627913482L;
        {
            this.put(0L, null);
            this.put(8192L, "ASCII");
            this.put(524288L, "BIT_LENGTH");
            this.put(16384L, "CHAR");
            this.put(0x100000L, "CHAR_LENGTH");
            this.put(0x200000L, "CHARACTER_LENGTH");
            this.put(1L, "CONCAT");
            this.put(32768L, "DIFFERENCE");
            this.put(2L, "INSERT");
            this.put(64L, "LCASE");
            this.put(4L, "LEFT");
            this.put(16L, "LENGTH");
            this.put(32L, "LOCATE");
            this.put(65536L, "LOCATE2");
            this.put(8L, "LTRIM");
            this.put(0x400000L, "OCTET_LENGTH");
            this.put(0x800000L, "POSITION");
            this.put(128L, "REPEAT");
            this.put(256L, "REPLACE");
            this.put(512L, "RIGHT");
            this.put(1024L, "RTRIM");
            this.put(131072L, "SOUNDEX");
            this.put(262144L, "SPACE");
            this.put(2048L, "SUBSTRING");
            this.put(4096L, "UCASE");
        }
    };
    private static final Map<Long, String> TIME_FUNCTION_NAME_MAP = new LinkedHashMap<Long, String>(){
        private static final long serialVersionUID = 579644677990089015L;
        {
            this.put(0L, null);
            this.put(2L, "CURDATE");
            this.put(131072L, "CURRENT_DATE");
            this.put(262144L, "CURRENT_TIME");
            this.put(524288L, "CURRENT_TIMESTAMP");
            this.put(512L, "CURTIME");
            this.put(32768L, "DAYNAME");
            this.put(4L, "DAYOFMONTH");
            this.put(8L, "DAYOFWEEK");
            this.put(16L, "DAYOFYEAR");
            this.put(0x100000L, "EXTRACT");
            this.put(1024L, "HOUR");
            this.put(2048L, "MINUTE");
            this.put(32L, "MONTH");
            this.put(65536L, "MONTHNAME");
            this.put(1L, "NOW");
            this.put(64L, "QUARTER");
            this.put(4096L, "SECOND");
            this.put(8192L, "TIMESTAMPADD");
            this.put(16384L, "TIMESTAMPDIFF");
            this.put(128L, "WEEK");
            this.put(256L, "YEAR");
        }
    };
    private static final int JDBC_MINOR_VERSION = 1;

    public S41DatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        super(sConnection, iLogger);
    }

    @Override
    protected synchronized ResultSet createMetaDataResult(MetadataSourceID metadataSourceID, List<String> list) throws SQLException {
        try {
            IResultSet iResultSet = this.m_dataEngine.makeNewMetadataResult(metadataSourceID, (ArrayList)list, this.getSearchStringEscape(), this.getIdentifierQuoteString(), false, OrderType.JDBC_41);
            S41MetaDataProxy s41MetaDataProxy = new S41MetaDataProxy(this, iResultSet, metadataSourceID, this.m_logger);
            this.m_resultSets.add(s41MetaDataProxy);
            return s41MetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    protected synchronized ResultSet createNullMetaDataResult(MetadataSourceID metadataSourceID) throws SQLException {
        try {
            S41MetaDataProxy s41MetaDataProxy = new S41MetaDataProxy(this, null, metadataSourceID, this.m_logger);
            this.m_resultSets.add(s41MetaDataProxy);
            return s41MetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    protected synchronized ResultSet createUnorderedMetaDataResult(MetadataSourceID metadataSourceID, List<String> list) throws SQLException {
        try {
            IResultSet iResultSet = this.m_dataEngine.makeNewMetadataResult(metadataSourceID, (ArrayList)list, this.getSearchStringEscape(), this.getIdentifierQuoteString(), false, OrderType.NONE);
            S41MetaDataProxy s41MetaDataProxy = new S41MetaDataProxy(this, iResultSet, metadataSourceID, this.m_logger);
            this.m_resultSets.add(s41MetaDataProxy);
            return s41MetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return 1;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getStringFunctions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(104);
            return this.createListFromMap(STRING_FUNCTION_NAME_MAP, l);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(135);
            return this.createListFromMap(TIME_FUNCTION_NAME_MAP, l);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        Map<String, ClientInfoData> map = this.m_parentConnection.getConnection().getClientInfoProperties();
        return new ClientInfoPropertiesResultSet((SStatement)this.m_parentConnection.createStatement(), new ClientInfoPropertiesMetadataSource(map), this.m_logger);
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3, string4);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            return this.createMetaDataResult(MetadataSourceID.PSEUDO_COLUMNS_JDBC41, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }
}

