/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.dsiext.dataengine;

import com.cloudera.dsi.core.impl.DSIDriver;
import com.cloudera.dsi.dataengine.interfaces.IResultSet;
import com.cloudera.dsi.utilities.DSIMessageKey;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.support.exceptions.ErrorException;
import com.cloudera.support.exceptions.ExceptionType;
import java.util.BitSet;

public abstract class DSIExtJResultSet
implements IResultSet {
    private BitSet m_needData;

    public abstract String getCatalogName();

    public boolean getDataNeeded(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Negative colNum: " + n);
        }
        if (null != this.m_needData && this.m_needData.size() > n) {
            return this.m_needData.get(n);
        }
        return false;
    }

    public int getFetchSize() throws ErrorException {
        return 0;
    }

    public final boolean hasMoreRows() throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("IResult.hasMoreRows()");
    }

    public abstract String getSchemaName();

    public abstract String getTableName();

    public void onFinishDMLBatch() {
    }

    public void onFinishRowUpdate() {
    }

    public void onStartDMLBatch(DMLType dMLType, long l) {
    }

    public void onStartRowUpdate() {
    }

    public abstract void reset() throws ErrorException;

    public int resolveColumn(DSIExtJResultSet dSIExtJResultSet, int n) throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    public boolean rowDeleted() {
        return false;
    }

    public boolean rowInserted() {
        return false;
    }

    public boolean rowUpdated() {
        return false;
    }

    public void setDataNeeded(int n, boolean bl) throws ErrorException {
        if (0 >= n + 1) {
            throw new IndexOutOfBoundsException("Column number " + n + " out of bounds.");
        }
        if (null == this.m_needData) {
            this.m_needData = new BitSet(Math.max(this.getSelectColumns().size(), n + 1));
        } else if (this.m_needData.size() <= n) {
            BitSet bitSet = new BitSet(Math.max((this.m_needData.size() + 1) / 2 * 3, n + 1));
            bitSet.or(this.m_needData);
            this.m_needData = bitSet;
        }
        this.m_needData.set(n, bl);
    }

    public void setFetchSize(int n) throws ErrorException {
    }

    public final boolean supportsHasMoreRows() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DMLType {
        INSERT,
        UPDATE,
        DELETE;

    }
}

