/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.jdbc41;

import com.cloudera.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.exceptions.ExceptionConverter;
import com.cloudera.hivecommon.api.HiveExecutionContext;
import com.cloudera.hivecommon.dataengine.HiveJDBCResultSet;
import com.cloudera.jdbc.common.SStatement;
import com.cloudera.jdbc.jdbc41.S41ForwardResultSet;
import com.cloudera.support.ILogger;
import com.cloudera.support.exceptions.ErrorException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class Hive41ForwardResultSet
extends S41ForwardResultSet
implements ResultSet {
    private boolean m_columnMapInitialized = false;
    private HiveExecutionContext m_context = ((HiveJDBCResultSet)this.m_resultSet).getContext();

    public Hive41ForwardResultSet(SStatement sStatement, HiveJDBCResultSet hiveJDBCResultSet, ILogger iLogger) throws SQLException {
        super(sStatement, hiveJDBCResultSet, iLogger);
    }

    @Override
    public int findColumn(String string) throws SQLException {
        this.checkIfValidRowNumber();
        return super.findColumn(string);
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.m_context.m_isExecutionComplete) {
            try {
                this.pollAndInitializeColumns();
            }
            catch (ErrorException errorException) {
                throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener, this.m_logger);
            }
        }
        if (!this.m_columnMapInitialized) {
            this.initializeColumnNameMap();
            this.m_columnMapInitialized = true;
        }
        return super.next();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (!this.m_context.m_isExecutionComplete) {
            try {
                this.pollAndInitializeColumns();
            }
            catch (ErrorException errorException) {
                throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener, this.m_logger);
            }
        }
        return super.getMetaData();
    }

    @Override
    protected DataWrapper getData(int n, long l) throws SQLException {
        this.checkIfValidRowNumber();
        return super.getData(n, l);
    }

    @Override
    protected void initializeColumnNameMap() throws SQLException {
        if (this.m_context.m_isExecutionComplete) {
            super.initializeColumnNameMap();
        }
    }

    protected void pollAndInitializeColumns() throws ErrorException {
        ((HiveJDBCResultSet)this.m_resultSet).updateSelectColumns();
        this.initializeResultSetColumns();
    }
}

