/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util.buffer;

import dm.jdbc.util.buffer.BufferNode;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class ByteBufferNode
extends BufferNode<ByteBuffer> {
    ByteBufferNode(int capacity, boolean direct) {
        super(direct ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity), capacity);
        ((ByteBuffer)this.buffer).order(ByteOrder.LITTLE_ENDIAN);
    }

    ByteBufferNode(byte[] bytes, int offset, int length) {
        super(ByteBuffer.wrap(bytes, 0, bytes.length), bytes.length);
        ((ByteBuffer)this.buffer).order(ByteOrder.LITTLE_ENDIAN);
        this.read = offset;
        this.write = offset + length;
        this.extra = 0;
    }

    @Override
    public void clear(int offset) {
        this.write = offset;
        if (this.read > offset) {
            this.read = offset;
        }
    }

    @Override
    public void rewind(int offset) {
        this.read = offset;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int length(boolean forWrite) {
        return forWrite ? this.write : this.read;
    }

    @Override
    public int offset(boolean forWrite) {
        return forWrite ? this.write : this.read;
    }

    @Override
    public int available(boolean forWrite) {
        return forWrite ? this.capacity - this.write : this.write - this.read;
    }

    @Override
    public int skip(int length, boolean forWrite, boolean forward) {
        int can;
        int n2 = can = forward ? this.available(forWrite) : this.length(forWrite);
        if (length > can) {
            length = can;
        }
        if (forward) {
            if (forWrite) {
                int i2 = 0;
                while (i2 < length) {
                    ((ByteBuffer)this.buffer).put(this.write++, (byte)0);
                    ++i2;
                }
            } else {
                this.read += length;
            }
        } else if (forWrite) {
            this.write -= length;
        } else {
            this.read -= length;
        }
        return length;
    }

    @Override
    public int load(Object object, int len, boolean fully) throws IOException {
        int available;
        int n2 = available = fully ? this.capacity : this.available(true);
        if (len > available) {
            len = available;
        }
        int orgPosition = ((ByteBuffer)this.buffer).position();
        int orgLimit = ((ByteBuffer)this.buffer).limit();
        ((ByteBuffer)this.buffer).position(fully ? 0 : this.write);
        ((ByteBuffer)this.buffer).limit(fully ? len : this.write + len);
        int llen = 0;
        while (llen < len) {
            int ret = ((ReadableByteChannel)object).read((ByteBuffer)this.buffer);
            if (ret < 0) {
                throw new EOFException();
            }
            llen += ret;
        }
        this.write += llen;
        ((ByteBuffer)this.buffer).position(orgPosition);
        ((ByteBuffer)this.buffer).limit(orgLimit);
        return llen;
    }

    @Override
    public int flush(Object object, boolean fully) throws IOException {
        int orgPosition = ((ByteBuffer)this.buffer).position();
        int orgLimit = ((ByteBuffer)this.buffer).limit();
        ((ByteBuffer)this.buffer).position(fully ? 0 : this.read);
        ((ByteBuffer)this.buffer).limit(fully ? this.capacity : this.write);
        int flen = ((WritableByteChannel)object).write((ByteBuffer)this.buffer);
        this.read += flen;
        ((ByteBuffer)this.buffer).position(orgPosition);
        ((ByteBuffer)this.buffer).limit(orgLimit);
        return flen;
    }

    @Override
    public int writeByte(byte b2) {
        ((ByteBuffer)this.buffer).put(this.write, b2);
        ++this.write;
        return 1;
    }

    @Override
    public int writeShort(short s2) {
        ((ByteBuffer)this.buffer).putShort(this.write, s2);
        this.write += 2;
        return 2;
    }

    @Override
    public int writeInt(int i2) {
        ((ByteBuffer)this.buffer).putInt(this.write, i2);
        this.write += 4;
        return 4;
    }

    @Override
    public int writeLong(long l2) {
        ((ByteBuffer)this.buffer).putLong(this.write, l2);
        this.write += 8;
        return 8;
    }

    @Override
    public int writeFloat(float f2) {
        ((ByteBuffer)this.buffer).putFloat(this.write, f2);
        this.write += 4;
        return 4;
    }

    @Override
    public int writeDouble(double d2) {
        ((ByteBuffer)this.buffer).putDouble(this.write, d2);
        this.write += 8;
        return 8;
    }

    @Override
    public int writeUB1(int i2) {
        ((ByteBuffer)this.buffer).put(this.write, (byte)i2);
        ++this.write;
        return 1;
    }

    @Override
    public int writeUB2(int i2) {
        ((ByteBuffer)this.buffer).putShort(this.write, (short)i2);
        this.write += 2;
        return 2;
    }

    @Override
    public int writeUB4(long l2) {
        ((ByteBuffer)this.buffer).putInt(this.write, (int)l2);
        this.write += 4;
        return 4;
    }

    @Override
    public int writeBytes(byte[] srcBytes, int srcOffset, int len) {
        int orgPosition = ((ByteBuffer)this.buffer).position();
        int orgLimit = ((ByteBuffer)this.buffer).limit();
        ((ByteBuffer)this.buffer).position(this.write);
        ((ByteBuffer)this.buffer).limit(this.capacity);
        ((ByteBuffer)this.buffer).put(srcBytes, srcOffset, len);
        this.write += len;
        ((ByteBuffer)this.buffer).position(orgPosition);
        ((ByteBuffer)this.buffer).limit(orgLimit);
        return len;
    }

    @Override
    public byte readByte() {
        byte bv = ((ByteBuffer)this.buffer).get(this.read);
        ++this.read;
        return bv;
    }

    @Override
    public short readShort() {
        short sv = ((ByteBuffer)this.buffer).getShort(this.read);
        this.read += 2;
        return sv;
    }

    @Override
    public int readInt() {
        int iv = ((ByteBuffer)this.buffer).getInt(this.read);
        this.read += 4;
        return iv;
    }

    @Override
    public long readLong() {
        long lv = ((ByteBuffer)this.buffer).getLong(this.read);
        this.read += 8;
        return lv;
    }

    @Override
    public float readFloat() {
        float fv = ((ByteBuffer)this.buffer).getFloat(this.read);
        this.read += 4;
        return fv;
    }

    @Override
    public double readDouble() {
        double dv = ((ByteBuffer)this.buffer).getDouble(this.read);
        this.read += 8;
        return dv;
    }

    @Override
    public int readUB1() {
        byte bv = ((ByteBuffer)this.buffer).get(this.read);
        ++this.read;
        return 0xFF & bv;
    }

    @Override
    public int readUB2() {
        short sv = ((ByteBuffer)this.buffer).getShort(this.read);
        this.read += 2;
        return 0xFFFF & sv;
    }

    @Override
    public long readUB4() {
        int iv = ((ByteBuffer)this.buffer).getInt(this.read);
        this.read += 4;
        return 0xFFFFFFFF & iv;
    }

    @Override
    public int readBytes(byte[] objBytes, int objOffset, int len) {
        int orgPosition = ((ByteBuffer)this.buffer).position();
        int orgLimit = ((ByteBuffer)this.buffer).limit();
        ((ByteBuffer)this.buffer).position(this.read);
        ((ByteBuffer)this.buffer).limit(this.write);
        ((ByteBuffer)this.buffer).get(objBytes, objOffset, len);
        this.read += len;
        ((ByteBuffer)this.buffer).position(orgPosition);
        ((ByteBuffer)this.buffer).limit(orgLimit);
        return len;
    }

    @Override
    public int setByte(int offset, byte b2) {
        ((ByteBuffer)this.buffer).put(offset, b2);
        return 1;
    }

    @Override
    public int setShort(int offset, short s2) {
        ((ByteBuffer)this.buffer).putShort(offset, s2);
        return 2;
    }

    @Override
    public int setInt(int offset, int i2) {
        ((ByteBuffer)this.buffer).putInt(offset, i2);
        return 4;
    }

    @Override
    public int setLong(int offset, long l2) {
        ((ByteBuffer)this.buffer).putLong(offset, l2);
        return 8;
    }

    @Override
    public int setFloat(int offset, float f2) {
        ((ByteBuffer)this.buffer).putFloat(offset, f2);
        return 4;
    }

    @Override
    public int setDouble(int offset, double d2) {
        ((ByteBuffer)this.buffer).putDouble(offset, d2);
        return 8;
    }

    @Override
    public int setUB1(int offset, int i2) {
        ((ByteBuffer)this.buffer).put(offset, (byte)i2);
        return 1;
    }

    @Override
    public int setUB2(int offset, int i2) {
        ((ByteBuffer)this.buffer).putShort(offset, (short)i2);
        return 2;
    }

    @Override
    public int setUB4(int offset, long l2) {
        ((ByteBuffer)this.buffer).putInt(offset, (int)l2);
        return 4;
    }

    @Override
    public int setBytes(int offset, byte[] srcBytes, int srcOffset, int len) {
        int orgPosition = ((ByteBuffer)this.buffer).position();
        int orgLimit = ((ByteBuffer)this.buffer).limit();
        ((ByteBuffer)this.buffer).position(offset);
        ((ByteBuffer)this.buffer).limit(this.capacity);
        ((ByteBuffer)this.buffer).put(srcBytes, srcOffset, len);
        ((ByteBuffer)this.buffer).position(orgPosition);
        ((ByteBuffer)this.buffer).limit(orgLimit);
        return len;
    }

    @Override
    public byte getByte(int offset) {
        return ((ByteBuffer)this.buffer).get(offset);
    }

    @Override
    public short getShort(int offset) {
        return ((ByteBuffer)this.buffer).getShort(offset);
    }

    @Override
    public int getInt(int offset) {
        return ((ByteBuffer)this.buffer).getInt(offset);
    }

    @Override
    public long getLong(int offset) {
        return ((ByteBuffer)this.buffer).getLong(offset);
    }

    @Override
    public float getFloat(int offset) {
        return ((ByteBuffer)this.buffer).getFloat(offset);
    }

    @Override
    public double getDouble(int offset) {
        return ((ByteBuffer)this.buffer).getDouble(offset);
    }

    @Override
    public int getUB1(int offset) {
        return 0xFF & ((ByteBuffer)this.buffer).get(offset);
    }

    @Override
    public int getUB2(int offset) {
        return 0xFFFF & ((ByteBuffer)this.buffer).getShort(offset);
    }

    @Override
    public long getUB4(int offset) {
        return 0xFFFFFFFF & ((ByteBuffer)this.buffer).getInt(offset);
    }

    @Override
    public int getBytes(int offset, byte[] objBytes, int objOffset, int len) {
        int orgPosition = ((ByteBuffer)this.buffer).position();
        int orgLimit = ((ByteBuffer)this.buffer).limit();
        ((ByteBuffer)this.buffer).position(offset);
        ((ByteBuffer)this.buffer).limit(this.capacity);
        ((ByteBuffer)this.buffer).get(objBytes, objOffset, len);
        ((ByteBuffer)this.buffer).position(orgPosition);
        ((ByteBuffer)this.buffer).limit(orgLimit);
        return len;
    }
}

