/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat;

import dm.jdbc.driver.Configuration;
import dm.jdbc.filter.stat.BaseStat;
import dm.jdbc.filter.stat.ConnectionStatValue;
import dm.jdbc.filter.stat.SqlStat;
import dm.jdbc.filter.stat.SqlStatValue;
import dm.jdbc.internal.conf.DmSvcConf;
import dm.jdbc.util.IDGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.JMException;

public class ConnectionStat
extends BaseStat {
    private String id;
    private String url;
    private volatile long connCount;
    private volatile long activeConnCount;
    private volatile long maxActiveConnCount;
    private volatile long executeCount;
    private volatile long errorCount;
    private volatile long stmtCount;
    private volatile long activeStmtCount;
    private volatile long maxActiveStmtCount;
    private volatile long commitCount;
    private volatile long rollbackCount;
    private volatile long clobOpenCount;
    private volatile long blobOpenCount;
    AtomicLongFieldUpdater<ConnectionStat> connCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "connCount");
    AtomicLongFieldUpdater<ConnectionStat> activeConnCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "activeConnCount");
    AtomicLongFieldUpdater<ConnectionStat> maxActiveConnCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "maxActiveConnCount");
    AtomicLongFieldUpdater<ConnectionStat> executeCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "executeCount");
    AtomicLongFieldUpdater<ConnectionStat> errorCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "errorCount");
    AtomicLongFieldUpdater<ConnectionStat> stmtCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "stmtCount");
    AtomicLongFieldUpdater<ConnectionStat> activeStmtCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "activeStmtCount");
    AtomicLongFieldUpdater<ConnectionStat> maxActiveStmtCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "maxActiveStmtCount");
    AtomicLongFieldUpdater<ConnectionStat> commitCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "commitCount");
    AtomicLongFieldUpdater<ConnectionStat> rollbackCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "rollbackCount");
    AtomicLongFieldUpdater<ConnectionStat> clobOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "clobOpenCount");
    AtomicLongFieldUpdater<ConnectionStat> blobOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectionStat.class, "blobOpenCount");
    private LinkedHashMap<String, SqlStat> sqlStatMap;
    private int maxSqlSize;
    private AtomicLong skipSqlCount;
    private ReentrantReadWriteLock lock;
    private String properties;

    public ConnectionStat(String url) {
        this.maxSqlSize = DmSvcConf.GLOBAL.statSqlMaxCount;
        this.skipSqlCount = new AtomicLong();
        this.lock = new ReentrantReadWriteLock();
        this.properties = "";
        this.id = "DS" + IDGenerator.generateId();
        this.url = url;
        this.sqlStatMap = new LinkedHashMap(200, 0.75f, false);
    }

    public SqlStat createSqlStat(String sql) {
        this.lock.writeLock().lock();
        try {
            SqlStat sqlStat = this.sqlStatMap.get(sql);
            if (sqlStat == null) {
                sqlStat = new SqlStat(sql);
                sqlStat.setDataSource(this.url);
                sqlStat.setDataSourceId(this.id);
                if (this.putSqlStat(sqlStat)) {
                    SqlStat sqlStat2 = sqlStat;
                    return sqlStat2;
                }
                return null;
            }
            SqlStat sqlStat3 = sqlStat;
            return sqlStat3;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean putSqlStat(SqlStat sqlStat) {
        if (this.maxSqlSize > 0 && this.sqlStatMap.size() == this.maxSqlSize) {
            if (DmSvcConf.GLOBAL.statSqlRemoveMode == Configuration.STAT_SQL_REMOVE_OLDEST) {
                SqlStat removeSqlStat = this.eliminateSqlStat();
                if (removeSqlStat.getRunningCount() > 0L || removeSqlStat.getExecuteCount() > 0L) {
                    this.skipSqlCount.incrementAndGet();
                }
                this.sqlStatMap.put(sqlStat.getSql(), sqlStat);
                return true;
            }
            if (sqlStat.getRunningCount() > 0L || sqlStat.getExecuteCount() > 0L) {
                this.skipSqlCount.incrementAndGet();
            }
            return false;
        }
        this.sqlStatMap.put(sqlStat.getSql(), sqlStat);
        return true;
    }

    private SqlStat eliminateSqlStat() {
        Iterator<Map.Entry<String, SqlStat>> iter;
        Map.Entry<String, SqlStat> item;
        if (this.maxSqlSize > 0 && this.sqlStatMap.size() == this.maxSqlSize && DmSvcConf.GLOBAL.statSqlRemoveMode == Configuration.STAT_SQL_REMOVE_OLDEST && (item = (iter = this.sqlStatMap.entrySet().iterator()).next()) != null) {
            iter.remove();
            return item.getValue();
        }
        return null;
    }

    public Map<String, SqlStat> getSqlStatMap() {
        LinkedHashMap<String, SqlStat> map = new LinkedHashMap<String, SqlStat>(this.sqlStatMap.size());
        this.lock.readLock().lock();
        try {
            map.putAll(this.sqlStatMap);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return map;
    }

    public List<SqlStatValue> getSqlStatMapAndReset() {
        ArrayList<SqlStat> stats = new ArrayList<SqlStat>(this.sqlStatMap.size());
        this.lock.writeLock().lock();
        try {
            Iterator<Map.Entry<String, SqlStat>> iter = this.sqlStatMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, SqlStat> entry = iter.next();
                SqlStat stat = entry.getValue();
                if (stat.getExecuteCount() == 0L && stat.getRunningCount() == 0L) {
                    stat.setRemoved(true);
                    iter.remove();
                    continue;
                }
                stats.add(entry.getValue());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        ArrayList<SqlStatValue> values = new ArrayList<SqlStatValue>(stats.size());
        for (SqlStat stat : stats) {
            SqlStatValue value = stat.getValueAndReset();
            if (value.getExecuteCount() == 0L && value.getRunningCount() == 0) continue;
            values.add(value);
        }
        return values;
    }

    public void incrementConn() {
        this.connCountUpdater.incrementAndGet(this);
        this.activeConnCountUpdater.incrementAndGet(this);
        long count = this.activeConnCountUpdater.get(this);
        if (count > this.maxActiveConnCountUpdater.get(this)) {
            this.maxActiveConnCountUpdater.set(this, count);
        }
    }

    public void decrementConn() {
        this.activeConnCountUpdater.decrementAndGet(this);
    }

    public long getActiveConnCount() {
        return this.activeConnCount;
    }

    public long getConnCount() {
        return this.connCount;
    }

    public long getMaxActiveConnCount() {
        return this.maxActiveConnCount;
    }

    public void incrementStmt() {
        this.stmtCountUpdater.incrementAndGet(this);
        this.activeStmtCountUpdater.incrementAndGet(this);
        long count = this.activeStmtCountUpdater.get(this);
        if (count > this.maxActiveStmtCountUpdater.get(this)) {
            this.maxActiveStmtCountUpdater.set(this, count);
        }
    }

    public void decrementStmt() {
        this.activeStmtCountUpdater.decrementAndGet(this);
    }

    public void decrementStmt(int activeStmtCount) {
        this.activeStmtCountUpdater.addAndGet(this, -activeStmtCount);
    }

    public long getActiveStmtCount() {
        return this.activeStmtCount;
    }

    public long getStmtCount() {
        return this.stmtCount;
    }

    public long getMaxActiveStmtCount() {
        return this.maxActiveStmtCount;
    }

    public void incrementExecuteCount() {
        this.executeCountUpdater.incrementAndGet(this);
    }

    public void incrementErrorCount() {
        this.errorCountUpdater.incrementAndGet(this);
    }

    public void incrementCommitCount() {
        this.commitCountUpdater.incrementAndGet(this);
    }

    public void incrementRollbackCount() {
        this.rollbackCountUpdater.incrementAndGet(this);
    }

    public long getCommitCount() {
        return this.commitCount;
    }

    public long getRollbackCount() {
        return this.rollbackCount;
    }

    public ConnectionStatValue getValue(boolean reset) {
        ConnectionStatValue val = new ConnectionStatValue();
        val.setId(this.id);
        val.setUrl(this.url);
        val.setConnCount(ConnectionStat.get(this, this.connCountUpdater, reset));
        val.setActiveConnCount(ConnectionStat.get(this, this.activeConnCountUpdater, false));
        val.setMaxActiveConnCount(ConnectionStat.get(this, this.maxActiveConnCountUpdater, false));
        val.setStmtCount(ConnectionStat.get(this, this.stmtCountUpdater, reset));
        val.setActiveStmtCount(ConnectionStat.get(this, this.activeStmtCountUpdater, false));
        val.setMaxActiveStmtCount(ConnectionStat.get(this, this.maxActiveStmtCountUpdater, false));
        val.setCommitCount(ConnectionStat.get(this, this.commitCountUpdater, reset));
        val.setRollbackCount(ConnectionStat.get(this, this.rollbackCountUpdater, reset));
        val.setExecuteCount(ConnectionStat.get(this, this.executeCountUpdater, reset));
        val.setErrorCount(ConnectionStat.get(this, this.errorCountUpdater, reset));
        val.setBlobOpenCount(ConnectionStat.get(this, this.blobOpenCountUpdater, reset));
        val.setClobOpenCount(ConnectionStat.get(this, this.clobOpenCountUpdater, reset));
        val.setProperties(this.properties);
        return val;
    }

    public Map<String, Object> getData() throws JMException {
        return this.getValue(false).getData();
    }

    public ConnectionStatValue getValueAndReset() {
        return this.getValue(true);
    }

    public String getUrl() {
        return this.url;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String getId() {
        return this.id;
    }
}

