/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.log;

import dm.jdbc.internal.conf.DmSvcConf;
import dm.jdbc.internal.processor.BaseFlusher;
import dm.jdbc.util.DateUtil;
import dm.jdbc.util.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class LogWriter
extends BaseFlusher {
    protected static LinkedBlockingQueue<byte[]> flushQueue = new LinkedBlockingQueue();
    private static final int ONE_MIN_MS = 60000;
    private static volatile boolean initFlag = false;
    protected static int maxFileNumber = 5;
    protected static int switchMode = 2;
    protected static int switchLimit = 128;
    private static final int SWITCH_MODE_OFF = 0;
    private static final int SWITCH_MODE_BY_LINE_COUNT = 1;
    private static final int SWITCH_MODE_BY_FILE_SIZE = 2;
    protected volatile AtomicInteger lineCount = new AtomicInteger(0);
    protected long lastTime = System.currentTimeMillis();
    private String realFileName;

    protected LogWriter() {
        super("LogFlusher", DmSvcConf.GLOBAL.logDir, "dm_jdbc", DmSvcConf.GLOBAL.logFlushFreq);
        this.start();
    }

    public static LogWriter getInstance() {
        return LoggerHolder.instance;
    }

    public static void init(int[] props) {
        if (props == null || props.length < 3 || initFlag) {
            return;
        }
        maxFileNumber = props[0];
        switchMode = props[1];
        switchLimit = props[2];
        initFlag = true;
    }

    @Override
    protected void doRun() {
        while (this.flushFreq > 0) {
            try {
                byte[] bytes = flushQueue.poll(DmSvcConf.GLOBAL.logFlushFreq, TimeUnit.SECONDS);
                this.flushProcess(bytes);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    protected void beforeExit() {
        byte[] bytes = null;
        do {
            this.flushProcess(bytes);
        } while ((bytes = flushQueue.poll()) != null);
    }

    public synchronized void write(String msg) {
        try {
            byte[] bytes = msg.getBytes();
            flushQueue.put(bytes);
        }
        catch (InterruptedException interruptedException) {}
    }

    public synchronized void writeLine(String msg) {
        try {
            byte[] bytes = (String.valueOf(StringUtil.trimToEmpty(msg)) + StringUtil.LINE_SEPARATOR).getBytes();
            flushQueue.put(bytes);
        }
        catch (Exception exception) {}
    }

    public synchronized void writeLines(List<String> msgList) {
        if (msgList == null || msgList.isEmpty()) {
            return;
        }
        for (String msg : msgList) {
            this.writeLine(msg);
        }
    }

    @Override
    protected FileOutputStream createNewFile() {
        if (switchMode != 0) {
            this.deleteOldFile();
        }
        try {
            Date date = new Date(System.currentTimeMillis());
            this.dateString = DateUtil.formatDate(date, 1);
            if (this.realFileName == null || switchMode != 0) {
                this.realFileName = String.valueOf(this.filePrefix) + "_" + DateUtil.formatDate(date, 3) + "_" + this.fileNum + this.fileExtension;
            }
            if (StringUtil.isNotEmpty(this.filePath) && StringUtil.isNotEmpty(this.realFileName)) {
                File logPath = new File(this.filePath);
                if (!logPath.exists()) {
                    logPath.mkdirs();
                }
                this.logFile = new File(String.valueOf(this.filePath) + this.realFileName);
                if (!this.logFile.exists()) {
                    this.logFile.createNewFile();
                    ++this.fileNum;
                }
                return new FileOutputStream(this.logFile, true);
            }
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
        return null;
    }

    private void deleteOldFile() {
        File[] files = this.getFiles();
        if (files.length >= maxFileNumber) {
            int i2 = 0;
            while (i2 <= files.length - maxFileNumber) {
                int count = 0;
                while (!files[i2].delete()) {
                    if (count == 3) break;
                    ++count;
                }
                ++i2;
            }
            this.fileNum %= Integer.MAX_VALUE;
        }
    }

    private File[] getFiles() {
        File file = new File(this.filePath);
        Object[] files = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isFile()) {
                    String name = pathname.getName();
                    return name.startsWith(LogWriter.this.filePrefix) && name.indexOf(LogWriter.this.fileExtension) > 0;
                }
                return false;
            }
        });
        files = files == null ? new File[]{} : files;
        Arrays.sort(files);
        return files;
    }

    private synchronized void flushProcess(byte[] bytes) {
        if (bytes != null) {
            this.buffer.putBytes(bytes, 0, bytes.length);
            if (switchMode == 1) {
                this.lineCount.incrementAndGet();
            }
        }
        if (switchMode == 1 && this.lineCount.get() == switchLimit) {
            this.doFlush(this.buffer);
            this.lineCount.set(0);
        }
        if (bytes == null && this.buffer.length() > 0 || this.buffer.length() >= DmSvcConf.GLOBAL.logBufferSize) {
            this.doFlush(this.buffer);
        }
    }

    @Override
    protected boolean needCreateNewFile() {
        boolean overTime;
        if (switchMode == 0) {
            return this.logFile == null;
        }
        if (switchMode == 1) {
            return this.logFile == null || switchLimit == this.lineCount.get();
        }
        if (switchMode == 2) {
            return this.logFile == null || this.logFile.length() >= (long)switchLimit * 1024L * 1024L;
        }
        long currentTime = System.currentTimeMillis();
        boolean bl = overTime = currentTime - this.lastTime >= 60000L * (long)switchLimit;
        if (overTime) {
            this.lastTime = currentTime;
        }
        return this.logFile == null || overTime;
    }

    private static class LoggerHolder {
        private static final LogWriter instance = new LogWriter();

        private LoggerHolder() {
        }
    }
}

