/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.fldr;

import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

public class FldrResultSet
extends DmdbResultSet {
    private LinkedBlockingQueue<Object> rsQueue;
    private int rsCount = 0;
    private List<DmdbResultSet> rsList;
    private DmdbResultSet rRs;

    FldrResultSet(DmdbStatement stmt) throws SQLException {
        super(stmt, null, null);
        this.rsCount = stmt.fldrInfo.getFldrStmtSize();
        this.rsQueue = new LinkedBlockingQueue(this.rsCount);
        this.rsList = new ArrayList<DmdbResultSet>(this.rsCount);
    }

    public void init() throws SQLException {
        if (this.rsCount > 0) {
            this.rRs = this.takeRs();
        }
    }

    public void putRs(Object rs) {
        try {
            this.rsQueue.put(rs);
        }
        catch (Exception exception) {}
    }

    public DmdbResultSet takeRs() throws SQLException {
        Object rs = null;
        try {
            rs = this.rsQueue.take();
        }
        catch (Exception exception) {}
        if (rs instanceof SQLException) {
            throw (SQLException)rs;
        }
        return (DmdbResultSet)rs;
    }

    public synchronized void registRs(DmdbResultSet rs) {
        this.rsList.add(rs);
    }

    public DmdbResultSet getRealRs() {
        return this.rRs;
    }

    @Override
    public boolean do_next() throws SQLException {
        if (this.rsCount == 0) {
            return false;
        }
        if (this.rRs == null) {
            this.rRs = this.takeRs();
        }
        if (FldrResultSet.isFinish(this.rRs)) {
            --this.rsCount;
            if (this.rsCount == 0) {
                return false;
            }
            this.rRs = null;
            return this.do_next();
        }
        if (FldrResultSet.needFetchData(this.rRs)) {
            this.fetchData(this.rRs);
            this.rRs = null;
            return this.do_next();
        }
        return FldrResultSet.nextForFldr(this.rRs);
    }

    private void fetchData(final DmdbResultSet rs) throws SQLException {
        this.statement.connection.fldrInfo.fldrExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    rs.fetchData(rs.currentPos + 1L);
                    FldrResultSet.this.putRs(rs);
                }
                catch (SQLException e2) {
                    FldrResultSet.this.putRs(e2);
                }
            }
        });
    }

    @Override
    public void do_close() throws SQLException {
        for (ResultSet resultSet : this.rsList) {
            resultSet.close();
        }
    }

    @Override
    public SQLWarning do_getWarnings() throws SQLException {
        SQLWarning sqlWarn = null;
        for (ResultSet resultSet : this.rsList) {
            if (resultSet.getWarnings() == null) continue;
            if (sqlWarn == null) {
                sqlWarn = resultSet.getWarnings();
                continue;
            }
            sqlWarn.setNextWarning(resultSet.getWarnings());
            sqlWarn = resultSet.getWarnings();
            while (sqlWarn.getNextWarning() != null) {
                sqlWarn = sqlWarn.getNextWarning();
            }
        }
        return sqlWarn;
    }

    @Override
    public void do_clearWarnings() throws SQLException {
        for (ResultSet resultSet : this.rsList) {
            resultSet.clearWarnings();
        }
    }

    public static boolean isFinish(DmdbResultSet rs) {
        return rs.currentPos >= rs.totalRowCount - 1L;
    }

    public static boolean needFetchData(DmdbResultSet rs) throws SQLException {
        if (FldrResultSet.isFinish(rs)) {
            return false;
        }
        return rs.currentPos >= rs.datasStartPos + (long)rs.datas.length - 1L;
    }

    public static boolean nextForFldr(DmdbResultSet rs) throws SQLException {
        rs.checkClosed();
        if (rs.totalRowCount == 0L) {
            return false;
        }
        if (rs.currentPos >= rs.totalRowCount) {
            return false;
        }
        if (rs.currentPos == rs.totalRowCount - 1L) {
            ++rs.currentPos;
            ++rs.datasOffset;
            return false;
        }
        if (rs.currentPos + 1L < rs.datasStartPos || rs.currentPos + 1L >= rs.datasStartPos + (long)rs.datas.length) {
            ++rs.currentPos;
            ++rs.datasOffset;
            return false;
        }
        ++rs.datasOffset;
        ++rs.currentPos;
        return true;
    }
}

