/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.fldr;

import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.BaseFilter;
import dm.jdbc.filter.fldr.Callback;
import dm.jdbc.filter.fldr.FldrManager;
import dm.jdbc.filter.fldr.FldrResultSet;
import dm.jdbc.internal.conf.DmProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;

public class FldrFilter
extends BaseFilter {
    private FldrFilter() {
    }

    public static FldrFilter getInstance() {
        return new FldrFilter();
    }

    @Override
    public Connection Driver_connect(DmDriver driver, DmProperties props) throws SQLException {
        Connection connection = super.Driver_connect(driver, props);
        FldrManager.createConnection((DmdbConnection)connection);
        return connection;
    }

    @Override
    public void Connection_close(DmdbConnection connection) throws SQLException {
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    try {
                        if (siteObject != null) {
                            siteObject.do_close();
                        }
                    }
                    catch (Exception exception) {}
                }
            });
            connection.fldrInfo.clearFldr();
        }
        super.Connection_close(connection);
    }

    @Override
    public void Connection_commit(DmdbConnection connection) throws SQLException {
        super.Connection_commit(connection);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_commit();
                }
            });
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql) throws SQLException {
        PreparedStatement pstmt = super.Connection_prepareStatement(connection, sql);
        FldrManager.fldrPrepareSql(connection, sql, pstmt);
        return pstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, String[] columnNames) throws SQLException {
        int autoGeneratedKeys = 0;
        if (columnNames != null && columnNames.length > 0) {
            autoGeneratedKeys = 1;
        }
        return this.Connection_prepareStatement(connection, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement pstmt = this.Connection_prepareStatement(connection, sql);
        ((DmdbPreparedStatement)pstmt).autoGeneratedKeys = autoGeneratedKeys;
        if (((DmdbPreparedStatement)pstmt).fldrInfo.fldrStmtMap != null && ((DmdbPreparedStatement)pstmt).fldrInfo.getFldrStmtSize() > 0) {
            for (DmdbStatement temp : ((DmdbPreparedStatement)pstmt).fldrInfo.fldrStmtMap.values()) {
                ((DmdbPreparedStatement)temp).autoGeneratedKeys = autoGeneratedKeys;
            }
        }
        return pstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int[] columnIndexes) throws SQLException {
        int autoGeneratedKeys = 0;
        if (columnIndexes != null && columnIndexes.length > 0) {
            autoGeneratedKeys = 1;
        }
        return this.Connection_prepareStatement(connection, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement pstmt = super.Connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency);
        FldrManager.fldrPrepareSql(connection, sql, pstmt);
        return pstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement pstmt = super.Connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        FldrManager.fldrPrepareSql(connection, sql, pstmt);
        return pstmt;
    }

    @Override
    public void Connection_releaseSavepoint(DmdbConnection connection, final Savepoint savepoint) throws SQLException {
        super.Connection_releaseSavepoint(connection, savepoint);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_releaseSavepoint(savepoint);
                }
            });
        }
    }

    @Override
    public void Connection_rollback(DmdbConnection connection) throws SQLException {
        super.Connection_rollback(connection);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_rollback();
                }
            });
        }
    }

    @Override
    public void Connection_rollback(DmdbConnection connection, final Savepoint savepoint) throws SQLException {
        super.Connection_rollback(connection, savepoint);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_rollback(savepoint);
                }
            });
        }
    }

    @Override
    public void Connection_setAutoCommit(DmdbConnection connection, final boolean autoCommit) throws SQLException {
        super.Connection_setAutoCommit(connection, autoCommit);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_setAutoCommit(autoCommit);
                }
            });
        }
    }

    @Override
    public void Connection_setClientInfo(DmdbConnection connection, final Properties properties) throws SQLClientInfoException {
        super.Connection_setClientInfo(connection, properties);
        if (connection.fldrInfo.fldrConnMap != null) {
            try {
                FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                    @Override
                    void run(DmdbConnection siteObject) throws SQLException {
                        siteObject.do_setClientInfo(properties);
                    }
                });
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void Connection_setClientInfo(DmdbConnection connection, final String name, final String value) throws SQLClientInfoException {
        super.Connection_setClientInfo(connection, name, value);
        if (connection.fldrInfo.fldrConnMap != null) {
            try {
                FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                    @Override
                    void run(DmdbConnection siteObject) throws SQLException {
                        siteObject.do_setClientInfo(name, value);
                    }
                });
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void Connection_setHoldability(DmdbConnection connection, final int holdability) throws SQLException {
        super.Connection_setHoldability(connection, holdability);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_setHoldability(holdability);
                }
            });
        }
    }

    @Override
    public void Connection_setReadOnly(DmdbConnection connection, final boolean readOnly) throws SQLException {
        super.Connection_setReadOnly(connection, readOnly);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_setReadOnly(readOnly);
                }
            });
        }
    }

    @Override
    public Savepoint Connection_setSavepoint(DmdbConnection connection) throws SQLException {
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_setSavepoint();
                }
            });
        }
        return super.Connection_setSavepoint(connection);
    }

    @Override
    public Savepoint Connection_setSavepoint(DmdbConnection connection, final String name) throws SQLException {
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_setSavepoint(name);
                }
            });
        }
        return super.Connection_setSavepoint(connection, name);
    }

    @Override
    public void Connection_setSchema(DmdbConnection connection, final String schema) throws SQLException {
        super.Connection_setSchema(connection, schema);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_setSchema(schema);
                }
            });
        }
    }

    @Override
    public void Connection_setTransactionIsolation(DmdbConnection connection, final int level) throws SQLException {
        super.Connection_setTransactionIsolation(connection, level);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_setTransactionIsolation(level);
                }
            });
        }
    }

    @Override
    public void Connection_setTypeMap(DmdbConnection connection, final Map<String, Class<?>> map) throws SQLException {
        super.Connection_setTypeMap(connection, map);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_setTypeMap(map);
                }
            });
        }
    }

    @Override
    public Statement Connection_createStatement(DmdbConnection connection) throws SQLException {
        DmdbStatement stmt = connection.do_createStatement();
        FldrManager.createStatement(stmt, stmt.getResultSetType(), stmt.getResultSetConcurrency(), stmt.getResultSetHoldability());
        return stmt;
    }

    @Override
    public Statement Connection_createStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbStatement stmt = connection.do_createStatement(resultSetType, resultSetConcurrency);
        FldrManager.createStatement(stmt, stmt.getResultSetType(), stmt.getResultSetConcurrency(), stmt.getResultSetHoldability());
        return stmt;
    }

    @Override
    public Statement Connection_createStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbStatement stmt = connection.do_createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        FldrManager.createStatement(stmt, stmt.getResultSetType(), stmt.getResultSetConcurrency(), stmt.getResultSetHoldability());
        return stmt;
    }

    @Override
    public ResultSet Statement_executeQuery(DmdbStatement statement, final String sql) throws SQLException {
        if (FldrManager.canFldrForSelect(statement)) {
            super.Statement_executeQuery(statement, sql);
            final FldrResultSet fldrRs = new FldrResultSet(statement);
            ExecutorService executor = statement.connection.fldrInfo.fldrExecutor;
            for (final DmdbStatement siteObject : statement.fldrInfo.fldrStmtMap.values()) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DmdbResultSet rs = siteObject.do_executeQuery(sql);
                            fldrRs.registRs(rs);
                            fldrRs.putRs(rs);
                        }
                        catch (SQLException e2) {
                            fldrRs.putRs(e2);
                        }
                    }
                });
            }
            fldrRs.init();
            return fldrRs;
        }
        return super.Statement_executeQuery(statement, sql);
    }

    @Override
    public void Statement_close(DmdbStatement statement) throws SQLException {
        if (statement.fldrInfo.fldrStmtMap != null) {
            FldrManager.doTaskOnEverySite(statement.connection.fldrInfo.fldrExecutor, statement.fldrInfo.fldrStmtMap.values(), statement.fldrInfo.getFldrStmtSize(), new Callback<DmdbStatement>(){

                @Override
                void run(DmdbStatement siteObject) throws SQLException {
                    try {
                        if (siteObject != null) {
                            siteObject.do_close();
                        }
                    }
                    catch (Exception exception) {}
                }
            });
            statement.fldrInfo.clearFldr();
        }
        super.Statement_close(statement);
    }

    @Override
    public void PreparedStatement_addBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        super.PreparedStatement_addBatch(preparedStatement);
        FldrManager.addBatch(preparedStatement);
    }

    @Override
    public int[] PreparedStatement_executeBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        if (this.next != null) {
            return super.PreparedStatement_executeBatch(preparedStatement);
        }
        return FldrManager.executeBatch(preparedStatement);
    }

    @Override
    public void PreparedStatement_clearParameters(DmdbPreparedStatement pstmt) throws SQLException {
        super.PreparedStatement_clearParameters(pstmt);
        if (pstmt.fldrInfo.fldrStmtMap != null) {
            FldrManager.doTaskOnEverySite(pstmt.connection.fldrInfo.fldrExecutor, pstmt.fldrInfo.fldrStmtMap.values(), pstmt.fldrInfo.getFldrStmtSize(), new Callback<DmdbStatement>(){

                @Override
                void run(DmdbStatement siteObject) throws SQLException {
                    ((DmdbPreparedStatement)siteObject).do_clearParameters();
                }
            });
        }
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(DmdbPreparedStatement pstmt) throws SQLException {
        if (FldrManager.canFldrForSelect(pstmt)) {
            super.PreparedStatement_executeQuery(pstmt);
            final FldrResultSet fldrRs = new FldrResultSet(pstmt);
            ExecutorService executor = pstmt.connection.fldrInfo.fldrExecutor;
            final Object[] curRowObjects = pstmt.curRowDatas;
            for (final DmdbStatement siteObject : pstmt.fldrInfo.fldrStmtMap.values()) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (curRowObjects != null) {
                                int i2 = 0;
                                while (i2 < curRowObjects.length) {
                                    ((DmdbPreparedStatement)siteObject).do_setObject(i2 + 1, curRowObjects[i2]);
                                    ++i2;
                                }
                            }
                            DmdbResultSet rs = ((DmdbPreparedStatement)siteObject).do_executeQuery();
                            fldrRs.registRs(rs);
                            fldrRs.putRs(rs);
                        }
                        catch (SQLException e2) {
                            fldrRs.putRs(e2);
                        }
                    }
                });
            }
            fldrRs.init();
            return fldrRs;
        }
        return super.PreparedStatement_executeQuery(pstmt);
    }
}

