/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomains;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timeline.EntityIdentifier;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;

public class TimelineDataManager
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(TimelineDataManager.class);
    @VisibleForTesting
    public static final String DEFAULT_DOMAIN_ID = "DEFAULT";
    private TimelineStore store;
    private TimelineACLsManager timelineACLsManager;

    public TimelineDataManager(TimelineStore store, TimelineACLsManager timelineACLsManager) {
        super(TimelineDataManager.class.getName());
        this.store = store;
        this.timelineACLsManager = timelineACLsManager;
        timelineACLsManager.setTimelineStore(store);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        TimelineDomain domain = this.store.getDomain(DEFAULT_DOMAIN_ID);
        if (domain == null) {
            domain = new TimelineDomain();
            domain.setId(DEFAULT_DOMAIN_ID);
            domain.setDescription("System Default Domain");
            domain.setOwner(UserGroupInformation.getCurrentUser().getShortUserName());
            domain.setReaders("*");
            domain.setWriters("*");
            this.store.put(domain);
        }
        super.serviceInit(conf);
    }

    public TimelineEntities getEntities(String entityType, NameValuePair primaryFilter, Collection<NameValuePair> secondaryFilter, Long windowStart, Long windowEnd, String fromId, Long fromTs, Long limit, EnumSet<TimelineReader.Field> fields, UserGroupInformation callerUGI) throws YarnException, IOException {
        TimelineEntities entities = null;
        entities = this.store.getEntities(entityType, limit, windowStart, windowEnd, fromId, fromTs, primaryFilter, secondaryFilter, fields);
        if (entities != null) {
            Iterator entitiesItr = entities.getEntities().iterator();
            while (entitiesItr.hasNext()) {
                TimelineEntity entity = (TimelineEntity)entitiesItr.next();
                TimelineDataManager.addDefaultDomainIdIfAbsent(entity);
                try {
                    if (this.timelineACLsManager.checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, entity)) continue;
                    entitiesItr.remove();
                }
                catch (YarnException e) {
                    LOG.error((Object)("Error when verifying access for user " + callerUGI + " on the events of the timeline entity " + new EntityIdentifier(entity.getEntityId(), entity.getEntityType())), (Throwable)e);
                    entitiesItr.remove();
                }
            }
        }
        if (entities == null) {
            return new TimelineEntities();
        }
        return entities;
    }

    public TimelineEntity getEntity(String entityType, String entityId, EnumSet<TimelineReader.Field> fields, UserGroupInformation callerUGI) throws YarnException, IOException {
        TimelineEntity entity = null;
        entity = this.store.getEntity(entityId, entityType, fields);
        if (entity != null) {
            TimelineDataManager.addDefaultDomainIdIfAbsent(entity);
            if (!this.timelineACLsManager.checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, entity)) {
                entity = null;
            }
        }
        return entity;
    }

    public TimelineEvents getEvents(String entityType, SortedSet<String> entityIds, SortedSet<String> eventTypes, Long windowStart, Long windowEnd, Long limit, UserGroupInformation callerUGI) throws YarnException, IOException {
        TimelineEvents events = null;
        events = this.store.getEntityTimelines(entityType, entityIds, limit, windowStart, windowEnd, eventTypes);
        if (events != null) {
            Iterator eventsItr = events.getAllEvents().iterator();
            while (eventsItr.hasNext()) {
                TimelineEvents.EventsOfOneEntity eventsOfOneEntity = (TimelineEvents.EventsOfOneEntity)eventsItr.next();
                try {
                    TimelineEntity entity = this.store.getEntity(eventsOfOneEntity.getEntityId(), eventsOfOneEntity.getEntityType(), EnumSet.of(TimelineReader.Field.PRIMARY_FILTERS));
                    TimelineDataManager.addDefaultDomainIdIfAbsent(entity);
                    if (this.timelineACLsManager.checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, entity)) continue;
                    eventsItr.remove();
                }
                catch (Exception e) {
                    LOG.error((Object)("Error when verifying access for user " + callerUGI + " on the events of the timeline entity " + new EntityIdentifier(eventsOfOneEntity.getEntityId(), eventsOfOneEntity.getEntityType())), (Throwable)e);
                    eventsItr.remove();
                }
            }
        }
        if (events == null) {
            return new TimelineEvents();
        }
        return events;
    }

    public TimelinePutResponse postEntities(TimelineEntities entities, UserGroupInformation callerUGI) throws YarnException, IOException {
        if (entities == null) {
            return new TimelinePutResponse();
        }
        ArrayList<EntityIdentifier> entityIDs = new ArrayList<EntityIdentifier>();
        TimelineEntities entitiesToPut = new TimelineEntities();
        ArrayList<TimelinePutResponse.TimelinePutError> errors = new ArrayList<TimelinePutResponse.TimelinePutError>();
        for (TimelineEntity entity : entities.getEntities()) {
            EntityIdentifier entityID = new EntityIdentifier(entity.getEntityId(), entity.getEntityType());
            if (entity.getDomainId() == null || entity.getDomainId().length() == 0) {
                entity.setDomainId(DEFAULT_DOMAIN_ID);
            }
            TimelineEntity existingEntity = null;
            try {
                existingEntity = this.store.getEntity(entityID.getId(), entityID.getType(), EnumSet.of(TimelineReader.Field.PRIMARY_FILTERS));
                if (existingEntity != null) {
                    TimelineDataManager.addDefaultDomainIdIfAbsent(existingEntity);
                    if (!existingEntity.getDomainId().equals(entity.getDomainId())) {
                        throw new YarnException("The domain of the timeline entity " + entityID + " is not allowed to be changed.");
                    }
                }
                if (!this.timelineACLsManager.checkAccess(callerUGI, ApplicationAccessType.MODIFY_APP, entity)) {
                    throw new YarnException(callerUGI + " is not allowed to put the timeline entity " + entityID + " into the domain " + entity.getDomainId() + ".");
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Skip the timeline entity: " + entityID), (Throwable)e);
                TimelinePutResponse.TimelinePutError error = new TimelinePutResponse.TimelinePutError();
                error.setEntityId(entityID.getId());
                error.setEntityType(entityID.getType());
                error.setErrorCode(4);
                errors.add(error);
                continue;
            }
            entityIDs.add(entityID);
            entitiesToPut.addEntity(entity);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Storing the entity " + entityID + ", JSON-style content: " + TimelineUtils.dumpTimelineRecordtoJSON((Object)entity)));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing entities: " + StringHelper.CSV_JOINER.join(entityIDs)));
        }
        TimelinePutResponse response = this.store.put(entitiesToPut);
        response.addErrors(errors);
        return response;
    }

    public void putDomain(TimelineDomain domain, UserGroupInformation callerUGI) throws YarnException, IOException {
        TimelineDomain existingDomain = this.store.getDomain(domain.getId());
        if (existingDomain != null) {
            if (!this.timelineACLsManager.checkAccess(callerUGI, existingDomain)) {
                throw new YarnException(callerUGI.getShortUserName() + " is not allowed to override an existing domain " + existingDomain.getId());
            }
            domain.setOwner(existingDomain.getOwner());
        }
        this.store.put(domain);
        if (existingDomain != null) {
            this.timelineACLsManager.replaceIfExist(domain);
        }
    }

    public TimelineDomain getDomain(String domainId, UserGroupInformation callerUGI) throws YarnException, IOException {
        TimelineDomain domain = this.store.getDomain(domainId);
        if (domain != null && this.timelineACLsManager.checkAccess(callerUGI, domain)) {
            return domain;
        }
        return null;
    }

    public TimelineDomains getDomains(String owner, UserGroupInformation callerUGI) throws YarnException, IOException {
        TimelineDomains domains = this.store.getDomains(owner);
        boolean hasAccess = true;
        if (domains.getDomains().size() > 0) {
            hasAccess = this.timelineACLsManager.checkAccess(callerUGI, (TimelineDomain)domains.getDomains().get(0));
        }
        if (hasAccess) {
            return domains;
        }
        return new TimelineDomains();
    }

    private static void addDefaultDomainIdIfAbsent(TimelineEntity entity) {
        if (entity.getDomainId() == null) {
            entity.setDomainId(DEFAULT_DOMAIN_ID);
        }
    }
}

