/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.aeprocessor;

import com.cloudera.sqlengine.aeprocessor.AEUtils;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.sqlengine.parser.parsetree.PTIdentifierNode;
import com.cloudera.sqlengine.parser.parsetree.PTNonterminalNode;
import com.cloudera.sqlengine.parser.type.PTNonterminalType;
import com.cloudera.sqlengine.parser.type.PTPositionalType;
import com.cloudera.support.exceptions.ErrorException;
import java.util.EnumSet;

public final class AEQTableName {
    private static final AEQTableName EMPTY = new AEQTableName("", "", "");
    private final String m_catalogName;
    private final String m_schemaName;
    private final String m_tableName;

    public AEQTableName(String string, String string2, String string3) {
        this.m_catalogName = string == null ? "" : string;
        this.m_schemaName = string2 == null ? "" : string2;
        String string4 = this.m_tableName = string3 == null ? "" : string3;
        if (!(!"".equals(this.m_tableName) || "".equals(this.m_catalogName) && "".equals(this.m_schemaName))) {
            throw new IllegalArgumentException("Table name was not specified: cannot specify catalog or schema name.");
        }
    }

    public boolean hasCatalogName() {
        return this.m_catalogName.length() > 0;
    }

    public boolean hasSchemaName() {
        return this.m_schemaName.length() > 0;
    }

    public boolean hasTableName() {
        return this.m_tableName.length() > 0;
    }

    public String getCatalogName() {
        return this.m_catalogName;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(30);
        if (this.hasCatalogName()) {
            stringBuilder.append(AEUtils.sqlQuoted(this.m_catalogName)).append(".");
            stringBuilder.append(AEUtils.sqlQuoted(this.m_schemaName)).append(".");
        } else if (this.hasSchemaName()) {
            stringBuilder.append(AEUtils.sqlQuoted(this.m_schemaName)).append(".");
        }
        stringBuilder.append(AEUtils.sqlQuoted(this.m_tableName));
        return stringBuilder.toString();
    }

    public static AEQTableName fromPTNode(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        if (PTNonterminalType.TABLE_NAME != pTNonterminalNode.getNonterminalType()) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        EnumSet<PTPositionalType> enumSet = EnumSet.of(PTPositionalType.CATALOG_IDENT, PTPositionalType.SCHEMA_IDENT, PTPositionalType.TABLE_IDENT);
        if (!enumSet.equals(pTNonterminalNode.getAllPositionalTypes())) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.CATALOG_IDENT);
        IPTNode iPTNode2 = pTNonterminalNode.getChild(PTPositionalType.SCHEMA_IDENT);
        IPTNode iPTNode3 = pTNonterminalNode.getChild(PTPositionalType.TABLE_IDENT);
        if (!iPTNode.isEmptyNode() && !(iPTNode instanceof PTIdentifierNode) || !iPTNode2.isEmptyNode() && !(iPTNode2 instanceof PTIdentifierNode) || !(iPTNode3 instanceof PTIdentifierNode)) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        String string = ((PTIdentifierNode)iPTNode3).getIdentifier();
        String string2 = AEUtils.getIdentifierString(iPTNode);
        String string3 = AEUtils.getIdentifierString(iPTNode2);
        return new AEQTableName(string2, string3, string);
    }

    public static AEQTableName empty() {
        return EMPTY;
    }

    public static class AEQTableNameBuilder {
        private String m_catalogName = null;
        private String m_schemaName = null;
        private String m_tableName = null;
        private AEQTableName m_source;

        public AEQTableNameBuilder() {
            this(AEQTableName.empty());
        }

        public AEQTableNameBuilder(AEQTableName aEQTableName) {
            if (null == aEQTableName) {
                throw new NullPointerException("Cannot build from a null AEQTableName.");
            }
            this.m_source = aEQTableName;
        }

        public void setCatalogName(String string) {
            this.m_catalogName = null == string ? "" : string;
        }

        public void setSchemaName(String string) {
            this.m_schemaName = null == string ? "" : string;
        }

        public void setTableName(String string) {
            this.m_tableName = null == string ? "" : string;
        }

        public AEQTableName build() {
            if (null == this.m_catalogName && null == this.m_schemaName && null == this.m_tableName) {
                return this.m_source;
            }
            return new AEQTableName(null == this.m_catalogName ? this.m_source.getCatalogName() : this.m_catalogName, null == this.m_schemaName ? this.m_source.getSchemaName() : this.m_schemaName, null == this.m_tableName ? this.m_source.getTableName() : this.m_tableName);
        }

        public void reset() {
            this.m_tableName = null;
            this.m_schemaName = null;
            this.m_catalogName = null;
            this.m_source = AEQTableName.empty();
        }
    }
}

