/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.querytranslation;

import com.cloudera.dsi.dataengine.utilities.ExecutionContext;
import com.cloudera.dsi.dataengine.utilities.ExecutionContexts;
import com.cloudera.dsi.dataengine.utilities.ParameterInputValue;
import com.cloudera.hivecommon.HiveJDBCSettings;
import com.cloudera.hivecommon.core.CoreUtils;
import com.cloudera.hivecommon.querytranslation.IQueryGenerator;
import com.cloudera.sqlengine.aeprocessor.AEUtils;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.sqlengine.parser.parsetree.IPTVisitor;
import com.cloudera.sqlengine.parser.parsetree.PTDefaultParameterNode;
import com.cloudera.sqlengine.parser.parsetree.PTDynamicParameterNode;
import com.cloudera.sqlengine.parser.parsetree.PTEmptyNode;
import com.cloudera.sqlengine.parser.parsetree.PTFlagNode;
import com.cloudera.sqlengine.parser.parsetree.PTIdentifierNode;
import com.cloudera.sqlengine.parser.parsetree.PTListNode;
import com.cloudera.sqlengine.parser.parsetree.PTLiteralNode;
import com.cloudera.sqlengine.parser.parsetree.PTNonterminalNode;
import com.cloudera.sqlengine.parser.type.PTNonterminalType;
import com.cloudera.sqlengine.parser.type.PTPositionalType;
import com.cloudera.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public final class ImpalaInsertQueryGenerator
implements IPTVisitor<Void>,
IQueryGenerator {
    private StringBuilder m_sb = new StringBuilder(1000);
    private static final int CHAR_MAX_LENGTH = 255;
    private ExecutionContexts m_contexts;
    private HiveJDBCSettings m_settings;
    private Queue<String> m_paramValues = new LinkedList<String>();
    private static Object lock = new Object();

    public void clear() {
        this.m_sb = new StringBuilder(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generate(IPTNode iPTNode, HiveJDBCSettings hiveJDBCSettings, ExecutionContexts executionContexts) throws ErrorException {
        Object object = lock;
        synchronized (object) {
            this.clear();
            this.m_contexts = executionContexts;
            this.m_settings = hiveJDBCSettings;
            iPTNode.acceptVisitor(this);
            return this.toString();
        }
    }

    public String toString() {
        return this.m_sb.toString();
    }

    @Override
    public Void visit(PTDefaultParameterNode pTDefaultParameterNode) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidParseTreeException();
    }

    @Override
    public Void visit(PTDynamicParameterNode pTDynamicParameterNode) throws ErrorException {
        if (null != this.m_contexts && 0 != this.m_paramValues.size()) {
            this.append(this.m_paramValues.poll());
        } else {
            this.append('?');
        }
        return null;
    }

    @Override
    public Void visit(PTEmptyNode pTEmptyNode) throws ErrorException {
        return null;
    }

    @Override
    public Void visit(PTFlagNode pTFlagNode) throws ErrorException {
        switch (pTFlagNode.getFlagType()) {
            case STAR: {
                this.append('*');
                break;
            }
            case ASC: {
                this.append("ASC");
                break;
            }
            case DESC: {
                this.append("DESC");
                break;
            }
            case NOT: {
                this.append("NOT");
                break;
            }
            case ALL: {
                this.append("ALL");
                break;
            }
            case ANY: {
                this.append("ANY");
                break;
            }
            case DISTINCT: {
                this.append("DISTINCT");
                break;
            }
            case DEFAULT: {
                this.append("DEFAULT");
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
        }
        return null;
    }

    @Override
    public Void visit(PTIdentifierNode pTIdentifierNode) throws ErrorException {
        String string = pTIdentifierNode.getIdentifier();
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false")) {
            this.append(string);
        } else {
            this.append(this.backTickQuoted(string));
        }
        return null;
    }

    @Override
    public Void visit(PTListNode pTListNode) throws ErrorException {
        switch (pTListNode.getListType()) {
            case ROW_VALUE_LIST: {
                if (null != this.m_contexts) {
                    Iterator<ExecutionContext> iterator = this.m_contexts.contextIterator();
                    while (iterator.hasNext()) {
                        ExecutionContext executionContext = iterator.next();
                        ArrayList<ParameterInputValue> arrayList = new ArrayList<ParameterInputValue>();
                        for (int i = 0; i < executionContext.getInputs().size(); ++i) {
                            arrayList.add(executionContext.getInputs().get(i));
                        }
                        this.m_paramValues.addAll(CoreUtils.getParameterValues(arrayList, this.m_settings.m_platformVersionUtils.needsColumnTypeCastForInsert(this.m_settings.m_serverVersion)));
                        this.append('(');
                        this.visitChildren(pTListNode, ", ");
                        this.append(')');
                        if (!iterator.hasNext()) continue;
                        this.append(", ");
                    }
                    break;
                }
                this.append('(');
                this.visitChildren(pTListNode, ", ");
                this.append(')');
                break;
            }
            case COLUMN_NAME_LIST: {
                this.append('(');
                this.visitChildren(pTListNode, ", ");
                this.append(')');
                break;
            }
            case VALUE_LIST: {
                this.append("(");
                this.visitChildren(pTListNode, ", ");
                this.append(")");
                break;
            }
            case TABLE_VALUE_LIST: {
                this.append("VALUES ");
                this.visitChildren(pTListNode, ", ");
                break;
            }
            case COALESCE_LIST: 
            case PARAMETER_LIST: {
                this.visitChildren(pTListNode, ", ");
                break;
            }
            case SIMPLE_WHEN_CLAUSE_LIST: 
            case SEARCHED_WHEN_CLAUSE_LIST: {
                this.visitChildren(pTListNode, "");
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
        }
        return null;
    }

    @Override
    public Void visit(PTLiteralNode pTLiteralNode) throws ErrorException {
        switch (pTLiteralNode.getLiteralType()) {
            case CHARSTR: {
                String string = pTLiteralNode.getStringValue();
                if (this.m_settings.m_platformVersionUtils.needsColumnTypeCastForInsert(this.m_settings.m_serverVersion)) {
                    int n = string.length();
                    this.append("CAST(");
                    this.append(this.asCharStr(string));
                    if (n <= 255) {
                        this.append(" AS CHAR(");
                    } else {
                        this.append(" AS VARCHAR(");
                    }
                    this.append(n + "))");
                    break;
                }
                this.append(this.asCharStr(string));
                break;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                this.append(this.asCharStr(pTLiteralNode.getStringValue()));
                break;
            }
            case SINT: {
                String string = pTLiteralNode.getStringValue();
                if (!string.startsWith("-")) {
                    this.append('+');
                }
                this.append(string);
                break;
            }
            case NULL: {
                this.append("NULL");
                break;
            }
            default: {
                this.append(pTLiteralNode.getStringValue());
            }
        }
        return null;
    }

    @Override
    public Void visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        switch (pTNonterminalNode.getNonterminalType()) {
            case COLUMN_REFERENCE: {
                this.visitColumnReference(pTNonterminalNode);
                break;
            }
            case DERIVED_COLUMN: {
                pTNonterminalNode.getChild(PTPositionalType.VALUE_EXPRESSION).acceptVisitor(this);
                IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.AS);
                if (iPTNode.isEmptyNode()) break;
                this.append(" AS ");
                iPTNode.acceptVisitor(this);
                break;
            }
            case TABLE_REFERENCE: {
                this.visitTableReference(pTNonterminalNode);
                break;
            }
            case TABLE_NAME: {
                this.visitTableName(pTNonterminalNode);
                break;
            }
            case EQUALS_OP: 
            case NOT_EQUALS_OP: 
            case GREATER_THAN_OP: 
            case GREATER_THAN_OR_EQUALS_OP: 
            case LESS_THAN_OP: 
            case LESS_THAN_OR_EQUALS_OP: 
            case AND: 
            case OR: 
            case BINARY_PLUS_SIGN: 
            case BINARY_MINUS_SIGN: 
            case MULTIPLICATION_SIGN: 
            case DIVISION_SIGN: 
            case CONCAT_SIGN: {
                this.visitBinaryNode(pTNonterminalNode, ImpalaInsertQueryGenerator.getBinaryOperator(pTNonterminalNode.getNonterminalType()));
                break;
            }
            case UNARY_MINUS_SIGN: {
                this.append('-');
                pTNonterminalNode.getChild(PTPositionalType.SINGLE_CHILD).acceptVisitor(this);
                break;
            }
            case INSERT_STATEMENT: {
                this.visitInsert(pTNonterminalNode.getChild(PTPositionalType.TABLE_NAME), pTNonterminalNode.getChild(PTPositionalType.INSERT_LIST));
                break;
            }
            case INSERT_LIST: {
                pTNonterminalNode.getChild(PTPositionalType.COLUMN_LIST).acceptVisitor(this);
                this.append(' ');
                pTNonterminalNode.getChild(PTPositionalType.QUERY_EXPRESSION).acceptVisitor(this);
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
        }
        return null;
    }

    private StringBuilder append(String string) {
        return this.m_sb.append(string);
    }

    private StringBuilder append(char c) {
        return this.m_sb.append(c);
    }

    private String asCharStr(String string) {
        return "'" + string + "'";
    }

    private String backTickQuoted(String string) {
        return "`" + string + "`";
    }

    private void visitChildren(PTListNode pTListNode, String string) throws ErrorException {
        int n = pTListNode.numChildren();
        for (int i = 0; i < n; ++i) {
            if (0 != i) {
                this.append(string);
            }
            pTListNode.getChild(i).acceptVisitor(this);
        }
    }

    private void visitBinaryNode(PTNonterminalNode pTNonterminalNode, String string) throws ErrorException {
        this.append("( ");
        pTNonterminalNode.getChild(PTPositionalType.BINARY_LEFT).acceptVisitor(this);
        this.append(' ').append(string).append(' ');
        pTNonterminalNode.getChild(PTPositionalType.BINARY_RIGHT).acceptVisitor(this);
        this.append(" )");
    }

    private void visitColumnReference(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.CATALOG_IDENT);
        IPTNode iPTNode2 = pTNonterminalNode.getChild(PTPositionalType.SCHEMA_IDENT);
        IPTNode iPTNode3 = pTNonterminalNode.getChild(PTPositionalType.TABLE_IDENT);
        IPTNode iPTNode4 = pTNonterminalNode.getChild(PTPositionalType.COLUMN_NAME);
        if (!iPTNode.isEmptyNode()) {
            iPTNode.acceptVisitor(this);
            this.append('.');
            if (!iPTNode2.isEmptyNode()) {
                iPTNode2.acceptVisitor(this);
            }
            this.append('.');
            if (!iPTNode3.isEmptyNode()) {
                iPTNode3.acceptVisitor(this);
            }
            this.append('.');
        } else if (!iPTNode2.isEmptyNode()) {
            iPTNode2.acceptVisitor(this);
            if (!iPTNode3.isEmptyNode()) {
                iPTNode3.acceptVisitor(this);
            }
            this.append('.');
        } else if (!iPTNode3.isEmptyNode()) {
            iPTNode3.acceptVisitor(this);
            this.append('.');
        }
        iPTNode4.acceptVisitor(this);
    }

    private void visitInsert(IPTNode iPTNode, IPTNode iPTNode2) throws ErrorException {
        this.append("INSERT INTO ");
        iPTNode.acceptVisitor(this);
        iPTNode2.acceptVisitor(this);
    }

    private void visitTableName(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        if (PTNonterminalType.TABLE_NAME != pTNonterminalNode.getNonterminalType()) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        EnumSet<PTPositionalType> enumSet = EnumSet.of(PTPositionalType.CATALOG_IDENT, PTPositionalType.SCHEMA_IDENT, PTPositionalType.TABLE_IDENT);
        if (!enumSet.equals(pTNonterminalNode.getAllPositionalTypes())) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.CATALOG_IDENT);
        IPTNode iPTNode2 = pTNonterminalNode.getChild(PTPositionalType.SCHEMA_IDENT);
        IPTNode iPTNode3 = pTNonterminalNode.getChild(PTPositionalType.TABLE_IDENT);
        if (!iPTNode.isEmptyNode() && !(iPTNode instanceof PTIdentifierNode) || !iPTNode2.isEmptyNode() && !(iPTNode2 instanceof PTIdentifierNode) || !(iPTNode3 instanceof PTIdentifierNode)) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        String string = ((PTIdentifierNode)iPTNode3).getIdentifier();
        String string2 = AEUtils.getIdentifierString(iPTNode);
        String string3 = AEUtils.getIdentifierString(iPTNode2);
        if (null != string2 && 0 != string2.length()) {
            this.append(this.backTickQuoted(string2)).append(".");
            this.append(this.backTickQuoted(string3)).append(".");
        } else if (null != string3 && 0 != string3.length()) {
            this.append(this.backTickQuoted(string3)).append(".");
        }
        this.append(this.backTickQuoted(string));
    }

    private void visitTableReference(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        if (pTNonterminalNode.getAllPositionalTypes().contains((Object)PTPositionalType.TABLE_NAME)) {
            pTNonterminalNode.getChild(PTPositionalType.TABLE_NAME).acceptVisitor(this);
        } else {
            pTNonterminalNode.getChild(PTPositionalType.SUBQUERY).acceptVisitor(this);
        }
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.CORRELATION_IDENT);
        if (!iPTNode.isEmptyNode()) {
            this.append(' ');
            iPTNode.acceptVisitor(this);
            pTNonterminalNode.getChild(PTPositionalType.DERIVED_COLUMN_LIST).acceptVisitor(this);
        }
    }

    private static String getBinaryOperator(PTNonterminalType pTNonterminalType) {
        switch (pTNonterminalType) {
            case EQUALS_OP: {
                return "=";
            }
            case NOT_EQUALS_OP: {
                return "!=";
            }
            case LESS_THAN_OP: {
                return "<";
            }
            case LESS_THAN_OR_EQUALS_OP: {
                return "<=";
            }
            case GREATER_THAN_OP: {
                return ">";
            }
            case GREATER_THAN_OR_EQUALS_OP: {
                return ">=";
            }
            case AND: {
                return "AND";
            }
            case OR: {
                return "OR";
            }
            case BINARY_MINUS_SIGN: {
                return "-";
            }
            case BINARY_PLUS_SIGN: {
                return "+";
            }
            case MULTIPLICATION_SIGN: {
                return "*";
            }
            case DIVISION_SIGN: {
                return "/";
            }
        }
        throw new IllegalArgumentException("" + (Object)((Object)pTNonterminalType));
    }
}

