/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.etree.value;

import com.cloudera.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.sqlengine.executor.IWarningSource;
import com.cloudera.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.sqlengine.executor.etree.IETNode;
import com.cloudera.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.cloudera.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.exceptions.ErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETParameter
extends ETValueExpr
implements IWarningSource {
    private DataWrapper m_inputData;
    private IWarningListener m_warningListener;

    public ETParameter(DataWrapper dataWrapper) {
        this.m_inputData = dataWrapper;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    @Override
    public void open() {
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = eTDataRequest.getData();
        iSqlDataWrapper.setValue(this.m_inputData);
        if (iSqlDataWrapper.isNull()) {
            return false;
        }
        TypeMetadata typeMetadata = eTDataRequest.getColumn().getTypeMetadata();
        if (typeMetadata.isCharacterType()) {
            return DataRetrievalUtil.retrieveCharData(iSqlDataWrapper, eTDataRequest.getOffset(), eTDataRequest.getMaxSize(), eTDataRequest.getColumn().getColumnLength(), this.m_warningListener);
        }
        if (typeMetadata.isBinaryType()) {
            return DataRetrievalUtil.retrieveBinaryData(iSqlDataWrapper, eTDataRequest.getOffset(), eTDataRequest.getMaxSize(), eTDataRequest.getColumn().getColumnLength(), this.m_warningListener);
        }
        return false;
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }
}

