/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.jdbc.jdbc41;

import com.cloudera.dsi.core.interfaces.IStatement;
import com.cloudera.dsi.dataengine.impl.DSIEmptyResultSet;
import com.cloudera.dsi.dataengine.interfaces.IResultSet;
import com.cloudera.dsi.dataengine.utilities.ExecutionResult;
import com.cloudera.exceptions.ExceptionConverter;
import com.cloudera.jdbc.common.SConnection;
import com.cloudera.jdbc.common.SForwardResultSet;
import com.cloudera.jdbc.common4.C4SStatement;
import com.cloudera.jdbc.jdbc41.S41ForwardResultSet;
import com.cloudera.jdbc.jdbc41.S41UpdatableForwardResultSet;
import com.cloudera.support.LogUtilities;
import com.cloudera.utilities.JDBCVersion;
import java.sql.ResultSet;
import java.sql.SQLException;

public class S41Statement
extends C4SStatement {
    public S41Statement(IStatement iStatement, SConnection sConnection, int n) {
        super(iStatement, sConnection, n);
        this.m_jdbcVersion = JDBCVersion.JDBC41;
    }

    @Override
    protected ResultSet createResultSet(ExecutionResult executionResult) throws SQLException {
        SForwardResultSet sForwardResultSet = null;
        sForwardResultSet = this.createsUpdatableResults() ? new S41UpdatableForwardResultSet(this, (IResultSet)executionResult.getResult(), this.getLogger()) : new S41ForwardResultSet(this, (IResultSet)executionResult.getResult(), this.getLogger());
        sForwardResultSet.setFetchSize(this.getFetchSize());
        return sForwardResultSet;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            S41ForwardResultSet s41ForwardResultSet = null;
            s41ForwardResultSet = new S41ForwardResultSet(this, new DSIEmptyResultSet(), this.getLogger());
            return s41ForwardResultSet;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized void closeOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.m_closeOnCompletion = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized boolean isCloseOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_closeOnCompletion;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }
}

