/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.dataengine;

import com.cloudera.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.dsi.core.utilities.Variant;
import com.cloudera.dsi.dataengine.impl.DSIEmptyResultSet;
import com.cloudera.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.cloudera.dsi.dataengine.interfaces.IQueryExecutor;
import com.cloudera.dsi.dataengine.utilities.ExecutionContext;
import com.cloudera.dsi.dataengine.utilities.ExecutionContexts;
import com.cloudera.dsi.dataengine.utilities.ExecutionResults;
import com.cloudera.dsi.dataengine.utilities.Nullable;
import com.cloudera.dsi.dataengine.utilities.ParameterInputValue;
import com.cloudera.dsi.dataengine.utilities.ParameterMetadata;
import com.cloudera.dsi.dataengine.utilities.ParameterType;
import com.cloudera.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.dsi.exceptions.BadDefaultParamException;
import com.cloudera.dsi.exceptions.ExecutingException;
import com.cloudera.dsi.exceptions.OperationCanceledException;
import com.cloudera.dsi.exceptions.ParsingException;
import com.cloudera.hivecommon.HiveJDBCSettings;
import com.cloudera.hivecommon.api.HiveExecutionContext;
import com.cloudera.hivecommon.api.IExecutorUtility;
import com.cloudera.hivecommon.api.IHiveClient;
import com.cloudera.hivecommon.core.CoreUtils;
import com.cloudera.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hivecommon.core.HiveJDBCStatement;
import com.cloudera.hivecommon.dataengine.HiveJDBCLimitZeroPreparedStatementMetadataUtils;
import com.cloudera.hivecommon.dataengine.HiveJDBCQueryAnalyserUtils;
import com.cloudera.hivecommon.dataengine.HiveJDBCResultSet;
import com.cloudera.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hivecommon.querytranslation.IQueryGenerator;
import com.cloudera.sqlengine.SQLEngineGenericContext;
import com.cloudera.sqlengine.dsiext.dataengine.SqlQueryExecutorContext;
import com.cloudera.sqlengine.exceptions.SQLEngineException;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.parser.DefaultLimitChecker;
import com.cloudera.sqlengine.parser.IPTLimitChecker;
import com.cloudera.sqlengine.parser.PTParser;
import com.cloudera.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.support.ILogger;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.LogUtilities;
import com.cloudera.support.Warning;
import com.cloudera.support.WarningCode;
import com.cloudera.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.hive.service.cli.thrift.TExecuteStatementResp;
import org.apache.hive.service.cli.thrift.TOperationHandle;

public class HiveJDBCNativeQueryExecutor
implements IQueryExecutor,
IExecutorUtility {
    private static final Pattern SET_DESCR_VALUE = Pattern.compile("(?i)set[^=]*$");
    private ILogger m_logger;
    private ExecutionResults m_results = new ExecutionResults();
    private IHiveClient m_client;
    private HiveJDBCStatement m_statement;
    private String m_nativeQuery;
    private HiveExecutionContext m_context;
    private HiveExecutionContext m_prepareLimitZeroMetadataQueryContext;
    private HiveJDBCCommonConnection m_connection;
    private HiveJDBCSettings m_settings;
    private boolean m_isRowCountQuery;
    private boolean m_isQueryTypeIdentified;
    private boolean m_isDirectExecuteQuery;
    private boolean m_isPrepareStage;
    private boolean m_isParamPrepareStage;
    private SqlQueryExecutorContext m_sqlqueryContext;
    private ConnSettingRequestMap m_requestMap;
    private int m_parameterCount = -2;
    ArrayList<ParameterMetadata> m_cachedParameterMetadata = new ArrayList();
    private ArrayList<ParameterMetadata> m_paramMetadataList;
    private IPTNode m_parseTreeRoot = null;
    public static final String DESCRIBE_CASE = "DESCRIBE";
    public static final String DESC_CASE = "DESC";
    public static final String EXPLAIN_CASE = "EXPLAIN";
    public static final String SELECT_CASE = "SELECT";
    public static final String SHOW_CASE = "SHOW";
    public static final String VALUES_UCASE = "VALUES";
    public static final String SET_CASE = "SET";
    public static final String SET_V_CASE = "SET -V";
    public static final String USE_CASE = "USE";
    public static final String WITH_CASE = "WITH";
    public static final String COMPUTE_CASE = "COMPUTE";

    public HiveJDBCNativeQueryExecutor(ILogger iLogger, IHiveClient iHiveClient, HiveJDBCStatement hiveJDBCStatement, HiveJDBCCommonConnection hiveJDBCCommonConnection, boolean bl, SqlQueryExecutorContext sqlQueryExecutorContext) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger, iHiveClient);
        this.m_logger = iLogger;
        this.m_client = iHiveClient;
        this.m_statement = hiveJDBCStatement;
        this.m_connection = hiveJDBCCommonConnection;
        this.m_settings = hiveJDBCCommonConnection.getSettings();
        this.m_nativeQuery = null;
        this.m_isQueryTypeIdentified = false;
        this.m_isDirectExecuteQuery = bl;
        this.m_sqlqueryContext = sqlQueryExecutorContext;
        this.m_isParamPrepareStage = true;
    }

    public HiveJDBCNativeQueryExecutor(ILogger iLogger, IHiveClient iHiveClient, HiveJDBCStatement hiveJDBCStatement, String string, HiveJDBCCommonConnection hiveJDBCCommonConnection, boolean bl, ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger, iHiveClient, string);
        this.m_logger = iLogger;
        this.m_client = iHiveClient;
        this.m_statement = hiveJDBCStatement;
        this.m_connection = hiveJDBCCommonConnection;
        this.m_settings = hiveJDBCCommonConnection.getSettings();
        this.m_nativeQuery = this.m_settings.m_stripCatalogName ? this.stripCatalogName(string) : string;
        this.m_isRowCountQuery = this.isRowCountResult(this.m_nativeQuery);
        this.m_isQueryTypeIdentified = true;
        this.m_isDirectExecuteQuery = bl;
        this.m_isPrepareStage = true;
        this.m_requestMap = connSettingRequestMap;
        this.m_parameterCount = CoreUtils.parameterCounter(this.m_nativeQuery);
        if (0 < this.m_parameterCount) {
            this.m_isParamPrepareStage = true;
        }
        if (!this.m_isRowCountQuery) {
            if (0 < this.m_parameterCount) {
                this.m_results = new ExecutionResults();
                this.m_results.addResultSet(new DSIEmptyResultSet());
            } else {
                this.executeQuery(this.m_nativeQuery);
                this.m_isPrepareStage = false;
            }
        } else {
            this.m_results.addRowCountResult(new DSISimpleRowCountResult(-1L));
        }
    }

    public HiveJDBCNativeQueryExecutor(ILogger iLogger, IHiveClient iHiveClient, HiveJDBCStatement hiveJDBCStatement, String string, IPTNode iPTNode, HiveJDBCCommonConnection hiveJDBCCommonConnection, boolean bl, ConnSettingRequestMap connSettingRequestMap, boolean bl2) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger, iHiveClient, string);
        this.m_logger = iLogger;
        this.m_client = iHiveClient;
        this.m_statement = hiveJDBCStatement;
        this.m_connection = hiveJDBCCommonConnection;
        this.m_settings = hiveJDBCCommonConnection.getSettings();
        this.m_nativeQuery = string;
        this.m_parseTreeRoot = iPTNode;
        this.m_isRowCountQuery = this.isRowCountResult(this.m_nativeQuery);
        this.m_isQueryTypeIdentified = true;
        this.m_isDirectExecuteQuery = bl;
        this.m_isPrepareStage = true;
        this.m_requestMap = connSettingRequestMap;
        this.m_isParamPrepareStage = bl2;
        this.m_parameterCount = CoreUtils.parameterCounter(this.m_nativeQuery);
        this.m_results.addRowCountResult(new DSISimpleRowCountResult(-1L));
    }

    @Override
    public void cancelExecute() {
    }

    @Override
    public void clearCancel() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_statement.clearCancel();
    }

    @Override
    public void clearPushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws BadDefaultParamException, ParsingException, ExecutingException, ErrorException, OperationCanceledException {
        block29: {
            LogUtilities.logFunctionEntrance(this.m_logger, executionContexts, iWarningListener);
            if (this.m_settings.m_platformVersionUtils.needsInsertOptimization(this.m_settings.m_serverVersion) && !this.m_settings.m_useNativeQuery && this.m_settings.m_optimizedInsert && this.m_isRowCountQuery && this.m_nativeQuery.toUpperCase().startsWith("INSERT") && null != this.m_parseTreeRoot) {
                IQueryGenerator iQueryGenerator = ((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getQueryGenerator();
                String string = iQueryGenerator.generate(this.m_parseTreeRoot, this.m_settings, executionContexts);
                if (0 < this.m_parameterCount) {
                    this.executeHelper(string);
                } else {
                    try {
                        this.executeHelper(string);
                    }
                    catch (ErrorException errorException) {
                        this.executeHelper(this.m_nativeQuery);
                    }
                }
            } else if (this.m_isRowCountQuery) {
                if (this.m_settings.m_platformVersionUtils.needsInsertOptimization(this.m_settings.m_serverVersion) && this.m_settings.m_useNativeQuery && this.m_nativeQuery.toUpperCase().startsWith("INSERT")) {
                    try {
                        Object object;
                        if (null == this.m_parseTreeRoot) {
                            object = new DefaultLimitChecker();
                            ((DefaultLimitChecker)object).initLimitCheckValues(this.m_statement.getParentConnection());
                            this.m_parseTreeRoot = PTParser.parse(this.m_nativeQuery, (IPTLimitChecker)object);
                        }
                        if (null == this.m_parseTreeRoot) {
                            throw SQLEngineExceptionFactory.invalidParseTreeException();
                        }
                        object = ((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getQueryGenerator();
                        String string = object.generate(this.m_parseTreeRoot, this.m_settings, executionContexts);
                        this.executeHelper(string);
                    }
                    catch (ErrorException errorException) {
                        if (errorException instanceof SQLEngineException) {
                            errorException.loadMessage(SQLEngineGenericContext.getDefaultMsgSource(), this.m_client.getWarningListener().getLocale());
                            LogUtilities.logWarning(errorException, this.m_logger);
                        }
                        if (0 < this.m_parameterCount) {
                            this.executeHelperParameter(executionContexts);
                            break block29;
                        }
                        this.executeHelper(this.m_nativeQuery);
                    }
                } else if (0 < this.m_parameterCount) {
                    this.executeHelperParameter(executionContexts);
                } else {
                    this.executeHelper(this.m_nativeQuery);
                }
            } else if (0 < this.m_parameterCount) {
                this.m_context = this.m_client.executeStatement(HiveJDBCNativeQueryExecutor.getQueryWithParametersPopulated(this.m_nativeQuery, executionContexts), this);
                if (this.m_context.m_isManualCanceled.get()) {
                    this.m_client.closeOperation(this.m_context);
                    this.m_context.m_isManualCanceled.set(false);
                    throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL.name());
                }
                HiveJDBCResultSet hiveJDBCResultSet = new HiveJDBCResultSet(this.m_context, this.m_client, this.m_statement, this.m_connection, this.m_logger, this.m_isRowCountQuery);
                hiveJDBCResultSet.openCursor();
                this.m_results.getResults().clear();
                this.m_results.addResultSet(hiveJDBCResultSet);
            } else if (this.m_settings.m_preparedStmtGetMetadataLimitZero && !this.m_isDirectExecuteQuery) {
                if (null != this.m_prepareLimitZeroMetadataQueryContext) {
                    this.m_client.closeOperation(this.m_prepareLimitZeroMetadataQueryContext);
                    this.m_context = this.m_client.executeStatement(this.m_nativeQuery, this);
                } else if (!this.m_context.m_isLimitZeroQueryParseFailed) {
                    this.m_context = this.m_client.executeStatement(this.m_nativeQuery, this);
                }
                if (this.m_context.m_isManualCanceled.get()) {
                    this.m_client.closeOperation(this.m_context);
                    this.m_context.m_isManualCanceled.set(false);
                    throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL.name());
                }
                HiveJDBCResultSet hiveJDBCResultSet = new HiveJDBCResultSet(this.m_context, this.m_client, this.m_statement, this.m_connection, this.m_logger, this.m_isRowCountQuery);
                hiveJDBCResultSet.openCursor();
                this.m_results.getResults().clear();
                this.m_results.addResultSet(hiveJDBCResultSet);
            } else {
                HiveJDBCResultSet hiveJDBCResultSet = (HiveJDBCResultSet)this.m_results.getResults().get(0).getResult();
                if (null != this.m_prepareLimitZeroMetadataQueryContext && this.m_prepareLimitZeroMetadataQueryContext.m_isManualCanceled.get()) {
                    this.m_client.closeOperation(this.m_context);
                    this.m_context.m_isManualCanceled.set(false);
                    throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL.name());
                }
                if (!hiveJDBCResultSet.hasOpenCursor()) {
                    this.executeQuery(this.m_nativeQuery);
                }
            }
        }
    }

    @Override
    public void finalizePushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_cachedParameterMetadata && this.m_parameterCount == -2) {
            return this.m_cachedParameterMetadata;
        }
        if (this.m_parameterCount > 0) {
            if (this.m_isParamPrepareStage) {
                this.m_paramMetadataList = new ArrayList();
                for (int i = 0; i < this.m_parameterCount; ++i) {
                    ParameterMetadata parameterMetadata = new ParameterMetadata(i, ParameterType.INPUT, 12);
                    this.m_paramMetadataList.add(parameterMetadata);
                }
                this.m_isParamPrepareStage = false;
            }
            return this.m_paramMetadataList;
        }
        return new ArrayList<ParameterMetadata>();
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_parameterCount >= 0) {
            return this.m_parameterCount;
        }
        return 0;
    }

    @Override
    public ExecutionResults getResults() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == this.m_results) {
            this.m_results = new ExecutionResults();
            this.executeQuery(this.m_nativeQuery);
        }
        return this.m_results;
    }

    @Override
    public void pushMappedParamTypes(Map<Integer, TypeMetadata> map) throws ErrorException {
        if (this.m_parameterCount > 0) {
            this.m_paramMetadataList.clear();
            if (null == map) {
                for (int i = 0; i < this.m_parameterCount; ++i) {
                    ParameterMetadata parameterMetadata = new ParameterMetadata(i + 1, ParameterType.INPUT, 12);
                    this.m_paramMetadataList.add(parameterMetadata);
                }
                return;
            }
            for (int i = 0; i < this.m_parameterCount; ++i) {
                int n;
                TypeMetadata typeMetadata = map.get(i);
                ParameterMetadata parameterMetadata = null;
                if (null == typeMetadata) {
                    n = 12;
                    parameterMetadata = new ParameterMetadata(i + 1, ParameterType.INPUT, n);
                } else {
                    n = map.get(i).getType();
                    parameterMetadata = new ParameterMetadata(i + 1, ParameterType.INPUT, typeMetadata, 0L, null, false, Nullable.NULLABLE);
                }
                this.m_paramMetadataList.add(parameterMetadata);
            }
        }
    }

    @Override
    public void pushParamData(int n, ParameterInputValue parameterInputValue) throws BadDefaultParamException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, parameterInputValue);
    }

    public void executeQuery(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        String string2 = string;
        if (this.m_settings.m_preparedStmtGetMetadataLimitZero && !this.m_isDirectExecuteQuery && this.m_isPrepareStage) {
            string2 = HiveJDBCLimitZeroPreparedStatementMetadataUtils.nativeLimitZeroQueryBuilder(string2, this.m_client);
        }
        try {
            this.m_isRowCountQuery = this.isRowCountResult(string2);
            if (this.m_isRowCountQuery) {
                this.executeHelper(string2);
            } else {
                if (this.m_settings.m_hiveAsyncQueryTest) {
                    this.m_statement.setAsyncExecution(true);
                }
                this.m_context = this.m_client.executeStatement(string2, this);
                if (this.m_settings.m_preparedStmtGetMetadataLimitZero) {
                    this.m_prepareLimitZeroMetadataQueryContext = this.m_context;
                }
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            throw operationCanceledException;
        }
        catch (ErrorException errorException) {
            CoreUtils.postWarning(errorException, this.m_client.getWarningListener(), WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.DATABASE_TABLE_GENERAL_ERR.name());
            if (this.m_settings.m_preparedStmtGetMetadataLimitZero && !this.m_isDirectExecuteQuery && this.m_isPrepareStage) {
                this.m_context = this.m_client.executeStatement(string, this);
                this.m_context.m_isLimitZeroQueryParseFailed = true;
            }
            throw errorException;
        }
        if (this.m_context.m_isManualCanceled.get()) {
            this.m_client.closeOperation(this.m_context);
            this.m_context.m_isManualCanceled.set(false);
            throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL.name());
        }
        if (!this.m_isQueryTypeIdentified) {
            this.m_isRowCountQuery = this.isRowCountResult(string2);
            this.m_isQueryTypeIdentified = true;
        }
        if (!this.m_isRowCountQuery) {
            this.m_results.getResults().clear();
            HiveJDBCResultSet hiveJDBCResultSet = null;
            hiveJDBCResultSet = this.m_settings.m_preparedStmtGetMetadataLimitZero && !this.m_context.m_isLimitZeroQueryParseFailed ? new HiveJDBCResultSet(this.m_prepareLimitZeroMetadataQueryContext, this.m_client, this.m_statement, this.m_connection, this.m_logger, this.m_isRowCountQuery) : new HiveJDBCResultSet(this.m_context, this.m_client, this.m_statement, this.m_connection, this.m_logger, this.m_isRowCountQuery);
            hiveJDBCResultSet.openCursor();
            this.m_results.addResultSet(hiveJDBCResultSet);
        } else {
            this.m_results.getResults().clear();
            this.m_results.addRowCountResult(new DSISimpleRowCountResult(-1L));
        }
    }

    private boolean isRowCountResult(String string) {
        char c;
        this.m_isRowCountQuery = true;
        String string2 = string.trim().toUpperCase();
        int n = 0;
        if (string2.startsWith(WITH_CASE)) {
            string2 = HiveJDBCQueryAnalyserUtils.removeWithExpression(string2);
        }
        for (int i = 0; i < string2.length() && ('(' == (c = string2.charAt(i)) || Character.isWhitespace(c)); ++i) {
            ++n;
        }
        Matcher matcher = SET_DESCR_VALUE.matcher(string);
        if (string2.startsWith(SELECT_CASE, n) || string2.startsWith(DESCRIBE_CASE) || string2.startsWith(EXPLAIN_CASE) || string2.startsWith(SHOW_CASE) || string2.startsWith(VALUES_UCASE) || string2.equals(SET_CASE) || string2.equals(SET_V_CASE) || string2.startsWith(DESC_CASE) || string2.startsWith(COMPUTE_CASE) || matcher.matches()) {
            this.m_isRowCountQuery = false;
        }
        return this.m_isRowCountQuery;
    }

    public void setParameterMetadataForPrepareStatement(ArrayList<ParameterMetadata> arrayList) {
        this.m_cachedParameterMetadata = arrayList;
    }

    @Override
    public HiveExecutionContext getExeContext() {
        if (null != this.m_context) {
            if (null != this.m_context.m_executeResponse) {
                return this.m_context;
            }
            return null;
        }
        return null;
    }

    @Override
    public HiveJDBCStatement getStatement() {
        return this.m_statement;
    }

    @Override
    public void setExeContext(HiveExecutionContext hiveExecutionContext) {
        this.m_context = hiveExecutionContext;
    }

    @Override
    public int getQueryTimeout() throws Exception {
        int n = 0;
        Variant variant = this.m_statement.getProperty(3);
        n = variant.getInt() * 1000;
        return n;
    }

    public String getYarnATSGuid() {
        if (null != this.m_context) {
            TExecuteStatementResp tExecuteStatementResp = this.m_context.m_executeResponse;
            TOperationHandle tOperationHandle = tExecuteStatementResp.getOperationHandle();
            String string = new String(Base64.encodeBase64((byte[])tOperationHandle.getOperationId().getGuid()));
            string = string.replace("=", "").replace("+", "-").replace("/", "_");
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeHelper(String string) throws ErrorException {
        if (!HiveJDBCNativeQueryExecutor.isUseStatement(string)) {
            this.m_context = this.m_client.executeStatement(string, this);
        } else {
            String string2 = HiveJDBCQueryAnalyserUtils.analyzeUseStatement(string);
            IHiveClient iHiveClient = this.m_client;
            synchronized (iHiveClient) {
                this.m_context = this.m_client.executeStatement(string, this);
                if (null != string2) {
                    this.m_client.setCurrentSchema(string2);
                }
            }
        }
        this.m_client.closeOperation(this.m_context);
    }

    private void executeHelperParameter(ExecutionContexts executionContexts) throws ErrorException {
        if (this.m_nativeQuery.startsWith("UPDATE")) {
            List<String> list = this.getUpdateQueriesWithParametersPopulated(this.m_nativeQuery, executionContexts);
            for (String string : list) {
                this.executeHelper(string);
            }
        } else if (this.m_nativeQuery.startsWith("INSERT")) {
            this.executeHelper(this.getInsertQueryWithParametersPopulated(this.m_nativeQuery, executionContexts));
        } else {
            this.executeHelper(HiveJDBCNativeQueryExecutor.getQueryWithParametersPopulated(this.m_nativeQuery, executionContexts));
        }
    }

    private String getInsertQueryWithParametersPopulated(String string, ExecutionContexts executionContexts) throws ErrorException {
        Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
        return CoreUtils.buildInsertQueryWithParameters(string, iterator);
    }

    private List<String> getUpdateQueriesWithParametersPopulated(String string, ExecutionContexts executionContexts) throws ErrorException {
        Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
        return CoreUtils.buildUpdateQueryWithParameters(string, iterator);
    }

    private static String getQueryWithParametersPopulated(String string, ExecutionContexts executionContexts) throws ErrorException {
        Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
        String string2 = CoreUtils.buildQueryWithParameters(string, iterator);
        if (iterator.hasNext()) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_BATCH_ERR.name());
            throw errorException;
        }
        return string2;
    }

    private static boolean isUseStatement(String string) {
        return string.trim().substring(0, USE_CASE.length()).equalsIgnoreCase(USE_CASE);
    }

    private String stripCatalogName(String string) {
        if (string.toUpperCase().startsWith(SET_CASE)) {
            return string;
        }
        String string2 = new String(string);
        try {
            string2 = Pattern.compile("[\\s][`\"\\[]?" + this.m_settings.m_platformCatalog + "[`\"\\]]?[\\.]", 2).matcher(string2).replaceAll(" ");
            string2 = Pattern.compile("\\([`\"\\[]?" + this.m_settings.m_platformCatalog + "[`\"\\]]?[\\.]", 2).matcher(string2).replaceAll("(");
            return string2;
        }
        catch (Exception exception) {
            this.m_connection.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, new String("Can't strip catalog name in native query.")));
            return string;
        }
    }
}

