/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.api;

import com.cloudera.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.dsi.exceptions.OperationCanceledException;
import com.cloudera.hivecommon.AuthMech;
import com.cloudera.hivecommon.DatabaseMeatadataInfo;
import com.cloudera.hivecommon.HiveJDBCSettings;
import com.cloudera.hivecommon.TransportMode;
import com.cloudera.hivecommon.api.DataTypeUtilities;
import com.cloudera.hivecommon.api.HS2Buffer;
import com.cloudera.hivecommon.api.HS2Client;
import com.cloudera.hivecommon.api.HiveExecutionContext;
import com.cloudera.hivecommon.api.RowsetBuffer;
import com.cloudera.hivecommon.core.CoreUtils;
import com.cloudera.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hivecommon.dataengine.metadata.HiveCommonColumnMetadata;
import com.cloudera.hivecommon.dataengine.metadata.MetadataUtils;
import com.cloudera.hivecommon.exceptions.HiveJDBCExceptionUtils;
import com.cloudera.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.support.ILogger;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.Warning;
import com.cloudera.support.WarningCode;
import com.cloudera.support.exceptions.DiagState;
import com.cloudera.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hive.service.cli.thrift.TColumn;
import org.apache.hive.service.cli.thrift.TColumnDesc;
import org.apache.hive.service.cli.thrift.TColumnValue;
import org.apache.hive.service.cli.thrift.TFetchResultsReq;
import org.apache.hive.service.cli.thrift.TGetColumnsReq;
import org.apache.hive.service.cli.thrift.TGetColumnsResp;
import org.apache.hive.service.cli.thrift.TGetInfoReq;
import org.apache.hive.service.cli.thrift.TGetInfoResp;
import org.apache.hive.service.cli.thrift.TGetInfoType;
import org.apache.hive.service.cli.thrift.TGetResultSetMetadataReq;
import org.apache.hive.service.cli.thrift.TGetResultSetMetadataResp;
import org.apache.hive.service.cli.thrift.TGetSchemasReq;
import org.apache.hive.service.cli.thrift.TGetSchemasResp;
import org.apache.hive.service.cli.thrift.TOpenSessionReq;
import org.apache.hive.service.cli.thrift.TOperationHandle;
import org.apache.hive.service.cli.thrift.TProtocolVersion;
import org.apache.hive.service.cli.thrift.TRow;
import org.apache.hive.service.cli.thrift.TRowSet;
import org.apache.hive.service.cli.thrift.TStatusCode;
import org.apache.hive.service.cli.thrift.TTypeEntry;
import org.apache.hive.service.cli.thrift.TTypeId;
import org.apache.hive.service.cli.thrift.TTypeQualifierValue;
import org.apache.hive.service.cli.thrift.TTypeQualifiers;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransportException;

public class ExtendedHS2Client
extends HS2Client {
    private static final String SHARK_REGEX = ".*[Ss][Hh][Aa][Rr][Kk][Ss][Ee][Rr][Vv][Ee][Rr].*";
    private static final Pattern SHARK_HIVE_VERSION = Pattern.compile("(.*)-shark-(.*)");
    private static final String SET_DASH_V_QUERY_STRING = "set -v";
    private static final int SET_DASH_V_RESULT_COLUM_IDX = 0;
    private static final String SPARK_SERVER_NAME = "Spark";
    private static final Map<String, String> HIVE_SPARK_VERSION_MAP = new HashMap<String, String>();
    private static final int COLS_MD_RS_SCHEMA_NAME_IDX = 1;
    private static final int COLS_MD_RS_TABLE_NAME_IDX = 2;
    private static final int COLS_MD_RS_COLUMN_NAME_IDX = 3;
    private static final int COLS_MD_RS_TYPE_NAME_IDX = 5;
    private static final int COLS_MD_RS_REMARKS_IDX = 11;

    public ExtendedHS2Client(HiveJDBCSettings hiveJDBCSettings, TProtocol tProtocol, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        super(hiveJDBCSettings, tProtocol, iLogger, iWarningListener);
        if (this.m_settings.m_platformVersionUtils.supportsUnionDataTypes(this.m_settings.m_serverVersion)) {
            DataTypeUtilities.addHiveType(TTypeId.UNION_TYPE, (short)12);
        }
    }

    @Override
    public ArrayList<HiveCommonColumnMetadata> getColumns(String string, String string2) throws ErrorException {
        if (!this.m_settings.m_platformVersionUtils.supportsGetColumnsAPI(this.m_settings.m_serverVersion)) {
            return super.getColumns(string, string2);
        }
        HashMap<MetadataSourceColumnTag, String> hashMap = new HashMap<MetadataSourceColumnTag, String>();
        hashMap.put(MetadataSourceColumnTag.SCHEMA_NAME, string);
        hashMap.put(MetadataSourceColumnTag.TABLE_NAME, string2);
        try {
            return this.getColumns(hashMap, null);
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage());
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
            return new ArrayList<HiveCommonColumnMetadata>();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArrayList<HiveCommonColumnMetadata> getColumns(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList) throws Exception {
        if (!this.m_settings.m_platformVersionUtils.supportsGetColumnsAPI(this.m_settings.m_serverVersion)) {
            return null;
        }
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        if (null != string) {
            string = MetadataUtils.EscapeWildCard(string, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != string2) {
            string2 = MetadataUtils.EscapeWildCard(string2, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != string3) {
            string3 = MetadataUtils.EscapeWildCard(string3, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != arrayList) {
            if (null == string) {
                string = arrayList.get(MetadataUtils.SCHEMA_PATTERN_IDX);
            }
            if (null == string2) {
                string2 = arrayList.get(MetadataUtils.TABLE_PATTERN_IDX);
            }
            if (null == string3) {
                string3 = arrayList.get(MetadataUtils.COLUMN_PATTERN_IDX);
            }
        }
        ExtendedHS2Client extendedHS2Client = this;
        synchronized (extendedHS2Client) {
            Object object;
            TOperationHandle tOperationHandle = null;
            try {
                ArrayList<HiveCommonColumnMetadata> arrayList2 = new ArrayList<HiveCommonColumnMetadata>();
                TGetColumnsReq tGetColumnsReq = new TGetColumnsReq();
                tGetColumnsReq.setCatalogName(this.m_DBType);
                tGetColumnsReq.setCatalogNameIsSet(true);
                if (null != string) {
                    tGetColumnsReq.setSchemaName(string);
                    tGetColumnsReq.setSchemaNameIsSet(true);
                }
                if (null != string2) {
                    tGetColumnsReq.setTableName(string2);
                    tGetColumnsReq.setTableNameIsSet(true);
                }
                if (null != string3) {
                    tGetColumnsReq.setColumnName(string3);
                    tGetColumnsReq.setColumnNameIsSet(true);
                }
                tGetColumnsReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                tGetColumnsReq.setSessionHandleIsSet(true);
                TGetColumnsResp tGetColumnsResp = this.m_client.GetColumns(tGetColumnsReq);
                tOperationHandle = tGetColumnsResp.getOperationHandle();
                String string4 = "GetColumns";
                this.checkIfRespNull((TBase)tGetColumnsResp, string4);
                this.checkResponseStatus(tGetColumnsResp.getStatus(), string4);
                if (null == tOperationHandle) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GETCOLUMNS_API_CALL_ERR.name(), new String[]{"Unknown", "Unknown"});
                    throw errorException;
                }
                TFetchResultsReq tFetchResultsReq = new TFetchResultsReq();
                tFetchResultsReq.setOperationHandle(tOperationHandle);
                tFetchResultsReq.setMaxRows((long)this.m_settings.m_rowsFetchedPerBlock);
                ArrayList arrayList3 = new ArrayList();
                ArrayList arrayList4 = new ArrayList();
                ArrayList arrayList5 = new ArrayList();
                String string5 = "";
                String string6 = "";
                int n = 0;
                boolean bl = false;
                int n2 = 0;
                ArrayList<String> arrayList6 = null;
                String string7 = "";
                do {
                    object = this.m_client.FetchResults(tFetchResultsReq);
                    String string8 = "FetchResults";
                    this.checkIfRespNull((TBase)object, string8);
                    this.checkResponseStatus(object.getStatus(), string8);
                    TRowSet tRowSet = object.getResults();
                    if (this.isAtLeastV6ProtocolSession()) {
                        n2 = ((TColumn)tRowSet.getColumns().get(3)).getStringVal().getValuesSize();
                        bl = 0 < n2;
                        arrayList3 = (ArrayList)((TColumn)tRowSet.getColumns().get(3)).getStringVal().getValues();
                        arrayList4 = (ArrayList)((TColumn)tRowSet.getColumns().get(5)).getStringVal().getValues();
                        arrayList5 = (ArrayList)((TColumn)tRowSet.getColumns().get(11)).getStringVal().getValues();
                    } else {
                        n2 = tRowSet.getRowsSize();
                        bl = 0 < n2;
                        arrayList3.clear();
                        arrayList4.clear();
                        arrayList5.clear();
                        for (TRow tRow : tRowSet.getRows()) {
                            arrayList3.add(((TColumnValue)tRow.getColVals().get(3)).getStringVal().getValue());
                            arrayList4.add(((TColumnValue)tRow.getColVals().get(5)).getStringVal().getValue());
                            arrayList5.add(((TColumnValue)tRow.getColVals().get(11)).getStringVal().getValue());
                        }
                    }
                    for (int i = 0; i < n2; ++i, ++n) {
                        if (this.isAtLeastV6ProtocolSession()) {
                            string = (String)((TColumn)tRowSet.getColumns().get(1)).getStringVal().getValues().get(i);
                            string2 = (String)((TColumn)tRowSet.getColumns().get(2)).getStringVal().getValues().get(i);
                        } else {
                            string = ((TColumnValue)((TRow)tRowSet.getRows().get(i)).getColVals().get(1)).getStringVal().getValue();
                            string2 = ((TColumnValue)((TRow)tRowSet.getRows().get(i)).getColVals().get(2)).getStringVal().getValue();
                        }
                        if (!string5.equals(string) || !string6.equals(string2)) {
                            string5 = string;
                            string6 = string2;
                            n = 0;
                            arrayList6 = null;
                        }
                        if (((String)arrayList4.get(i)).contains("DECIMAL") || ((String)arrayList4.get(i)).contains("VARCHAR") || ((String)arrayList4.get(i)).contains("CHAR")) {
                            if (null == arrayList6) {
                                arrayList6 = this.getQualifiedTypeNames(string, string2);
                            }
                            string7 = arrayList6.size() > 0 ? arrayList6.get(n) : (String)arrayList4.get(i);
                        } else {
                            string7 = (String)arrayList4.get(i);
                        }
                        if (string7.toUpperCase().contains("ARRAY<") || string7.toUpperCase().contains("STRUCT<") || string7.toUpperCase().contains("MAP<") || string7.toUpperCase().contains("UNIONTYPE<")) {
                            string7 = string7.toUpperCase();
                        }
                        try {
                            arrayList2.add(DataTypeUtilities.createColumn(((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getCatalogName(), string, string2, (String)arrayList3.get(i), (String)arrayList5.get(i), DataTypeUtilities.mapHiveTypeNameToSqltype(string7, 2, this.m_settings), string7, 2, this.m_settings));
                            continue;
                        }
                        catch (Exception exception) {
                            this.m_warningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CREATE_COLUMN_METADATA_ERR.name(), new String[]{string, string2, (String)arrayList3.get(i), string7}));
                        }
                    }
                } while (bl);
                object = arrayList2;
            }
            catch (TTransportException tTransportException) {
                try {
                    ErrorException errorException = new ErrorException(DiagState.DIAG_COMM_LINK_FAILURE, 101, HiveJDBCMessageKey.COMM_LINK_FAILURE.name(), new String[]{null != tTransportException.getMessage() ? tTransportException.getMessage() : "Unknown"});
                    errorException.initCause(tTransportException);
                    throw errorException;
                    catch (Exception exception) {
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    this.safeCloseOperation(tOperationHandle);
                    throw throwable;
                }
            }
            this.safeCloseOperation(tOperationHandle);
            return object;
        }
    }

    @Override
    public ArrayList<ColumnMetadata> getResultSetMetadata(HiveExecutionContext hiveExecutionContext) throws ErrorException {
        try {
            TGetResultSetMetadataReq tGetResultSetMetadataReq = new TGetResultSetMetadataReq();
            tGetResultSetMetadataReq.setOperationHandle(hiveExecutionContext.m_executeResponse.getOperationHandle());
            TGetResultSetMetadataResp tGetResultSetMetadataResp = null;
            ArrayList<ColumnMetadata> arrayList = null;
            if (tGetResultSetMetadataReq.getOperationHandle().isHasResultSet()) {
                tGetResultSetMetadataResp = this.m_client.GetResultSetMetadata(tGetResultSetMetadataReq);
                if (TStatusCode.ERROR_STATUS == tGetResultSetMetadataResp.getStatus().getStatusCode()) {
                    try {
                        String string;
                        if (null != tGetResultSetMetadataResp.getStatus().getErrorMessage() && ((string = tGetResultSetMetadataResp.getStatus().getErrorMessage().toUpperCase()).contains("CANCELED") || string.contains("CANCELLED"))) {
                            throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL.name());
                        }
                        throw this.buildExceptionFromTStatus(HiveJDBCMessageKey.HIVE_METADATA_RESULTSET_ERR.name(), tGetResultSetMetadataResp.getStatus());
                    }
                    catch (Throwable throwable) {
                        this.closeOperation(hiveExecutionContext);
                        throw throwable;
                    }
                }
                arrayList = new ArrayList(tGetResultSetMetadataResp.getSchema().getColumns().size());
                for (TColumnDesc tColumnDesc : tGetResultSetMetadataResp.getSchema().getColumns()) {
                    TTypeEntry tTypeEntry = (TTypeEntry)tColumnDesc.getTypeDesc().getTypes().get(0);
                    String string = this.fullColumnTypeNameBuilder(tTypeEntry);
                    arrayList.add(DataTypeUtilities.createColumn(((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getCatalogName(), null, null, tColumnDesc.getColumnName(), null, DataTypeUtilities.mapHiveTypeToSqlType(tTypeEntry.getPrimitiveEntry().getType()), string, 2, this.m_settings));
                }
            } else {
                arrayList = new ArrayList<ColumnMetadata>(0);
            }
            return arrayList;
        }
        catch (OperationCanceledException operationCanceledException) {
            throw operationCanceledException;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_RESULTSET_ERR.name(), "Metadata Result Set Error");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public ArrayList<String> getSchemas() throws ErrorException {
        if (!this.m_settings.m_platformVersionUtils.supportsGetSchemasAPI(this.m_settings.m_serverVersion)) {
            return super.getSchemas();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        TOperationHandle tOperationHandle = null;
        ExtendedHS2Client extendedHS2Client = this;
        synchronized (extendedHS2Client) {
            Object object;
            try {
                TGetSchemasReq tGetSchemasReq = new TGetSchemasReq();
                tGetSchemasReq.setCatalogName(this.m_DBType);
                tGetSchemasReq.setCatalogNameIsSet(true);
                tGetSchemasReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                tGetSchemasReq.setSessionHandleIsSet(true);
                TGetSchemasResp tGetSchemasResp = this.m_client.GetSchemas(tGetSchemasReq);
                tOperationHandle = tGetSchemasResp.getOperationHandle();
                String string = "GetSchemas";
                this.checkIfRespNull((TBase)tGetSchemasResp, string);
                this.checkResponseStatus(tGetSchemasResp.getStatus(), string);
                if (null == tOperationHandle) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), new String[]{"getSchemas", "Unknown", "Unknown"});
                    throw errorException;
                }
                TFetchResultsReq tFetchResultsReq = new TFetchResultsReq();
                tFetchResultsReq.setOperationHandle(tOperationHandle);
                tFetchResultsReq.setMaxRows((long)this.m_settings.m_rowsFetchedPerBlock);
                TRowSet tRowSet = null;
                boolean bl = false;
                do {
                    object = this.m_client.FetchResults(tFetchResultsReq);
                    String string2 = "FetchResults";
                    this.checkIfRespNull((TBase)object, string2);
                    this.checkResponseStatus(object.getStatus(), string2);
                    tRowSet = object.getResults();
                    if (this.isAtLeastV6ProtocolSession()) {
                        boolean bl2 = bl = 0 < ((TColumn)tRowSet.getColumns().get(0)).getStringVal().getValuesSize();
                        if (!bl) continue;
                        arrayList.addAll((ArrayList)((TColumn)tRowSet.getColumns().get(0)).getStringVal().getValues());
                        continue;
                    }
                    bl = 0 < tRowSet.getRowsSize();
                    for (TRow tRow : tRowSet.getRows()) {
                        arrayList.add(((TColumnValue)tRow.getColVals().get(0)).getStringVal().getValue());
                    }
                } while (bl);
                Collections.sort(arrayList);
                object = arrayList;
            }
            catch (Exception exception) {
                try {
                    if (exception instanceof ErrorException) {
                        ((ErrorException)exception).loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                    }
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_SCHEMA_ERR.name(), "Schema Metadata Error");
                    errorException.initCause(exception);
                    throw errorException;
                }
                catch (Throwable throwable) {
                    this.safeCloseOperation(tOperationHandle);
                    throw throwable;
                }
            }
            this.safeCloseOperation(tOperationHandle);
            return object;
        }
    }

    @Override
    protected void openSession() throws ErrorException {
        try {
            Object object;
            String string;
            TGetInfoResp tGetInfoResp;
            TGetInfoReq tGetInfoReq;
            TOpenSessionReq tOpenSessionReq = new TOpenSessionReq();
            tOpenSessionReq.setClient_protocol(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1);
            tOpenSessionReq.setClient_protocolIsSet(true);
            if (null != this.m_settings.m_delegationUID) {
                tGetInfoReq = new HashMap();
                tGetInfoReq.put(this.m_settings.m_platformDelegationUIDPropertyKey, this.m_settings.m_delegationUID);
                tOpenSessionReq.setConfiguration(tGetInfoReq);
            }
            if (this.m_settings.m_authMech == AuthMech.UIDPWD && TransportMode.BINARY == this.m_settings.m_transportMode) {
                tOpenSessionReq.setUsername(this.m_settings.m_username);
                tOpenSessionReq.setPassword(this.m_settings.m_password);
            }
            if (!this.m_settings.m_platformVersionUtils.isServerVersionSet(this.m_settings.m_serverVersion)) {
                this.m_openSessionResp = this.m_client.OpenSession(tOpenSessionReq);
                this.checkOpenSessionStatus();
                this.m_hasOpenSession = true;
                tGetInfoReq = new TGetInfoReq();
                tGetInfoReq.setInfoType(TGetInfoType.CLI_DBMS_VER);
                tGetInfoReq.setInfoTypeIsSet(true);
                tGetInfoReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                tGetInfoReq.setSessionHandleIsSet(true);
                tGetInfoResp = this.m_client.GetInfo(tGetInfoReq);
                string = "GetInfo - Server Version";
                this.checkIfRespNull((TBase)tGetInfoResp, string);
                this.checkResponseStatus(tGetInfoResp.getStatus(), string);
                this.m_settings.m_strServerVersion = tGetInfoResp.getInfoValue().getStringValue();
                this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(this.m_settings.m_strServerVersion);
                this.safeCloseSession();
            }
            if (this.m_settings.m_platformVersionUtils.supportsV6Protocol(this.m_settings.m_serverVersion)) {
                tOpenSessionReq.setClient_protocol(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6);
                this.m_openSessionResp = this.m_client.OpenSession(tOpenSessionReq);
                this.checkOpenSessionStatus();
                this.m_hasOpenSession = true;
            } else if (this.m_settings.m_platformVersionUtils.supportsV3Protocol(this.m_settings.m_serverVersion)) {
                tOpenSessionReq.setClient_protocol(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V3);
                this.m_openSessionResp = this.m_client.OpenSession(tOpenSessionReq);
                this.checkOpenSessionStatus();
                this.m_hasOpenSession = true;
            }
            tGetInfoReq = new TGetInfoReq();
            tGetInfoReq.setInfoType(TGetInfoType.CLI_DBMS_NAME);
            tGetInfoReq.setInfoTypeIsSet(true);
            tGetInfoReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
            tGetInfoReq.setSessionHandleIsSet(true);
            tGetInfoResp = this.m_client.GetInfo(tGetInfoReq);
            string = "GetInfo - Product Name";
            this.checkIfRespNull((TBase)tGetInfoResp, string);
            this.checkResponseStatus(tGetInfoResp.getStatus(), string);
            this.m_settings.m_dbmsName = tGetInfoResp.getInfoValue().getStringValue();
            this.dbmdInfo = new DatabaseMeatadataInfo(this.m_settings.m_dbmsName, this.m_settings.m_strServerVersion);
            boolean bl = false;
            String string2 = null;
            if (this.m_settings.m_dbmsName.contains(SPARK_SERVER_NAME)) {
                bl = true;
                string2 = this.m_settings.m_strServerVersion;
            } else if (this.m_settings.m_strServerVersion.contains("shark")) {
                bl = true;
                object = SHARK_HIVE_VERSION.matcher(this.m_settings.m_strServerVersion);
                if (((Matcher)object).find()) {
                    string2 = ((Matcher)object).group(2);
                }
            } else {
                object = super.runCatalogFunction(SET_DASH_V_QUERY_STRING, 0);
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    if (!((String)((ArrayList)object).get(i)).matches(SHARK_REGEX)) continue;
                    bl = true;
                    string2 = HIVE_SPARK_VERSION_MAP.get(this.m_settings.m_strServerVersion.substring(0, 4));
                }
            }
            if (bl && SPARK_SERVER_NAME == this.m_settings.m_connDBType) {
                this.m_settings.m_strServerVersion = string2;
                this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(this.m_settings.m_strServerVersion);
            }
            if (bl && SPARK_SERVER_NAME != this.m_settings.m_connDBType || !bl && SPARK_SERVER_NAME == this.m_settings.m_connDBType) {
                object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SESSION_ERR.name(), "Incorrect Server Type Connected To.");
                throw object;
            }
        }
        catch (Exception exception) {
            if (exception instanceof ErrorException) {
                ((ErrorException)exception).loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SESSION_ERR.name(), "Open Session Error");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    private String fullColumnTypeNameBuilder(TTypeEntry tTypeEntry) {
        TTypeQualifiers tTypeQualifiers = tTypeEntry.getPrimitiveEntry().getTypeQualifiers();
        TTypeId tTypeId = tTypeEntry.getPrimitiveEntry().getType();
        if (this.m_settings.m_platformVersionUtils.supportsCharLength(this.m_settings.m_serverVersion) && tTypeId.name().equalsIgnoreCase("CHAR_TYPE")) {
            int n = ((TTypeQualifierValue)tTypeQualifiers.getQualifiers().get("characterMaximumLength")).getI32Value();
            return "CHAR(" + n + ")";
        }
        if (this.m_settings.m_platformVersionUtils.supportsDecimalPrecisionAndScale(this.m_settings.m_serverVersion) && tTypeId.name().equalsIgnoreCase("DECIMAL_TYPE")) {
            int n = ((TTypeQualifierValue)tTypeQualifiers.getQualifiers().get("precision")).getI32Value();
            int n2 = ((TTypeQualifierValue)tTypeQualifiers.getQualifiers().get("scale")).getI32Value();
            return "DECIMAL(" + n + ", " + n2 + ")";
        }
        if (this.m_settings.m_platformVersionUtils.supportsVarcharLength(this.m_settings.m_serverVersion) && tTypeId.name().equalsIgnoreCase("VARCHAR_TYPE")) {
            int n = ((TTypeQualifierValue)tTypeQualifiers.getQualifiers().get("characterMaximumLength")).getI32Value();
            return "VARCHAR(" + n + ")";
        }
        if (this.m_settings.m_platformVersionUtils.supportsNestedDataTypes(this.m_settings.m_serverVersion)) {
            if (tTypeId.name().equalsIgnoreCase("ARRAY_TYPE")) {
                return "ARRAY";
            }
            if (tTypeId.name().equalsIgnoreCase("STRUCT_TYPE")) {
                return "STRUCT";
            }
            if (tTypeId.name().equalsIgnoreCase("MAP_TYPE")) {
                return "MAP";
            }
        }
        if (this.m_settings.m_platformVersionUtils.supportsUnionDataTypes(this.m_settings.m_serverVersion) && tTypeId.name().equalsIgnoreCase("UNION_TYPE")) {
            return "UNION";
        }
        return "null";
    }

    private ArrayList<String> getQualifiedTypeNames(String string, String string2) throws ErrorException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string3 = string == null || string.equals("") ? this.getCurrentSchema() + "." : string + ".";
            HiveExecutionContext hiveExecutionContext = this.executeStatement("DESCRIBE " + string3 + string2, null);
            RowsetBuffer<HS2Buffer> rowsetBuffer = this.makeRowsetBuffer();
            do {
                String string4;
                this.fetchNRows(hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                this.checkFetchErrors(rowsetBuffer);
                int n = ((HS2Buffer)rowsetBuffer.m_buffer).getNumRows();
                for (int i = 0; i < n && null != (string4 = ((HS2Buffer)rowsetBuffer.m_buffer).getString(i, 1)); ++i) {
                    arrayList.add(string4.toUpperCase().trim());
                }
            } while (rowsetBuffer.m_serverHasMoreRows);
            this.closeOperation(hiveExecutionContext);
            return arrayList;
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage());
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
            return new ArrayList<String>();
        }
    }

    static {
        HIVE_SPARK_VERSION_MAP.put("0.11", "0.9");
        HIVE_SPARK_VERSION_MAP.put("0.12", "1.1");
    }
}

