/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.aeprocessor.aebuilder.value;

import com.cloudera.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.cloudera.sqlengine.aeprocessor.aebuilder.AEBuilderCheck;
import com.cloudera.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.cloudera.sqlengine.aeprocessor.aebuilder.value.AEValueExprBuilder;
import com.cloudera.sqlengine.aeprocessor.aetree.ScalarFunctionID;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.sqlengine.aeprocessor.metadatautil.AECoercionColumnInfo;
import com.cloudera.sqlengine.dsiext.dataengine.IScalarFnMetadataHandler;
import com.cloudera.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.sqlengine.parser.parsetree.PTIdentifierNode;
import com.cloudera.sqlengine.parser.parsetree.PTListNode;
import com.cloudera.sqlengine.parser.parsetree.PTLiteralNode;
import com.cloudera.sqlengine.parser.parsetree.PTNonterminalNode;
import com.cloudera.sqlengine.parser.type.PTListType;
import com.cloudera.sqlengine.parser.type.PTLiteralType;
import com.cloudera.sqlengine.parser.type.PTNonterminalType;
import com.cloudera.sqlengine.parser.type.PTPositionalType;
import com.cloudera.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AEScalarFnBuilder
extends AEBuilderBase<AEScalarFn> {
    private static final Map<String, Map<Integer, ScalarFunctionID>> SCALAR_FN_LOOKUP;
    private SqlDataEngine m_dataEngine;

    protected AEScalarFnBuilder(AEQueryScope aEQueryScope) {
        super(aEQueryScope);
        this.m_dataEngine = aEQueryScope.getDataEngine();
    }

    @Override
    public AEScalarFn visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        Object object;
        Object object3;
        ScalarFunctionID scalarFunctionID;
        AEBuilderCheck.checkThat(pTNonterminalNode, AEBuilderCheck.is(AEBuilderCheck.nonTerminal(PTNonterminalType.FUNC)).withExactChildren(PTPositionalType.NAME, AEBuilderCheck.identifier(), PTPositionalType.PARAM_LIST, AEBuilderCheck.optionalList(PTListType.PARAMETER_LIST)));
        String string = ((PTIdentifierNode)pTNonterminalNode.getChild(PTPositionalType.NAME)).getIdentifier();
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.PARAM_LIST);
        PTListNode pTListNode = iPTNode.isEmptyNode() ? new PTListNode(PTListType.PARAMETER_LIST) : (PTListNode)iPTNode;
        Map<Integer, ScalarFunctionID> map = SCALAR_FN_LOOKUP.get(string);
        if (null == map) {
            scalarFunctionID = ScalarFunctionID.CUSTOM;
        } else {
            scalarFunctionID = map.get(pTListNode.numChildren());
            if (null == scalarFunctionID) {
                throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
            }
        }
        AEValueExprBuilder aEValueExprBuilder = new AEValueExprBuilder(this.getQueryScope());
        AEValueExprList aEValueExprList = new AEValueExprList();
        ArrayList<AECoercionColumnInfo> arrayList = new ArrayList<AECoercionColumnInfo>();
        if (ScalarFunctionID.CONVERT == scalarFunctionID || ScalarFunctionID.CAST == scalarFunctionID) {
            if (2 != pTListNode.numChildren()) {
                throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
            }
            object3 = (AEValueExpr)aEValueExprBuilder.build(pTListNode.getChild(0));
            aEValueExprList.addNode(object3);
            arrayList.add(new AECoercionColumnInfo((AEValueExpr)object3));
            IPTNode object22 = pTListNode.getChild(1);
            if (object22 instanceof PTLiteralNode) {
                object3 = (AEValueExpr)aEValueExprBuilder.build(object22);
            } else if (object22 instanceof PTIdentifierNode) {
                object3 = (AEValueExpr)aEValueExprBuilder.build(new PTLiteralNode(PTLiteralType.CHARSTR, ((PTIdentifierNode)object22).getIdentifier()));
            } else if (object22 instanceof PTNonterminalNode && PTNonterminalType.COLUMN_REFERENCE == ((PTNonterminalNode)object22).getNonterminalType()) {
                object = (PTNonterminalNode)object22;
                object3 = (AEValueExpr)aEValueExprBuilder.build(new PTLiteralNode(PTLiteralType.CHARSTR, ((PTIdentifierNode)((PTNonterminalNode)object).getChild(PTPositionalType.COLUMN_NAME)).getIdentifier()));
            } else {
                throw ScalarFunctionID.CONVERT == scalarFunctionID ? SQLEngineExceptionFactory.invalidSecondArgumentToConvertException() : SQLEngineExceptionFactory.invalidSecondArgumentToCastException();
            }
            aEValueExprList.addNode(object3);
            arrayList.add(new AECoercionColumnInfo((AEValueExpr)object3));
        } else {
            for (IPTNode iPTNode2 : pTListNode.getImmutableChildList()) {
                object = (AEValueExpr)aEValueExprBuilder.build(iPTNode2);
                aEValueExprList.addNode(object);
                arrayList.add(new AECoercionColumnInfo((AEValueExpr)object));
            }
        }
        object3 = this.m_dataEngine.getContext().getScalarFnMetadataHandler();
        IScalarFnMetadataHandler.ScalarFnMetadata scalarFnMetadata = object3.createMetadata(this.m_dataEngine.getContext(), scalarFunctionID, string, arrayList);
        object = new AEScalarFn(string, scalarFunctionID, scalarFnMetadata.getColumnMetadata(), aEValueExprList, scalarFnMetadata.getExpectedArgumentMetadata(), (IScalarFnMetadataHandler)object3, this.m_dataEngine.getContext());
        arrayList.clear();
        Iterator iterator = ((AEScalarFn)object).getArguments().getChildItr();
        while (iterator.hasNext()) {
            arrayList.add(new AECoercionColumnInfo((AEValueExpr)iterator.next()));
        }
        object3.validateMetadata(this.m_dataEngine.getContext(), scalarFunctionID, string, arrayList);
        return object;
    }

    static {
        TreeMap<String, Map<Integer, ScalarFunctionID>> treeMap = new TreeMap<String, Map<Integer, ScalarFunctionID>>(String.CASE_INSENSITIVE_ORDER);
        for (ScalarFunctionID scalarFunctionID : ScalarFunctionID.values()) {
            if (ScalarFunctionID.CUSTOM == scalarFunctionID) continue;
            Map<Integer, ScalarFunctionID> map = treeMap.get(scalarFunctionID.getName());
            if (null == map) {
                map = new HashMap<Integer, ScalarFunctionID>();
                treeMap.put(scalarFunctionID.getName(), map);
            }
            map.put(scalarFunctionID.getArguments().size(), scalarFunctionID);
        }
        SCALAR_FN_LOOKUP = treeMap;
    }
}

