/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.stat.ConnectionStat;
import dm.jdbc.filter.stat.SqlStat;
import dm.jdbc.filter.stat.util.JSONWriter;
import dm.jdbc.internal.enums.ExecuteType;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.util.Date;

public class StatUtil {
    public static void statementCreateAfter(DmdbConnection conn, DmdbStatement stmt) {
        if (stmt.statInfo == null) {
            stmt.statInfo = stmt.createStatInfo();
        }
        stmt.statInfo.setConstructNano();
        conn.statInfo.getConnStat().incrementStmt();
    }

    public static void statementExecuteUpdateBefore(DmdbStatement stmt, String sql) {
        stmt.statInfo.setLastExecuteSql(sql);
        stmt.statInfo.setFirstResultSet(false);
        stmt.statInfo.setLastExecuteType(ExecuteType.UPDATE);
        StatUtil.internalBeforeStatementExecute(stmt, sql);
    }

    public static void statementExecuteUpdateAfter(DmdbStatement stmt, String sql, int updateCount) {
        StatUtil.internalAfterStatementExecute(stmt, updateCount);
    }

    public static void statementExecuteQueryBefore(DmdbStatement stmt, String sql) {
        stmt.statInfo.setLastExecuteSql(sql);
        stmt.statInfo.setFirstResultSet(true);
        stmt.statInfo.setLastExecuteType(ExecuteType.QUERY);
        StatUtil.internalBeforeStatementExecute(stmt, sql);
    }

    public static void statementExecuteQueryAfter(DmdbStatement stmt, String sql, DmdbResultSet resultSet) {
        if (resultSet != null) {
            StatUtil.resultSetCreateAfter(resultSet, stmt);
        }
        StatUtil.internalAfterStatementExecute(stmt, new int[0]);
    }

    public static void statementExecuteBefore(DmdbStatement stmt, String sql) {
        stmt.statInfo.setLastExecuteSql(sql);
        stmt.statInfo.setFirstResultSet(false);
        stmt.statInfo.setLastExecuteType(ExecuteType.ALL);
        StatUtil.internalBeforeStatementExecute(stmt, sql);
    }

    public static void statementExecuteAfter(DmdbStatement stmt, String sql, boolean firstResult) {
        stmt.statInfo.setFirstResultSet(firstResult);
        StatUtil.internalAfterStatementExecute(stmt, new int[0]);
    }

    public static void statementExecuteBatchBefore(DmdbStatement stmt) {
        int batchSize = stmt.batchSqls == null ? 0 : stmt.batchSqls.size();
        String sql = batchSize > 0 ? stmt.batchSqls.get(0) : "";
        SqlStat sqlStat = stmt.statInfo.getSqlStat();
        if (sqlStat == null || sqlStat.isRemoved() || !sqlStat.getSql().equals(sql)) {
            sqlStat = stmt.connection.statInfo.getConnStat().createSqlStat(sql);
            stmt.statInfo.setSqlStat(sqlStat);
        }
        if (sqlStat != null) {
            sqlStat.addExecuteBatchCount(batchSize);
        }
        stmt.statInfo.setLastExecuteSql(sql);
        stmt.statInfo.setFirstResultSet(false);
        stmt.statInfo.setLastExecuteType(ExecuteType.BATCH);
        StatUtil.internalBeforeStatementExecute(stmt, sql);
    }

    public static void statementExecuteBatchAfter(DmdbStatement stmt, int[] result) {
        StatUtil.internalAfterStatementExecute(stmt, result);
    }

    public static void preparedStatementExecuteBefore(DmdbStatement stmt) {
        StatUtil.statementExecuteBefore(stmt, stmt.nativeSql);
    }

    public static void preparedStatementExecuteAfter(DmdbStatement stmt, boolean firstResult) {
        StatUtil.statementExecuteAfter(stmt, stmt.nativeSql, firstResult);
    }

    public static void preparedStatementExecuteUpdateBefore(DmdbStatement stmt) {
        StatUtil.statementExecuteUpdateBefore(stmt, stmt.nativeSql);
    }

    public static void preparedStatementExecuteUpdateAfter(DmdbStatement stmt, int updateCount) {
        StatUtil.statementExecuteUpdateAfter(stmt, stmt.nativeSql, updateCount);
    }

    public static void preparedStatementExecuteQueryBefore(DmdbStatement stmt) {
        StatUtil.statementExecuteQueryBefore(stmt, stmt.nativeSql);
    }

    public static void preparedStatementExecuteQueryAfter(DmdbStatement stmt, DmdbResultSet resultSet) {
        if (resultSet != null) {
            StatUtil.resultSetCreateAfter(resultSet, stmt);
        }
        StatUtil.internalAfterStatementExecute(stmt, new int[0]);
    }

    public static void preparedStatementExecuteBatchAfter(DmdbStatement stmt, int[] updateCount) {
        StatUtil.statementExecuteBatchAfter(stmt, updateCount);
    }

    public static void preparedStatementExecuteBatchBefore(DmdbStatement stmt) {
        StatUtil.statementExecuteBatchBefore(stmt);
    }

    public static void internalBeforeStatementExecute(DmdbStatement stmt, String sql) {
        ConnectionStat connStat = stmt.connection.statInfo.getConnStat();
        connStat.incrementExecuteCount();
        stmt.statInfo.beforeExecute();
        SqlStat sqlStat = stmt.statInfo.getSqlStat();
        if (sqlStat == null || sqlStat.isRemoved() || !sqlStat.getSql().equals(sql)) {
            sqlStat = connStat.createSqlStat(sql);
            stmt.statInfo.setSqlStat(sqlStat);
        }
        boolean inTransaction = false;
        boolean bl = inTransaction = !stmt.connection.do_getAutoCommit();
        if (sqlStat != null) {
            sqlStat.setExecuteLastStartTime(System.currentTimeMillis());
            sqlStat.incrementRunningCount();
            if (inTransaction) {
                sqlStat.incrementInTransactionCount();
            }
        }
    }

    public static void internalAfterStatementExecute(DmdbStatement stmt, int ... updateCountArray) {
        long nowNano = System.nanoTime();
        long nanos = nowNano - stmt.statInfo.getLastExecuteStartNano();
        stmt.statInfo.afterExecute(nanos);
        SqlStat sqlStat = stmt.statInfo.getSqlStat();
        if (sqlStat != null) {
            sqlStat.incrementExecuteSuccessCount();
            sqlStat.decrementRunningCount();
            String parameters = "";
            if (stmt instanceof DmdbPreparedStatement) {
                parameters = StatUtil.buildSlowParameters((DmdbPreparedStatement)stmt);
            }
            sqlStat.addExecuteTime(stmt.statInfo.getLastExecuteType(), stmt.statInfo.isFirstResultSet(), nanos, parameters);
            if (!stmt.statInfo.isFirstResultSet() && stmt.statInfo.getLastExecuteType() == ExecuteType.ALL) {
                int updateCount = (int)stmt.execInfo.updateCount;
                updateCount = updateCount < 0 ? 0 : updateCount;
                sqlStat.addUpdateCount(updateCount);
            } else {
                int[] nArray = updateCountArray;
                int n2 = updateCountArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int updateCount = nArray[n3];
                    sqlStat.addUpdateCount(updateCount);
                    sqlStat.addFetchRowCount(0L);
                    ++n3;
                }
            }
        }
    }

    public static String buildSlowParameters(DmdbPreparedStatement stmt) {
        JSONWriter out = new JSONWriter();
        out.writeArrayStart();
        int i2 = 0;
        int parametersSize = stmt.paramCount;
        while (i2 < parametersSize) {
            Object value = StatUtil.getParamObject(stmt, 0, i2);
            if (i2 != 0) {
                out.writeComma();
            }
            if (value == null) {
                out.writeNull();
            } else if (value instanceof String) {
                String text = (String)value;
                if (text.length() > 100) {
                    out.writeString(String.valueOf(text.substring(0, 97)) + "...");
                } else {
                    out.writeString(text);
                }
            } else if (value instanceof Number) {
                out.writeObject(value);
            } else if (value instanceof Date) {
                out.writeObject(value);
            } else if (value instanceof Boolean) {
                out.writeObject(value);
            } else if (value instanceof InputStream) {
                out.writeString("<InputStream>");
            } else if (value instanceof NClob) {
                out.writeString("<NClob>");
            } else if (value instanceof Clob) {
                out.writeString("<Clob>");
            } else if (value instanceof Blob) {
                out.writeString("<Blob>");
            } else {
                out.writeString(String.valueOf('<') + value.getClass().getName() + '>');
            }
            ++i2;
        }
        out.writeArrayEnd();
        return out.toString();
    }

    public static void statementExecuteErrorAfter(DmdbStatement stmt, Throwable error) {
        long nanos = System.nanoTime() - stmt.statInfo.getLastExecuteStartNano();
        stmt.connection.statInfo.getConnStat().incrementErrorCount();
        stmt.statInfo.afterExecute(nanos);
        SqlStat sqlStat = stmt.statInfo.getSqlStat();
        if (sqlStat != null) {
            sqlStat.decrementRunningCount();
            sqlStat.error(error);
            String parameters = "";
            if (stmt instanceof DmdbPreparedStatement) {
                parameters = StatUtil.buildSlowParameters((DmdbPreparedStatement)stmt);
            }
            sqlStat.addExecuteTime(stmt.statInfo.getLastExecuteType(), stmt.statInfo.isFirstResultSet(), nanos, parameters);
        }
    }

    public static void statementCloseBefore(DmdbStatement stmt) {
        stmt.connection.statInfo.getConnStat().decrementStmt();
    }

    public static void resultSetCreateAfter(DmdbResultSet dmdbResultSet, DmdbStatement stmt) {
        if (dmdbResultSet.statInfo == null) {
            dmdbResultSet.statInfo = dmdbResultSet.createStatInfo();
        }
        dmdbResultSet.statInfo.setSql(stmt.statInfo.getLastExecuteSql());
        dmdbResultSet.statInfo.setSqlStat(stmt.statInfo.getSqlStat());
        dmdbResultSet.statInfo.setConstructNano();
    }

    public static void resultSetCloseBefore(DmdbResultSet resultSet) {
        long nanos = System.nanoTime() - resultSet.statInfo.getConstructNano();
        long fetchRowCount = StatUtil.getFetchedRows(resultSet);
        SqlStat sqlStat = resultSet.statInfo.getSqlStat();
        if (sqlStat != null && resultSet.statInfo.getCloseCount() == 0) {
            sqlStat.addFetchRowCount(fetchRowCount);
            long stmtExecuteNano = resultSet.statInfo.getLastExecuteTimeNano();
            sqlStat.addResultSetHoldTimeNano(stmtExecuteNano, nanos);
            if (resultSet.statInfo.getReadStringLength() > 0L) {
                sqlStat.addStringReadLength(resultSet.statInfo.getReadStringLength());
            }
            if (resultSet.statInfo.getReadBytesLength() > 0L) {
                sqlStat.addReadBytesLength(resultSet.statInfo.getReadBytesLength());
            }
            if (resultSet.statInfo.getOpenInputStreamCount() > 0) {
                sqlStat.addInputStreamOpenCount(resultSet.statInfo.getOpenInputStreamCount());
            }
            if (resultSet.statInfo.getOpenReaderCount() > 0) {
                sqlStat.addReaderOpenCount(resultSet.statInfo.getOpenReaderCount());
            }
        }
        resultSet.statInfo.incrementCloseCount();
    }

    public static int getActiveStmtCount(DmdbConnection conn) {
        return conn.activeStmtList == null ? 0 : conn.activeStmtList.size();
    }

    public static Object getParamObject(DmdbPreparedStatement pstmt, int irow, int icol) {
        if (pstmt.multiRowDatas != null && pstmt.multiRowDatas.size() > 0) {
            Object[] row = pstmt.multiRowDatas.get(irow);
            return row[icol];
        }
        return pstmt.curRowDatas[icol];
    }

    public static long getFetchedRows(DmdbResultSet rs) {
        if (rs.currentPos >= rs.totalRowCount) {
            return rs.totalRowCount;
        }
        return rs.currentPos + 1L;
    }
}

