/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.filter.Filterable;
import dm.jdbc.internal.desc.Parameter;
import dm.jdbc.internal.desc.TypeDesc;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbParameterMetaData
extends Filterable
implements ParameterMetaData {
    public DmdbConnection connection;
    private Parameter[] params;
    private TypeDesc[] typeDescs;
    public static AtomicLong IDGenerator = new AtomicLong(0L);

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    public DmdbParameterMetaData(DmdbConnection connection, Parameter[] params) {
        super(connection, null);
        this.connection = connection;
        this.params = params;
        this.typeDescs = new TypeDesc[params.length];
    }

    private Parameter checkIndex(int param) throws SQLException {
        if (param < 1 || param > this.params.length) {
            DBError.ECJDBC_INVALID_SEQUENCE_NUMBER.throwz(new Object[0]);
        }
        if (this.typeDescs[param - 1] == null) {
            this.typeDescs[param - 1] = DmdbType.getTypeDesc(this.params[param - 1], this.connection);
        }
        return this.params[param - 1];
    }

    public int do_getParameterCount() throws SQLException {
        return this.params.length;
    }

    public int do_isNullable(int param) throws SQLException {
        Parameter paramDesc = this.checkIndex(param);
        return paramDesc.nullable ? 1 : 0;
    }

    public boolean do_isSigned(int param) throws SQLException {
        Parameter paramDesc = this.checkIndex(param);
        return DmdbType.isNumber(paramDesc.type);
    }

    public int do_getPrecision(int param) throws SQLException {
        this.checkIndex(param);
        return this.typeDescs[param - 1].jprec;
    }

    public int do_getScale(int param) throws SQLException {
        this.checkIndex(param);
        return this.typeDescs[param - 1].jscale;
    }

    public int do_getParameterType(int param) throws SQLException {
        this.checkIndex(param);
        return this.typeDescs[param - 1].jtype;
    }

    public String do_getParameterTypeName(int param) throws SQLException {
        this.checkIndex(param);
        return this.typeDescs[param - 1].dtypeName;
    }

    public String do_getParameterClassName(int param) throws SQLException {
        this.checkIndex(param);
        return this.typeDescs[param - 1].jclassName;
    }

    public int do_getParameterMode(int param) throws SQLException {
        Parameter paramDesc = this.checkIndex(param);
        int ioType = 0;
        switch (paramDesc.ioType) {
            case 0: {
                ioType = 1;
                break;
            }
            case 1: {
                ioType = 4;
                break;
            }
            case 2: {
                ioType = 2;
                break;
            }
        }
        return ioType;
    }

    @Override
    @Deprecated
    public int getParameterCount() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getParameterCount();
        }
        return this.filterHead.ParameterMetaData_getParameterCount(this);
    }

    @Override
    @Deprecated
    public int isNullable(int param) throws SQLException {
        if (this.filterHead == null) {
            return this.do_isNullable(param);
        }
        return this.filterHead.ParameterMetaData_isNullable(this, param);
    }

    @Override
    @Deprecated
    public boolean isSigned(int param) throws SQLException {
        if (this.filterHead == null) {
            return this.do_isSigned(param);
        }
        return this.filterHead.ParameterMetaData_isSigned(this, param);
    }

    @Override
    @Deprecated
    public int getPrecision(int param) throws SQLException {
        if (this.filterHead == null) {
            return this.do_getPrecision(param);
        }
        return this.filterHead.ParameterMetaData_getPrecision(this, param);
    }

    @Override
    @Deprecated
    public int getScale(int param) throws SQLException {
        if (this.filterHead == null) {
            return this.do_getScale(param);
        }
        return this.filterHead.ParameterMetaData_getScale(this, param);
    }

    @Override
    @Deprecated
    public int getParameterType(int param) throws SQLException {
        if (this.filterHead == null) {
            return this.do_getParameterType(param);
        }
        return this.filterHead.ParameterMetaData_getParameterType(this, param);
    }

    @Override
    @Deprecated
    public String getParameterTypeName(int param) throws SQLException {
        if (this.filterHead == null) {
            return this.do_getParameterTypeName(param);
        }
        return this.filterHead.ParameterMetaData_getParameterTypeName(this, param);
    }

    @Override
    @Deprecated
    public String getParameterClassName(int param) throws SQLException {
        if (this.filterHead == null) {
            return this.do_getParameterClassName(param);
        }
        return this.filterHead.ParameterMetaData_getParameterClassName(this, param);
    }

    @Override
    @Deprecated
    public int getParameterMode(int param) throws SQLException {
        if (this.filterHead == null) {
            return this.do_getParameterMode(param);
        }
        return this.filterHead.ParameterMetaData_getParameterMode(this, param);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public String getParameterName(int paramIndex) throws SQLException {
        this.checkIndex(paramIndex);
        return this.params[paramIndex - 1].name;
    }
}

