/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;

public class CacheQueue<T> {
    private LinkedBlockingQueue<T> queue = null;
    public int maxSize;
    private boolean enableLRU = true;

    public CacheQueue(int maxSize) {
        this.queue = new LinkedBlockingQueue(maxSize);
        this.maxSize = maxSize;
    }

    public CacheQueue(int maxSize, boolean enableLRU) {
        this.queue = new LinkedBlockingQueue(maxSize);
        this.maxSize = maxSize;
        this.enableLRU = enableLRU;
    }

    protected boolean needRemove(T element) {
        return false;
    }

    protected void beforeRemove(T element) {
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public synchronized T get() {
        T element;
        block4: {
            T t2;
            block3: {
                element = null;
                if (!true) break block3;
                t2 = this.queue.poll();
                element = t2;
                if (t2 == null) break block4;
            }
            do {
                if (!this.needRemove(element)) {
                    return element;
                }
                this.beforeRemove(element);
                t2 = this.queue.poll();
                element = t2;
            } while (t2 != null);
        }
        return element;
    }

    public synchronized boolean put(T value) {
        if (this.queue.contains(value)) {
            return true;
        }
        if (this.queue.size() < this.maxSize) {
            this.queue.add(value);
            return true;
        }
        if (this.enableLRU) {
            T eldest = this.get();
            this.beforeRemove(eldest);
            this.queue.add(value);
            return true;
        }
        this.beforeRemove(value);
        return false;
    }

    public int size() {
        return this.queue.size();
    }

    public synchronized void clear() {
        this.queue.clear();
    }

    public Iterator<T> iterator() {
        return this.queue.iterator();
    }

    public Object clone() {
        CacheQueue<T> newObject = new CacheQueue<T>(this.maxSize, this.enableLRU);
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            newObject.put(iterator.next());
        }
        return newObject;
    }
}

