/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.MathUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;

public class DmdbNumeric
implements Serializable {
    private static final long serialVersionUID = 3847946444882096464L;
    public static final BigDecimal MAX_VALUE = new BigDecimal("99999999999999999999999999999999999999");
    public static final BigDecimal MIN_VALUE = new BigDecimal("-99999999999999999999999999999999999999");
    public static final BigDecimal SERVER_NEG_MIN_VALUE = new BigDecimal("-1E-128");
    public static final BigDecimal SERVER_POSITIVE_MIN_VALUE = new BigDecimal("1E-128");
    public static boolean ROUND_HALF_SWITCH = false;
    public static final int XDEC_MAX_PREC = 38;
    private static final int XDEC_SIZE = 21;
    private static final int FLAG_ZERO = 128;
    public static final int FLAG_POSITIVE = 193;
    public static final int FLAG_NEGTIVE = 62;
    private static final int EXP_MAX = 61;
    private static final int EXP_MIN = -64;
    private static final int NUM_POSITIVE = 1;
    private static final int NUM_NEGTIVE = 101;
    private int sign = 0;
    private int weight = 0;
    private String digits = "";
    private int prec;
    private int scale;
    private boolean hasScale = false;

    private DmdbNumeric(int prec, int scale) {
        this.prec = prec;
        this.scale = scale;
        this.hasScale = scale != -1 && (prec > 0 || scale > 0);
    }

    public DmdbNumeric(byte[] values, int prec, int scale) throws SQLException {
        this(prec, scale);
        this.decode(values);
    }

    public static DmdbNumeric valueOf(BigDecimal dec, int prec, int scale) throws SQLException {
        DmdbNumeric n2 = new DmdbNumeric(prec, scale);
        n2.parse(dec);
        return n2;
    }

    public static DmdbNumeric valueOf(String str, int prec, int scale) throws SQLException {
        DmdbNumeric n2 = new DmdbNumeric(prec, scale);
        n2.parse(str);
        return n2;
    }

    public static DmdbNumeric valueOf(long val, int prec, int scale) throws SQLException {
        return DmdbNumeric.valueOf(new BigDecimal(val), prec, scale);
    }

    public BigDecimal toBigDecimal(boolean compatibleOracle) {
        BigDecimal dec = null;
        if (this.isZero()) {
            dec = new BigDecimal("0");
        } else {
            String digitsStr = this.sign < 0 ? "-" + this.digits.toString() : this.digits.toString();
            dec = new BigDecimal(digitsStr);
            if (this.weight > 0) {
                dec = dec.movePointRight(this.weight);
            } else if (this.weight < 0) {
                dec = dec.movePointLeft(-this.weight);
            }
        }
        dec = this.roundHalfup(dec);
        if (!compatibleOracle && this.hasScale) {
            dec = dec.setScale(this.scale, 4);
        }
        return dec;
    }

    public String toString(boolean compatibleOracle) {
        BigDecimal dec = this.toBigDecimal(compatibleOracle);
        return dec.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public boolean isZero() {
        return this.sign == 0;
    }

    public void decode(byte[] values) throws SQLException {
        if (values == null || values.length == 0 || values.length > 21) {
            DBError.ECJDBC_FATAL_ERROR.throwz(new Object[0]);
        }
        if (values[0] == 128 || values.length == 1) {
            this.sign = 0;
            return;
        }
        this.sign = (values[0] & 0x80) != 0 ? 1 : -1;
        int flag = ByteUtil.getUB1(values, 0);
        int exp = this.sign > 0 ? flag - 193 : 62 - flag;
        StringBuilder sf = new StringBuilder();
        int digit = 0;
        int ival = 1;
        while (ival < values.length) {
            int n2 = digit = this.sign > 0 ? values[ival] - 1 : 101 - values[ival];
            if (digit < 0 || digit > 99) break;
            if (digit < 10) {
                sf.append("0");
            }
            sf.append(digit);
            ++ival;
        }
        this.digits = sf.toString();
        this.weight = exp * 2 - (this.digits.length() - 2);
        this.formatDigits();
    }

    public byte[] encode() throws SQLException {
        int exp;
        if (this.isZero()) {
            return new byte[]{-128};
        }
        this.checkPrec();
        if (MathUtil.isOdd(this.weight)) {
            this.digits = String.valueOf(this.digits) + "0";
            --this.weight;
        }
        if (MathUtil.isOdd(this.digits.length())) {
            this.digits = "0" + this.digits;
        }
        if ((exp = (this.weight + this.digits.length()) / 2 - 1) > 61 || exp < -64) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
        int digitLen = this.digits.length();
        int validLen = this.digits.length() / 2 + 1;
        int carry = 0;
        if (validLen > 21) {
            validLen = 21;
            digitLen = 2 * (validLen - 1);
            carry = Character.digit(this.digits.charAt(digitLen), 10) >= 5 ? 1 : 0;
        }
        int retLen = this.sign < 0 && validLen < 21 ? validLen + 1 : validLen;
        byte[] retBytes = new byte[retLen];
        int digit = 0;
        int ibytes = validLen - 1;
        boolean endZero = true;
        int ichar = digitLen - 1;
        while (ichar > 0 && ibytes > 0) {
            int n2 = carry = (digit = Character.digit(this.digits.charAt(ichar--), 10) + Character.digit(this.digits.charAt(ichar--), 10) * 10 + carry) > 99 ? 1 : 0;
            if (digit > 99) {
                digit %= 100;
            }
            boolean bl = endZero = endZero && digit == 0;
            if (endZero) {
                --validLen;
            }
            retBytes[ibytes] = (byte)(this.sign > 0 ? digit + 1 : 101 - digit);
            --ibytes;
        }
        if (endZero && carry > 0) {
            ++exp;
            digit = carry;
            retBytes[validLen] = (byte)(this.sign > 0 ? digit + 1 : 101 - digit);
            ++validLen;
        }
        retBytes[0] = (byte)(this.sign > 0 ? exp + 193 : 62 - exp);
        if (this.sign < 0 && validLen < 21) {
            retBytes[validLen++] = 102;
        }
        if (validLen < retBytes.length) {
            byte[] tmp = new byte[validLen];
            System.arraycopy(retBytes, 0, tmp, 0, validLen);
            retBytes = tmp;
        }
        return retBytes;
    }

    private void parse(BigDecimal dec) throws SQLException {
        String digitStr;
        dec = this.roundHalfup(dec);
        this.sign = dec.signum();
        if (this.isZero()) {
            return;
        }
        if (this.sign < 0) {
            dec = dec.negate();
        }
        if ((digitStr = dec.toPlainString()).indexOf(".") != -1) {
            this.digits = digitStr.replace(".", "");
            this.weight = -dec.scale();
        } else {
            this.digits = digitStr;
            this.weight = 0;
        }
        this.formatDigits();
    }

    private BigDecimal roundHalfup(BigDecimal dec) {
        if (this.hasScale && dec.scale() > this.scale) {
            dec = dec.setScale(this.scale, 4);
        }
        int digitsLen = dec.precision();
        if (this.hasScale && digitsLen > this.prec) {
            if (dec.scale() >= digitsLen - this.prec) {
                dec = dec.setScale(dec.scale() - (digitsLen - this.prec), 4);
            } else if (dec.scale() < digitsLen - this.prec) {
                int moveLeft = digitsLen - this.prec - dec.scale();
                dec = dec.movePointLeft(digitsLen - this.prec - dec.scale());
                this.weight += moveLeft;
                dec = dec.setScale(0, 4);
            }
        }
        if (ROUND_HALF_SWITCH) {
            if (SERVER_NEG_MIN_VALUE.compareTo(dec) < 0 && dec.signum() != 1) {
                dec = BigDecimal.ZERO;
            }
            if (SERVER_POSITIVE_MIN_VALUE.compareTo(dec) > 0 && dec.signum() == 1) {
                dec = BigDecimal.ZERO;
            }
        }
        return dec;
    }

    private void formatDigits() {
        int fzeroCount = 0;
        char[] chars = this.digits.toCharArray();
        int i2 = 0;
        while (i2 < chars.length) {
            if (chars[i2] != '0') break;
            ++fzeroCount;
            ++i2;
        }
        int bzeroCount = 0;
        int i3 = chars.length - 1;
        while (i3 >= fzeroCount) {
            if (chars[i3] != '0') break;
            ++bzeroCount;
            --i3;
        }
        if (bzeroCount > 0 || fzeroCount > 0) {
            this.digits = new String(chars, fzeroCount, chars.length - fzeroCount - bzeroCount);
            this.weight += bzeroCount;
        }
    }

    private void parse(String str) throws SQLException {
        BigDecimal dec = null;
        try {
            dec = new BigDecimal(str);
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
        this.parse(dec);
    }

    private boolean checkPrec() throws SQLException {
        int digitsLen = this.digits.length();
        if (this.hasScale && (digitsLen > this.prec || digitsLen > 38)) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        BigDecimal dec = new BigDecimal("12.34e+12");
        long start = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 100000000) {
            DmdbNumeric.valueOf(dec, 0, 0);
            ++i2;
        }
        System.out.println(String.valueOf(System.currentTimeMillis() - start) + "ms");
    }
}

