/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.datawrapper;

import com.cloudera.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.dsi.exceptions.IncorrectTypeException;
import com.cloudera.sqlengine.exceptions.SQLEngineException;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.exceptions.ErrorException;

public final class SqlBinaryDataWrapper
extends DefaultSqlDataWrapper {
    private byte[] m_data;
    private boolean m_isSet = false;
    private final int m_type;

    public SqlBinaryDataWrapper(int n) {
        assert (n == -2 || n == -3 || n == -4);
        this.m_type = n;
    }

    public byte[] getBinary() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    public int getType() {
        return this.m_type;
    }

    public boolean isNull() throws ErrorException {
        this.checkIsSet();
        return this.m_data == null;
    }

    public boolean isSet() {
        return this.m_isSet;
    }

    public void setBinary(byte[] byArray) {
        this.m_isSet = true;
        this.m_data = byArray;
    }

    public void setNull() {
        this.m_isSet = true;
        this.m_data = null;
    }

    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        try {
            byte[] byArray = null;
            switch (dataWrapper.getType()) {
                case -2: {
                    byArray = dataWrapper.getBinary();
                    break;
                }
                case -3: {
                    byArray = dataWrapper.getVarBinary();
                    break;
                }
                case -4: {
                    byArray = dataWrapper.getLongVarBinary();
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                }
            }
            this.setBinary(byArray);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
        }
    }

    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        this.checkIsSet();
        switch (this.m_type) {
            case -2: {
                dataWrapper.setBinary(this.m_data);
                break;
            }
            case -3: {
                dataWrapper.setVarBinary(this.m_data);
                break;
            }
            case -4: {
                dataWrapper.setLongVarBinary(this.m_data);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void checkIsSet() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
    }
}

