/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.aeprocessor.aeoptimizer;

import com.cloudera.dsi.exceptions.IncorrectTypeException;
import com.cloudera.dsi.exceptions.NumericOverflowException;
import com.cloudera.sqlengine.aeprocessor.aeoptimizer.AEFilterOptimizer;
import com.cloudera.sqlengine.aeprocessor.aeoptimizer.IAEOptimizer;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.cloudera.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.cloudera.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.sqlengine.dsiext.dataengine.SqlQueryExecutorContext;
import com.cloudera.sqlengine.utilities.AEStringLogger;
import com.cloudera.support.SettingReader;
import com.cloudera.support.exceptions.ErrorException;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;

public class AETreeOptimizer
implements IAEOptimizer {
    private SqlQueryExecutorContext m_executorContext;
    private SqlDataEngineContext m_dataEngineContext;
    private SqlDataEngine m_dataEngine;

    public AETreeOptimizer(SqlQueryExecutorContext sqlQueryExecutorContext) {
        this.m_executorContext = sqlQueryExecutorContext;
        this.m_dataEngineContext = sqlQueryExecutorContext.getDataEngineContext();
        this.m_dataEngine = this.m_dataEngineContext.getDataEngine();
    }

    public void optimize(IAEStatement iAEStatement) throws ErrorException {
        if (null == iAEStatement) {
            throw new NullPointerException("statement cannot be null");
        }
        if (this.m_dataEngine.getProperty(3).getString().equals("Y")) {
            String string;
            try {
                if (0L != (this.m_dataEngine.getProperty(4).getLong() & 2L)) {
                    string = SettingReader.readSetting("LogPath");
                    AEStringLogger.logAETree(iAEStatement, new File(string, "AETree.log").getPath(), new Timestamp(System.currentTimeMillis()).toString() + " :: Post-ReOrder ==========================================================");
                }
            }
            catch (IOException iOException) {
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new AssertionError((Object)incorrectTypeException);
            }
            catch (NumericOverflowException numericOverflowException) {
                throw new AssertionError((Object)numericOverflowException);
            }
            new AEFilterOptimizer(this.m_dataEngineContext, this.m_executorContext.getPassdownInformation()).optimize(iAEStatement);
            try {
                if (0L != (this.m_dataEngine.getProperty(4).getLong() & 4L)) {
                    string = SettingReader.readSetting("LogPath");
                    AEStringLogger.logAETree(iAEStatement, new File(string, "AETree.log").getPath(), new Timestamp(System.currentTimeMillis()).toString() + " :: Post-Optimize ==========================================================");
                }
            }
            catch (IOException iOException) {
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new AssertionError((Object)incorrectTypeException);
            }
            catch (NumericOverflowException numericOverflowException) {
                throw new AssertionError((Object)numericOverflowException);
            }
        }
    }
}

