/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.jdbc.common4;

import com.cloudera.dsi.core.utilities.PropertyUtilities;
import com.cloudera.dsi.dataengine.utilities.MetadataSourceID;
import com.cloudera.exceptions.ExceptionConverter;
import com.cloudera.jdbc.common.SConnection;
import com.cloudera.jdbc.common.SDatabaseMetaData;
import com.cloudera.jdbc.common4.utilities.WrapperUtilities;
import com.cloudera.support.ILogger;
import com.cloudera.support.LogUtilities;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;

public abstract class C4SDatabaseMetaData
extends SDatabaseMetaData {
    private static final int JDBC_MAJOR_VERSION = 4;

    public C4SDatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        super(sConnection, iLogger);
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(37);
            return 1L == (long)n || 0L == (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3, string4);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            return this.createMetaDataResult(MetadataSourceID.FUNCTION_COLUMNS_JDBC4, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            return this.createMetaDataResult(MetadataSourceID.FUNCTIONS_JDBC4, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return 4;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return PropertyUtilities.hasStoredFunctionsCallsSupport(this.m_parentConnection.getConnection());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }
}

