/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.jdbc.common;

import com.cloudera.dsi.core.impl.DSIDriverFactory;
import com.cloudera.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.dsi.core.interfaces.IConnection;
import com.cloudera.dsi.core.interfaces.IDriver;
import com.cloudera.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.dsi.core.utilities.Variant;
import com.cloudera.exceptions.ExceptionConverter;
import com.cloudera.exceptions.JDBCMessageKey;
import com.cloudera.jdbc.common.BaseConnectionFactory;
import com.cloudera.jdbc.common.JDBCObjectFactory;
import com.cloudera.jdbc.common.SConnection;
import com.cloudera.jdbc.common.SWarningListener;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.LogLevel;
import com.cloudera.support.Pair;
import com.cloudera.support.exceptions.ExceptionType;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public abstract class AbstractDataSource
extends BaseConnectionFactory
implements DataSource,
ConnectionPoolDataSource {
    private static boolean s_isInitialized = false;
    private String m_url = null;
    private String m_password = null;
    private String m_userID = null;
    private LogLevel m_logLevel = LogLevel.OFF;
    private String m_logDirectory = "";
    private Map<String, String> m_customProperties = new HashMap<String, String>();

    public static void initialize(String string) {
        DSIDriverFactory.setDriverClassName(string);
        s_isInitialized = true;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getSimbaConnection();
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        this.m_userID = string;
        this.m_password = string2;
        return this.getConnection();
    }

    public String getCustomProperty(String string) {
        return this.m_customProperties.get(string);
    }

    public String getLogDirectory() {
        return this.m_logDirectory;
    }

    @Override
    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    public LogLevel getLogLevel() {
        return this.m_logLevel;
    }

    @Override
    public PrintWriter getLogWriter() {
        return DriverManager.getLogWriter();
    }

    public String getPassword() {
        return this.m_password;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        SConnection sConnection = this.getSimbaConnection();
        if (null != sConnection) {
            return JDBCObjectFactory.getInstance().createPooledConnection(sConnection);
        }
        SWarningListener sWarningListener = new SWarningListener(DSIDriverSingleton.getInstance().getMessageSource(), null);
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_REFUSED, (IWarningListener)sWarningListener, ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
    }

    @Override
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        this.m_userID = string;
        this.m_password = string2;
        return this.getPooledConnection();
    }

    public String getUserID() {
        return this.m_userID;
    }

    public void removeCustomProperty(String string) {
        this.m_customProperties.remove(string);
    }

    public void setCustomProperty(String string, String string2) {
        this.m_customProperties.put(string, string2);
    }

    public void setLogDirectory(String string) {
        this.m_logDirectory = string;
    }

    @Override
    public void setLoginTimeout(int n) {
        DriverManager.setLoginTimeout(n);
    }

    public void setLogLevel(String string) {
        this.m_logLevel = LogLevel.getLogLevel(string);
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        DriverManager.setLogWriter(printWriter);
    }

    public void setPassword(String string) {
        this.m_password = string;
    }

    public void setURL(String string) {
        this.m_url = string;
    }

    public void setUserID(String string) {
        this.m_userID = string;
    }

    protected Properties getProperties() {
        Properties properties = new Properties();
        String string = "USER";
        String string2 = "PASSWORD";
        IDriver iDriver = DSIDriverSingleton.getInstance();
        assert (null != iDriver);
        try {
            Variant variant = iDriver.getProperty(1000);
            if (1 == variant.getShort()) {
                string = "UID";
                string2 = "PWD";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != this.m_userID) {
            properties.put(string, this.m_userID);
        } else {
            properties.put(string, "");
        }
        if (null != this.m_password) {
            properties.put(string2, this.m_password);
        } else {
            properties.put(string2, "");
        }
        if (null != this.m_logLevel) {
            properties.put("LogLevel", this.m_logLevel.name());
        }
        if (null != this.m_logDirectory) {
            properties.put("LogPath", this.m_logDirectory);
        }
        properties.putAll(this.m_customProperties);
        return properties;
    }

    @Override
    protected abstract String getSubProtocol();

    private void doInitialize() throws SQLException {
        if (!s_isInitialized) {
            ExceptionConverter.getInstance().toSQLException("HY000", "Class has not been initialized. Please initialize by calling AbstractDriver.initialize()", 0, ExceptionType.DEFAULT);
        } else if (null == DSIDriverSingleton.getInstance()) {
            try {
                DSIDriverSingleton.setInstance(DSIDriverFactory.createDriver());
            }
            catch (Exception exception) {
                SQLException sQLException = new SQLException(exception.getLocalizedMessage());
                sQLException.initCause(exception);
                throw sQLException;
            }
        }
    }

    private SConnection getSimbaConnection() throws SQLException {
        this.doInitialize();
        Properties properties = this.getProperties();
        if (!this.acceptsURL(this.getURL(), properties)) {
            return null;
        }
        Pair<IConnection, ConnSettingRequestMap> pair = this.getConnection(properties);
        return this.doConnect(pair, this.getURL());
    }

    private String getURL() throws SQLException {
        if (null != this.m_url) {
            return this.m_url;
        }
        StringBuffer stringBuffer = new StringBuffer("jdbc");
        stringBuffer.append(":").append(this.getSubProtocol());
        return stringBuffer.toString();
    }
}

