/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.dataengine;

import com.cloudera.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.sqlengine.aeprocessor.AEUtils;
import com.cloudera.sqlengine.aeprocessor.metadatautil.MetadataUtilities;
import com.cloudera.sqlengine.dsiext.dataengine.IColumnInfo;
import com.cloudera.sqlengine.dsiext.dataengine.IScalarFnMetadataHandler;
import com.cloudera.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.sqlengine.dsiext.dataengine.SqlScalarFnMetadataHandler;
import com.cloudera.sqlengine.dsiext.dataengine.utils.ScalarFunctionArgType;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ImpalaScalarFnMetadataHandler
extends SqlScalarFnMetadataHandler {
    @Override
    protected IScalarFnMetadataHandler.ScalarFnMetadata createCustomMetadata(SqlDataEngineContext sqlDataEngineContext, String string, List<? extends IColumnInfo> list) throws ErrorException {
        IScalarFnMetadataHandler.ScalarFnMetadata scalarFnMetadata;
        ImpalaFnID impalaFnID;
        try {
            impalaFnID = ImpalaFnID.valueOf(string.toLowerCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        switch (impalaFnID) {
            case appx_median: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createAppxMedianMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case group_concat: {
                if (1 != list.size() && 2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createGroupConcatMetadata(sqlDataEngineContext, list);
                break;
            }
            case ndv: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createNDVMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case variance: 
            case variance_samp: 
            case variance_pop: 
            case var_samp: 
            case stddev_samp: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createVarianceMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case typeof: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createTypeOfMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case bitand: 
            case bitor: 
            case bitxor: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createBitOpMetadata(sqlDataEngineContext, list.get(0), list.get(1), string);
                break;
            }
            case bitnot: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createBitNotMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case countset: {
                if (1 != list.size() && 2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCountSetMetadata(sqlDataEngineContext, list);
                break;
            }
            case getbit: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createGetBitMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case rotateleft: 
            case rotateright: 
            case shiftleft: 
            case shiftright: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRotateShiftMetadata(sqlDataEngineContext, list.get(0), list.get(1), string);
                break;
            }
            case setbit: {
                if (2 != list.size() && 3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSetBitMetadata(sqlDataEngineContext, list);
                break;
            }
            case decode: {
                if (3 > list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDecodeMetadata(sqlDataEngineContext, list);
                break;
            }
            case isnull: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createIfNullMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case isfalse: 
            case isnotfalse: 
            case istrue: 
            case isnottrue: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createIsBooleanMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case nonnullvalue: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createNonNullValueMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case nullifzero: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createNullIfZeroMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case nullvalue: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createNullValueMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case nvl: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createIfNullMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case zeroifnull: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createZeroIfNullMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case btrim: {
                if (1 != list.size() && 2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createBTrimMetadata(sqlDataEngineContext, list);
                break;
            }
            case character_length: 
            case char_length: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLengthMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case chr: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createChrMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case concat_ws: {
                if (3 > list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createConcatWSMetadata(sqlDataEngineContext, list);
                break;
            }
            case find_in_set: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createFindInSetMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case initcap: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createInitCapMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case instr: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createInStrMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case lpad: 
            case rpad: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createPadMetadata(sqlDataEngineContext, list.get(0), list.get(1), list.get(2));
                break;
            }
            case parse_url: {
                if (2 != list.size() && 3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createParseUrlMetadata(sqlDataEngineContext, list);
                break;
            }
            case regexp_extract: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRegExpExtractMetadata(sqlDataEngineContext, list.get(0), list.get(1), list.get(2));
                break;
            }
            case regexp_like: {
                if (2 != list.size() && 3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRegExpLikeMetadata(sqlDataEngineContext, list);
                break;
            }
            case regexp_replace: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createReplaceMetadata(sqlDataEngineContext, list.get(0), list.get(1), list.get(2));
                break;
            }
            case reverse: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createReverseMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case split_part: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSplitPartMetadata(sqlDataEngineContext, list.get(0), list.get(1), list.get(2));
                break;
            }
            case strleft: 
            case strright: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createStrShiftMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case substr: {
                if (2 == list.size()) {
                    scalarFnMetadata = this.createSubstringMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                    break;
                }
                if (3 == list.size()) {
                    scalarFnMetadata = this.createSubstringMetadata(sqlDataEngineContext, list.get(0), list.get(1), list.get(2));
                    break;
                }
                throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
            }
            case translate: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createTranslateMetadata(sqlDataEngineContext, list.get(0), list.get(1), list.get(2));
                break;
            }
            case trim: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLTrimMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case bin: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createBinMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case ceil: 
            case dceil: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCeilMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case conv: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createConvMetadata(sqlDataEngineContext, list.get(0), list.get(1), list.get(2));
                break;
            }
            case cosh: 
            case sinh: 
            case tanh: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCoshMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case e: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createEMetadata(sqlDataEngineContext);
                break;
            }
            case dexp: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createExpMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case factorial: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createFactorialMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case dfloor: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createFloorMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case fmod: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createModMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case fnv_hash: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createFnvHashMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case greatest: 
            case least: {
                if (list.size() < 1) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createGreatestMetadata(sqlDataEngineContext, list);
                break;
            }
            case hex: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createHexMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case is_inf: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createIsInfMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case is_nan: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createIsNaNMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case ln: 
            case dlog1: 
            case log2: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLogBaseMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case max_int: 
            case min_int: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMaxMinIntMetadata(sqlDataEngineContext);
                break;
            }
            case max_tinyint: 
            case min_tinyint: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMaxMinTinyIntMetadata(sqlDataEngineContext);
                break;
            }
            case max_smallint: 
            case min_smallint: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMaxMinSmallIntMetadata(sqlDataEngineContext);
                break;
            }
            case max_bigint: 
            case min_bigint: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMaxMinBigIntMetadata(sqlDataEngineContext);
                break;
            }
            case negative: 
            case positive: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createNegativeMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case pmod: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createModMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case pow: 
            case dpow: 
            case fpow: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createPowerMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case precision: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createPrecisionMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case quotient: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createQuotientMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case random: {
                if (0 == list.size()) {
                    scalarFnMetadata = this.createRandMetadata(sqlDataEngineContext);
                    break;
                }
                if (1 == list.size()) {
                    scalarFnMetadata = this.createRandMetadata(sqlDataEngineContext, list.get(0));
                    break;
                }
                throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
            }
            case dround: {
                if (1 == list.size()) {
                    scalarFnMetadata = this.createRoundMetadata(sqlDataEngineContext, list.get(0));
                    break;
                }
                if (2 == list.size()) {
                    scalarFnMetadata = this.createRoundMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                    break;
                }
                throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
            }
            case scale: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createScaleMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case dsqrt: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSqrtMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case unhex: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createUnhexMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case add_months: 
            case adddate: 
            case date_add: 
            case date_sub: 
            case days_add: 
            case days_sub: 
            case hours_add: 
            case hours_sub: 
            case microseconds_add: 
            case microseconds_sub: 
            case milliseconds_add: 
            case milliseconds_sub: 
            case minutes_add: 
            case minutes_sub: 
            case months_add: 
            case months_sub: 
            case nanoseconds_add: 
            case nanoseconds_sub: 
            case seconds_add: 
            case seconds_sub: 
            case subdate: 
            case weeks_add: 
            case weeks_sub: 
            case years_add: 
            case years_sub: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createAlterDateMetadata(sqlDataEngineContext, string, list.get(0), list.get(1));
                break;
            }
            case date_part: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDatePartMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case datediff: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDateDiffMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case day: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDayOfMonthMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case extract: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createExtractMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case from_unixtime: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createFromUnixTimeMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case from_utc_timestamp: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createFromUTCTimestampMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case int_months_between: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createIntMonthsBetweenMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case millisecond: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMillisecondMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case months_between: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMonthsBetweenMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case timeofday: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createTimeOfDayMetadata(sqlDataEngineContext);
                break;
            }
            case timestamp_cmp: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createTimestampCmpMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case to_date: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createToDateMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case to_utc_timestamp: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createToUTCTimestampMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case trunc: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createTruncMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case unix_timestamp: {
                if (0 < list.size() && list.size() > 2) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createUnixTimestampMetadata(sqlDataEngineContext, list);
                break;
            }
            case weekofyear: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createWeekOfYearMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            default: {
                scalarFnMetadata = null;
            }
        }
        return scalarFnMetadata;
    }

    @Override
    protected void validateCustomMetadata(SqlDataEngineContext sqlDataEngineContext, String string, List<? extends IColumnInfo> list) throws ErrorException {
        ImpalaFnID impalaFnID = ImpalaFnID.valueOf(string.toLowerCase());
        int n = 0;
        if (null == impalaFnID.getFunctions()) {
            n = this.validateArguments(sqlDataEngineContext, string, impalaFnID, impalaFnID.getArguments(), list);
            if (-1 == n) {
                throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
            }
            if (0 != n) {
                throw SQLEngineExceptionFactory.invalidScalarFnArgumentTypeException(string, n, list.get(n - 1).getType());
            }
        } else {
            for (int i = 0; i < impalaFnID.getFunctions().size(); ++i) {
                ImpalaFnID impalaFnID2 = impalaFnID.getFunctions().get(i);
                n = this.validateArguments(sqlDataEngineContext, impalaFnID2.name(), impalaFnID2, impalaFnID2.getArguments(), list);
                if (0 != n) continue;
                return;
            }
            if (-1 == n) {
                throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
            }
            if (0 != n) {
                throw SQLEngineExceptionFactory.invalidScalarFnArgumentTypeException(string, n, list.get(n - 1).getType());
            }
        }
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createAppxMedianMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws NullPointerException, ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(MetadataUtilities.createTypeMetadata(iColumnInfo)), Arrays.asList(MetadataUtilities.createTypeMetadata(iColumnInfo)));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createGroupConcatMetadata(SqlDataEngineContext sqlDataEngineContext, List<? extends IColumnInfo> list) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createStringMetadata());
        if (2 == list.size()) {
            arrayList.add(this.createStringMetadata());
        }
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createNDVMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws NullPointerException, ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(MetadataUtilities.createTypeMetadata(iColumnInfo)));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createVarianceMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(MetadataUtilities.createTypeMetadata(iColumnInfo)));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createTypeOfMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws NullPointerException, ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), Arrays.asList(MetadataUtilities.createTypeMetadata(iColumnInfo)));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createBitNotMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        if (TypeUtilities.isIntegerType(iColumnInfo.getType())) {
            return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createNumericMetadata(iColumnInfo)), Arrays.asList(this.createNumericMetadata(iColumnInfo)));
        }
        throw SQLEngineExceptionFactory.invalidScalarFnArgumentTypeException("bitnot", 1, iColumnInfo.getType());
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createBitOpMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, String string) throws ErrorException {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        if (!TypeUtilities.isIntegerType(iColumnInfo.getType())) {
            throw SQLEngineExceptionFactory.invalidScalarFnArgumentTypeException(string, 1, iColumnInfo.getType());
        }
        arrayList.add(MetadataUtilities.createTypeMetadata(iColumnInfo));
        arrayList.add(MetadataUtilities.createTypeMetadata(iColumnInfo2));
        return new IScalarFnMetadataHandler.ScalarFnMetadata(MetadataUtilities.createColumnMetadata(iColumnInfo), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createCountSetMetadata(SqlDataEngineContext sqlDataEngineContext, List<? extends IColumnInfo> list) throws ErrorException {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        if (!TypeUtilities.isIntegerType(list.get(0).getType())) {
            throw SQLEngineExceptionFactory.invalidScalarFnArgumentTypeException("countset", 1, list.get(0).getType());
        }
        arrayList.add(this.createNumericMetadata(list.get(0)));
        if (2 == list.size()) {
            arrayList.add(this.createIntMetadata());
        }
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createNumericMetadata(list.get(0))), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createGetBitMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        if (!TypeUtilities.isIntegerType(iColumnInfo.getType())) {
            throw SQLEngineExceptionFactory.invalidScalarFnArgumentTypeException("getbit", 1, iColumnInfo.getType());
        }
        arrayList.add(this.createNumericMetadata(iColumnInfo));
        arrayList.add(this.createIntMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createNumericMetadata(iColumnInfo)), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createRotateShiftMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, String string) throws ErrorException {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        if (!TypeUtilities.isIntegerType(iColumnInfo.getType())) {
            throw SQLEngineExceptionFactory.invalidScalarFnArgumentTypeException(string, 1, iColumnInfo.getType());
        }
        arrayList.add(this.createNumericMetadata(iColumnInfo));
        arrayList.add(this.createIntMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createNumericMetadata(iColumnInfo)), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createSetBitMetadata(SqlDataEngineContext sqlDataEngineContext, List<? extends IColumnInfo> list) throws ErrorException {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        if (!TypeUtilities.isIntegerType(list.get(0).getType())) {
            throw SQLEngineExceptionFactory.invalidScalarFnArgumentTypeException("setbit", 1, list.get(0).getType());
        }
        arrayList.add(this.createNumericMetadata(list.get(0)));
        arrayList.add(this.createIntMetadata());
        if (3 == list.size()) {
            arrayList.add(this.createIntMetadata());
        }
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createNumericMetadata(list.get(0))), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createDecodeMetadata(SqlDataEngineContext sqlDataEngineContext, List<? extends IColumnInfo> list) throws ErrorException {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        for (IColumnInfo iColumnInfo : list) {
            arrayList.add(MetadataUtilities.createTypeMetadata(iColumnInfo));
        }
        ColumnMetadata columnMetadata = TypeUtilities.isIntegerType(list.get(0).getType()) ? new ColumnMetadata(this.createBigIntMetadata()) : new ColumnMetadata(MetadataUtilities.createTypeMetadata(list.get(0)));
        return new IScalarFnMetadataHandler.ScalarFnMetadata(columnMetadata, arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createIsBooleanMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(16);
        TypeMetadata typeMetadata2 = TypeMetadata.createTypeMetadata(16);
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(typeMetadata2), Arrays.asList(typeMetadata));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createNonNullValueMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        TypeMetadata typeMetadata = MetadataUtilities.createTypeMetadata(iColumnInfo);
        TypeMetadata typeMetadata2 = TypeMetadata.createTypeMetadata(16);
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(typeMetadata2), Arrays.asList(typeMetadata));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createNullIfZeroMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        ColumnMetadata columnMetadata = TypeUtilities.isIntegerType(iColumnInfo.getType()) ? new ColumnMetadata(this.createBigIntMetadata()) : new ColumnMetadata(this.createDoubleMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(columnMetadata, Arrays.asList(this.createNumericMetadata(iColumnInfo)));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createNullValueMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        TypeMetadata typeMetadata = MetadataUtilities.createTypeMetadata(iColumnInfo);
        TypeMetadata typeMetadata2 = TypeMetadata.createTypeMetadata(16);
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(typeMetadata2), Arrays.asList(typeMetadata));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createZeroIfNullMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        ColumnMetadata columnMetadata = TypeUtilities.isIntegerType(iColumnInfo.getType()) ? new ColumnMetadata(this.createBigIntMetadata()) : new ColumnMetadata(this.createDoubleMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(columnMetadata, Arrays.asList(this.createNumericMetadata(iColumnInfo)));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createBTrimMetadata(SqlDataEngineContext sqlDataEngineContext, List<? extends IColumnInfo> list) {
        if (1 == list.size()) {
            return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), Arrays.asList(this.createStringMetadata()));
        }
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createChrMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), Arrays.asList(this.createIntMetadata()));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createConcatWSMetadata(SqlDataEngineContext sqlDataEngineContext, List<? extends IColumnInfo> list) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        for (IColumnInfo iColumnInfo : list) {
            arrayList.add(this.createStringMetadata());
        }
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createFindInSetMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createInitCapMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), Arrays.asList(this.createStringMetadata()));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createInStrMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createPadMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createIntMetadata());
        arrayList.add(this.createStringMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createParseUrlMetadata(SqlDataEngineContext sqlDataEngineContext, List<? extends IColumnInfo> list) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        if (3 == list.size()) {
            arrayList.add(this.createStringMetadata());
        }
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createRegExpExtractMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createIntMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createRegExpLikeMetadata(SqlDataEngineContext sqlDataEngineContext, List<? extends IColumnInfo> list) throws ErrorException {
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(16);
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        if (3 == list.size()) {
            arrayList.add(this.createStringMetadata());
        }
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(typeMetadata), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createBinMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createBigIntMetadata()), Arrays.asList(this.createStringMetadata()));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createReverseMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), Arrays.asList(this.createStringMetadata()));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createSplitPartMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createBigIntMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createStrShiftMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createIntMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createTranslateMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createCeilMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createBigIntMetadata()));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createConvMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3) throws ErrorException {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        if (TypeUtilities.isCharacterType(iColumnInfo.getType())) {
            arrayList.add(this.createStringMetadata());
        } else if (TypeUtilities.isNumberType(iColumnInfo.getType())) {
            arrayList.add(this.createBigIntMetadata());
        } else {
            throw SQLEngineExceptionFactory.invalidScalarFnArgumentTypeException("conv", 1, iColumnInfo.getType());
        }
        arrayList.add(this.createIntMetadata());
        arrayList.add(this.createIntMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createCoshMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata()));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createEMetadata(SqlDataEngineContext sqlDataEngineContext) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Collections.emptyList());
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createFnvHashMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createBigIntMetadata()), Arrays.asList(MetadataUtilities.createTypeMetadata(iColumnInfo)));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createFactorialMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createBigIntMetadata()), Arrays.asList(this.createNumericMetadata(iColumnInfo)));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createGreatestMetadata(SqlDataEngineContext sqlDataEngineContext, List<? extends IColumnInfo> list) throws ErrorException {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        for (IColumnInfo iColumnInfo : list) {
            arrayList.add(MetadataUtilities.createTypeMetadata(iColumnInfo));
        }
        ColumnMetadata columnMetadata = TypeUtilities.isIntegerType(list.get(0).getType()) ? new ColumnMetadata(this.createBigIntMetadata()) : new ColumnMetadata(MetadataUtilities.createTypeMetadata(list.get(0)));
        return new IScalarFnMetadataHandler.ScalarFnMetadata(columnMetadata, arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createHexMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        TypeMetadata typeMetadata;
        if (TypeUtilities.isIntegerType(iColumnInfo.getType())) {
            typeMetadata = this.createBigIntMetadata();
        } else if (TypeUtilities.isCharacterType(iColumnInfo.getType())) {
            typeMetadata = this.createStringMetadata();
        } else {
            throw SQLEngineExceptionFactory.invalidScalarFnArgumentTypeException("hex", 1, iColumnInfo.getType());
        }
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), Arrays.asList(typeMetadata));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createIsInfMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(16);
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(typeMetadata), Arrays.asList(this.createDoubleMetadata()));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createIsNaNMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(16);
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(typeMetadata), Arrays.asList(this.createDoubleMetadata()));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createLogBaseMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), Arrays.asList(this.createDoubleMetadata()));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createMaxMinBigIntMetadata(SqlDataEngineContext sqlDataEngineContext) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createBigIntMetadata()), Collections.emptyList());
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createMaxMinIntMetadata(SqlDataEngineContext sqlDataEngineContext) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Collections.emptyList());
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createMaxMinSmallIntMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(TypeMetadata.createTypeMetadata(5)), Collections.emptyList());
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createMaxMinTinyIntMetadata(SqlDataEngineContext sqlDataEngineContext) throws NullPointerException, ErrorException {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(TypeMetadata.createTypeMetadata(-6)), Collections.emptyList());
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createNegativeMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createNumericMetadata(iColumnInfo)), Arrays.asList(this.createNumericMetadata(iColumnInfo)));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createPrecisionMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), Arrays.asList(this.createNumericMetadata(iColumnInfo)));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createQuotientMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        if (TypeUtilities.isIntegerType(iColumnInfo.getType())) {
            arrayList.add(this.createBigIntMetadata());
            arrayList.add(this.createBigIntMetadata());
        } else if (AEUtils.isTypeNumeric(iColumnInfo.getType())) {
            arrayList.add(this.createDoubleMetadata());
            arrayList.add(this.createDoubleMetadata());
        } else {
            throw SQLEngineExceptionFactory.invalidScalarFnArgumentTypeException("quotient", 1, iColumnInfo.getType());
        }
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createBigIntMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createScaleMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createNumericMetadata(iColumnInfo)), Arrays.asList(this.createIntMetadata()));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createRoundMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createBigIntMetadata()), Arrays.asList(this.createDoubleMetadata()));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createUnhexMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), Arrays.asList(this.createStringMetadata()));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createAlterDateMetadata(SqlDataEngineContext sqlDataEngineContext, String string, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createNumericMetadata(iColumnInfo2));
        arrayList.add(this.createIntMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createTimestampMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createDateDiffMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createTimestampMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createDatePartMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createTimestampMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createExtractMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createStringMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createFromUnixTimeMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createBigIntMetadata());
        arrayList.add(this.createStringMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createFromUTCTimestampMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createStringMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createTimestampMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createIntMonthsBetweenMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createTimestampMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createMillisecondMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createTimestampMetadata()), Arrays.asList(this.createIntMetadata()));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createMonthsBetweenMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createTimestampMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createDoubleMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createTimeOfDayMetadata(SqlDataEngineContext sqlDataEngineContext) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createStringMetadata()), Collections.emptyList());
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createTimestampCmpMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createTimestampMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createIntMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createToDateMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createTimestampMetadata()), Arrays.asList(this.createStringMetadata()));
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createToUTCTimestampMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createStringMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createTimestampMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createTruncMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) {
        ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createStringMetadata());
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createTimestampMetadata()), arrayList);
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createUnixTimestampMetadata(SqlDataEngineContext sqlDataEngineContext, List<? extends IColumnInfo> list) throws ErrorException {
        if (0 == list.size()) {
            return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createBigIntMetadata()), Collections.emptyList());
        }
        if (1 == list.size()) {
            if (TypeUtilities.isTimeType(list.get(0).getType())) {
                return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createBigIntMetadata()), Arrays.asList(this.createTimestampMetadata()));
            }
            if (TypeUtilities.isCharacterType(list.get(0).getType())) {
                return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createBigIntMetadata()), Arrays.asList(this.createStringMetadata()));
            }
            throw SQLEngineExceptionFactory.invalidScalarFnArgumentTypeException("unix_timestamp", 1, list.get(0).getType());
        }
        if (2 == list.size()) {
            ArrayList<TypeMetadata> arrayList = new ArrayList<TypeMetadata>();
            arrayList.add(this.createStringMetadata());
            arrayList.add(this.createStringMetadata());
            return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createBigIntMetadata()), arrayList);
        }
        return null;
    }

    private IScalarFnMetadataHandler.ScalarFnMetadata createWeekOfYearMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) {
        return new IScalarFnMetadataHandler.ScalarFnMetadata(new ColumnMetadata(this.createTimestampMetadata()), Arrays.asList(this.createIntMetadata()));
    }

    private int validateArguments(SqlDataEngineContext sqlDataEngineContext, String string, ImpalaFnID impalaFnID, List<ScalarFunctionArgType> list, List<? extends IColumnInfo> list2) throws ErrorException {
        if (impalaFnID.getSizeLimits()) {
            if (list.size() != list2.size()) {
                return -1;
            }
            return this.validateArgumentTypes(sqlDataEngineContext, list, list2);
        }
        return this.validateArgumentTypes(sqlDataEngineContext, list.get(0), list2);
    }

    private int validateArgumentTypes(SqlDataEngineContext sqlDataEngineContext, ScalarFunctionArgType scalarFunctionArgType, List<? extends IColumnInfo> list) throws ErrorException {
        for (int i = 0; i < list.size(); ++i) {
            int n = this.validateTypeMetadata(sqlDataEngineContext, i + 1, scalarFunctionArgType, list.get(i));
            if (0 == n) continue;
            return n;
        }
        return 0;
    }

    private int validateArgumentTypes(SqlDataEngineContext sqlDataEngineContext, List<ScalarFunctionArgType> list, List<? extends IColumnInfo> list2) throws ErrorException {
        for (int i = 0; i < list.size(); ++i) {
            int n = this.validateTypeMetadata(sqlDataEngineContext, i + 1, list.get(i), list2.get(i));
            if (0 == n) continue;
            return n;
        }
        return 0;
    }

    private int validateTypeMetadata(SqlDataEngineContext sqlDataEngineContext, int n, ScalarFunctionArgType scalarFunctionArgType, IColumnInfo iColumnInfo) throws ErrorException {
        if (!this.isValidTypeMetadata(sqlDataEngineContext, scalarFunctionArgType, iColumnInfo.getType())) {
            return n;
        }
        return 0;
    }

    private static enum ImpalaFnID {
        add_months(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        adddate(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        date_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        date_part(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        date_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        datediff(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        day(ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        days_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        days_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        extract(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_STRING),
        from_unixtime(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_STRING),
        from_utc_timestamp(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_STRING),
        hours_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        hours_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        int_months_between(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        microseconds_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        microseconds_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        millisecond(ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        milliseconds_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        milliseconds_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        minutes_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        minutes_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        months_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        months_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        months_between(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        nanoseconds_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        nanoseconds_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        seconds_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        seconds_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        subdate(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        timeofday,
        timestamp_cmp(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        to_date(ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        to_utc_timestamp(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_STRING),
        trunc(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_STRING),
        unix_timestamp0,
        unix_timestamp1str(ScalarFunctionArgType.FN_ARG_STRING),
        unix_timestamp1time(ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        unix_timestamp2(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        unix_timestamp(unix_timestamp0, unix_timestamp1str, unix_timestamp1time, unix_timestamp2),
        weekofyear(ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        weeks_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        weeks_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        years_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        years_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        bin(ScalarFunctionArgType.FN_ARG_INTEGER),
        ceil(ScalarFunctionArgType.FN_ARG_NUMERIC),
        dceil(ScalarFunctionArgType.FN_ARG_NUMERIC),
        convstr(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        convbigint(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        conv(convbigint, convstr),
        cosh(ScalarFunctionArgType.FN_ARG_NUMERIC),
        e,
        dexp(ScalarFunctionArgType.FN_ARG_NUMERIC),
        factorial(ScalarFunctionArgType.FN_ARG_INTEGER),
        dfloor(ScalarFunctionArgType.FN_ARG_NUMERIC),
        fmod(ScalarFunctionArgType.FN_ARG_NUMERIC, ScalarFunctionArgType.FN_ARG_NUMERIC),
        fnv_hash(ScalarFunctionArgType.FN_ARG_ANY),
        greatest(ScalarFunctionArgType.FN_ARG_ANY, false),
        hexstr(ScalarFunctionArgType.FN_ARG_STRING),
        hexbigint(ScalarFunctionArgType.FN_ARG_INTEGER),
        hex(hexstr, hexbigint),
        is_inf(ScalarFunctionArgType.FN_ARG_NUMERIC),
        is_nan(ScalarFunctionArgType.FN_ARG_NUMERIC),
        least(ScalarFunctionArgType.FN_ARG_ANY, false),
        ln(ScalarFunctionArgType.FN_ARG_NUMERIC),
        dlog1(ScalarFunctionArgType.FN_ARG_NUMERIC),
        log2(ScalarFunctionArgType.FN_ARG_NUMERIC),
        max_int,
        max_tinyint,
        max_bigint,
        max_smallint,
        min_bigint,
        min_int,
        min_tinyint,
        min_smallint,
        negative(ScalarFunctionArgType.FN_ARG_NUMERIC),
        pmod(ScalarFunctionArgType.FN_ARG_SLC, ScalarFunctionArgType.FN_ARG_SLC),
        positive(ScalarFunctionArgType.FN_ARG_NUMERIC),
        pow(ScalarFunctionArgType.FN_ARG_NUMERIC, ScalarFunctionArgType.FN_ARG_NUMERIC),
        dpow(ScalarFunctionArgType.FN_ARG_NUMERIC, ScalarFunctionArgType.FN_ARG_NUMERIC),
        fpow(ScalarFunctionArgType.FN_ARG_NUMERIC, ScalarFunctionArgType.FN_ARG_NUMERIC),
        precision(ScalarFunctionArgType.FN_ARG_NUMERIC),
        quotient(ScalarFunctionArgType.FN_ARG_SLC, ScalarFunctionArgType.FN_ARG_SLC),
        random0,
        random1(ScalarFunctionArgType.FN_ARG_INTEGER),
        random(random0, random1),
        dround1(ScalarFunctionArgType.FN_ARG_NUMERIC),
        dround2(ScalarFunctionArgType.FN_ARG_NUMERIC, ScalarFunctionArgType.FN_ARG_INTEGER),
        dround(dround1, dround2),
        scale(ScalarFunctionArgType.FN_ARG_NUMERIC),
        sinh(ScalarFunctionArgType.FN_ARG_NUMERIC),
        dsqrt(ScalarFunctionArgType.FN_ARG_NUMERIC),
        tanh(ScalarFunctionArgType.FN_ARG_NUMERIC),
        unhex(ScalarFunctionArgType.FN_ARG_STRING),
        btrim1(ScalarFunctionArgType.FN_ARG_STRING),
        btrim2(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        btrim(btrim1, btrim2),
        char_length(ScalarFunctionArgType.FN_ARG_STRING),
        character_length(ScalarFunctionArgType.FN_ARG_STRING),
        chr(ScalarFunctionArgType.FN_ARG_INTEGER),
        concat_ws(ScalarFunctionArgType.FN_ARG_STRING, false),
        find_in_set(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        initcap(ScalarFunctionArgType.FN_ARG_STRING),
        instr(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        lpad(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_STRING),
        parse_url2(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        parse_url3(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        parse_url(parse_url2, parse_url3),
        regexp_extract(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER),
        regexp_like2(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        regexp_like3(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        regexp_like(regexp_like2, regexp_like3),
        regexp_replace(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        reverse(ScalarFunctionArgType.FN_ARG_STRING),
        rpad(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_STRING),
        split_part(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        substr2(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER),
        substr3(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        substr(substr2, substr3),
        strleft(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER),
        strright(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER),
        translate(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        trim(ScalarFunctionArgType.FN_ARG_STRING),
        decode(ScalarFunctionArgType.FN_ARG_ANY, false),
        isnull(ScalarFunctionArgType.FN_ARG_ANY, ScalarFunctionArgType.FN_ARG_ANY),
        isfalse(ScalarFunctionArgType.FN_ARG_ANY),
        isnotfalse(ScalarFunctionArgType.FN_ARG_ANY),
        istrue(ScalarFunctionArgType.FN_ARG_ANY),
        isnottrue(ScalarFunctionArgType.FN_ARG_ANY),
        nonnullvalue(ScalarFunctionArgType.FN_ARG_ANY),
        nullifzero(ScalarFunctionArgType.FN_ARG_NUMERIC),
        nullvalue(ScalarFunctionArgType.FN_ARG_ANY),
        nvl(ScalarFunctionArgType.FN_ARG_ANY, ScalarFunctionArgType.FN_ARG_ANY),
        zeroifnull(ScalarFunctionArgType.FN_ARG_NUMERIC),
        bitand(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        bitnot(ScalarFunctionArgType.FN_ARG_INTEGER),
        bitor(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        bitxor(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        countset2(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        countset1(ScalarFunctionArgType.FN_ARG_INTEGER),
        countset(countset1, countset2),
        getbit(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        rotateleft(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        rotateright(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        setbit2(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        setbit3(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        setbit(setbit2, setbit3),
        shiftleft(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        shiftright(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        typeof(ScalarFunctionArgType.FN_ARG_ANY),
        appx_median(ScalarFunctionArgType.FN_ARG_ANY),
        group_concat1(ScalarFunctionArgType.FN_ARG_STRING),
        group_concat2(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        group_concat(group_concat1, group_concat2),
        ndv(ScalarFunctionArgType.FN_ARG_ANY),
        variance(ScalarFunctionArgType.FN_ARG_SLC),
        variance_samp(ScalarFunctionArgType.FN_ARG_SLC),
        variance_pop(ScalarFunctionArgType.FN_ARG_SLC),
        var_samp(ScalarFunctionArgType.FN_ARG_SLC),
        stddev_samp(ScalarFunctionArgType.FN_ARG_SLC);

        private List<ScalarFunctionArgType> m_args;
        private List<ImpalaFnID> m_functions;
        private boolean m_limitSize = true;

        private ImpalaFnID() {
            this.m_args = Collections.unmodifiableList(Collections.emptyList());
        }

        private ImpalaFnID(ImpalaFnID ... impalaFnIDArray) {
            this.m_functions = Collections.unmodifiableList(Arrays.asList(impalaFnIDArray));
        }

        private ImpalaFnID(ScalarFunctionArgType ... scalarFunctionArgTypeArray) {
            this.m_args = Collections.unmodifiableList(Arrays.asList(scalarFunctionArgTypeArray));
        }

        private ImpalaFnID(ScalarFunctionArgType scalarFunctionArgType, boolean bl) {
            this.m_limitSize = bl;
            this.m_args = Collections.unmodifiableList(Arrays.asList(scalarFunctionArgType));
        }

        public List<ScalarFunctionArgType> getArguments() {
            return this.m_args;
        }

        public List<ImpalaFnID> getFunctions() {
            return this.m_functions;
        }

        public boolean getSizeLimits() {
            return this.m_limitSize;
        }
    }
}

