/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.schema.FirebirdTypeInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Table;

public class FirebirdAdapter
extends BaseDatastoreAdapter {
    public FirebirdAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("BooleanExpression");
        this.supportedOptions.remove("NullsInCandidateKeys");
        this.supportedOptions.remove("ColumnOptions_NullsKeyword");
        this.supportedOptions.remove("IncludeOrderByColumnsInSelect");
        this.supportedOptions.add("AlterTableDropForeignKey_Syntax");
        this.supportedOptions.add("CreateIndexesBeforeForeignKeys");
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.add("Sequences");
    }

    @Override
    public String getVendorID() {
        return "firebird";
    }

    @Override
    public String getDropTableStatement(Table table) {
        return "DROP TABLE " + table.toString();
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new FirebirdTypeInfo(rs);
    }

    @Override
    public String getSequenceCreateStmt(String sequence_name, Integer min, Integer max, Integer start, Integer increment, Integer cache_size) {
        if (sequence_name == null) {
            throw new NucleusUserException(LOCALISER.msg("051028"));
        }
        StringBuffer stmt = new StringBuffer("CREATE GENERATOR ");
        stmt.append(sequence_name);
        return stmt.toString();
    }

    @Override
    public String getSequenceNextStmt(String sequence_name) {
        if (sequence_name == null) {
            throw new NucleusUserException(LOCALISER.msg("051028"));
        }
        StringBuffer stmt = new StringBuffer("SELECT GEN_ID(");
        stmt.append(sequence_name);
        stmt.append(",1) FROM RDB$DATABASE");
        return stmt.toString();
    }
}

