/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.util.BitSet;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

public class BitSetStringConverter
implements TypeConverter<BitSet, String> {
    @Override
    public BitSet toMemberType(String str) {
        if (str == null) {
            return null;
        }
        BitSet set = new BitSet();
        StringTokenizer tokeniser = new StringTokenizer(str.substring(1, str.length() - 1), ",");
        while (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                int position = new Integer(token);
                set.set(position);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)BitSet.class.getName()), nfe);
            }
        }
        return set;
    }

    @Override
    public String toDatastoreType(BitSet set) {
        return set != null ? set.toString() : null;
    }
}

