/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.aeprocessor.metadatautil;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.dsi.dataengine.utilities.Nullable;
import com.cloudera.dsi.dataengine.utilities.Searchable;
import com.cloudera.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.dsi.dataengine.utilities.Updatable;
import com.cloudera.dsi.exceptions.NumericOverflowException;
import com.cloudera.sqlengine.aeprocessor.metadatautil.AECoercionProperties;
import com.cloudera.sqlengine.aeprocessor.metadatautil.AELiteralMetadataFactory;
import com.cloudera.sqlengine.aeprocessor.metadatautil.AEMetadataCoercer;
import com.cloudera.sqlengine.aeprocessor.metadatautil.AESqlTypeCoercer;
import com.cloudera.sqlengine.aeprocessor.metadatautil.AETypeNormalizer;
import com.cloudera.sqlengine.aeprocessor.metadatautil.MetadataColumnInfo;
import com.cloudera.sqlengine.aeprocessor.metadatautil.MetadataUtilities;
import com.cloudera.sqlengine.aeprocessor.metadatautil.SqlTypes;
import com.cloudera.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.cloudera.sqlengine.dsiext.dataengine.IColumnInfo;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.support.exceptions.ErrorException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AEMetadataCoercionHandler
implements ICoercionHandler {
    private final AECoercionProperties m_properties = new AECoercionProperties.Builder().build();
    private AETypeNormalizer m_typeNormalizer = new AETypeNormalizer(this.m_properties);
    private AESqlTypeCoercer m_typeCoercer = new AESqlTypeCoercer();
    private AEMetadataCoercer m_metadataCoercer = new AEMetadataCoercer(this.m_properties);
    private AELiteralMetadataFactory m_literalMetadataFactory = new AELiteralMetadataFactory(this.m_typeNormalizer, this.m_properties);

    @Override
    public IColumn coerceComparisonColumns(IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.generalizedCoercion(CoercionOperation.COMPARISON, iColumnInfo, iColumnInfo2);
    }

    @Override
    public IColumn coerceConcatColumns(IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.generalizedCoercion(CoercionOperation.CONCAT, iColumnInfo, iColumnInfo2);
    }

    @Override
    public IColumn coerceInColumns(IColumnInfo iColumnInfo, List<? extends IColumnInfo> list) throws ErrorException {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("Can not coerce data type for IN expression: invalid argument.");
        }
        if (list.size() == 1) {
            return this.generalizedCoercion(CoercionOperation.IN, iColumnInfo, list.get(0));
        }
        Iterator<? extends IColumnInfo> iterator = list.iterator();
        IColumnInfo iColumnInfo2 = iterator.next();
        IColumnInfo iColumnInfo3 = iterator.next();
        ColumnMetadata columnMetadata = this.generalizedCoercion(CoercionOperation.UNION, iColumnInfo2, iColumnInfo3);
        MetadataColumnInfo metadataColumnInfo = new MetadataColumnInfo(columnMetadata, IColumnInfo.ColumnType.COLUMN);
        while (iterator.hasNext()) {
            columnMetadata = this.generalizedCoercion(CoercionOperation.UNION, metadataColumnInfo, iterator.next());
            metadataColumnInfo.setColumnMetadata(columnMetadata);
        }
        return this.generalizedCoercion(CoercionOperation.IN, iColumnInfo, metadataColumnInfo);
    }

    @Override
    public IColumn coerceLikeColumns(IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.generalizedCoercion(CoercionOperation.LIKE, iColumnInfo, iColumnInfo2);
    }

    @Override
    public IColumn coerceUnionColumns(IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.generalizedCoercion(CoercionOperation.UNION, iColumnInfo, iColumnInfo2);
    }

    @Override
    public IColumn coerceDivisionColumns(IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.generalizedCoercion(CoercionOperation.DIVISION, iColumnInfo, iColumnInfo2);
    }

    @Override
    public IColumn coerceMinusColumns(IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.generalizedCoercion(CoercionOperation.MINUS, iColumnInfo, iColumnInfo2);
    }

    @Override
    public IColumn coercePlusColumns(IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.generalizedCoercion(CoercionOperation.PLUS, iColumnInfo, iColumnInfo2);
    }

    @Override
    public IColumn coerceMultiplicationColumns(IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.generalizedCoercion(CoercionOperation.MULTIPLICATION, iColumnInfo, iColumnInfo2);
    }

    @Override
    public IColumn determineLiteralColumn(String string, ICoercionHandler.LiteralType literalType) throws ErrorException {
        return this.m_literalMetadataFactory.determineLiteralType(string, literalType);
    }

    @Override
    public IColumn coerceUnaryMinusColumn(IColumnInfo iColumnInfo) throws ErrorException {
        SqlTypes sqlTypes = SqlTypes.getValueOf(iColumnInfo.getType());
        if (sqlTypes.isInteger() || sqlTypes == SqlTypes.SQL_BIT) {
            SqlTypes sqlTypes2 = null;
            sqlTypes2 = sqlTypes == SqlTypes.SQL_BIT ? SqlTypes.SQL_INTEGER : AESqlTypeCoercer.upIntegerType(sqlTypes);
            if ((sqlTypes2 = this.m_typeNormalizer.normalizeType(sqlTypes2)) == null) {
                throw SQLEngineExceptionFactory.invalidOperationException("Can not normalize type: all available coercion type is disabled.");
            }
            ColumnMetadata columnMetadata = new ColumnMetadata(TypeMetadata.createTypeMetadata(sqlTypes2.getSqlType(), true));
            columnMetadata.setNullable(iColumnInfo.getNullable());
            columnMetadata.setUpdatable(iColumnInfo.getUpdatable());
            columnMetadata.setName(null);
            return columnMetadata;
        }
        if (sqlTypes.isNumber()) {
            ColumnMetadata columnMetadata = MetadataUtilities.createColumnMetadata(iColumnInfo);
            columnMetadata.getTypeMetadata().setSigned(true);
            columnMetadata.setName(null);
            return columnMetadata;
        }
        if (SqlTypes.SQL_DATE == sqlTypes || SqlTypes.SQL_TIMESTAMP == sqlTypes) {
            ColumnMetadata columnMetadata = MetadataUtilities.createColumnMetadata(iColumnInfo);
            columnMetadata.setName(null);
            return columnMetadata;
        }
        throw SQLEngineExceptionFactory.incompatibleTypesException("NEGATION", sqlTypes.name());
    }

    protected long calcColumnLength(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.calcColumnLength(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected PrecisionScale calcPrecisionScale(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.calcPrecisionScale(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected int coerceType(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.m_typeCoercer.coerceType(coercionOperation, iColumnInfo, iColumnInfo2);
    }

    protected boolean coerceIsCurrency(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.coerceIsCurrency(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected boolean coerceIsSigned(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.coerceIsSigned(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected Nullable coerceNullable(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.coerceNullable(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected boolean coerceIsCaseSensitive(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.coerceIsCaseSensitive(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected Searchable coerceSearchability(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.coerceSearchability(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected Updatable coerceUpdatability(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.coerceUpdatability(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected boolean coerceIsAutoUnique(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.coerceIsAutoUnique(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected final void disableCoercionTypes(Set<Integer> set) throws ErrorException {
        for (int n : set) {
            this.m_typeNormalizer.disableType(n);
        }
    }

    protected int normalizeCoercionType(int n) throws ErrorException {
        return this.m_typeNormalizer.normalizeType(n);
    }

    protected void finalizeCoercion(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, ColumnMetadata columnMetadata) throws ErrorException {
        SqlTypes sqlTypes;
        SqlTypes sqlTypes2 = SqlTypes.getValueOf(columnMetadata.getTypeMetadata().getType());
        if ((sqlTypes2.isChar() || sqlTypes2.isWChar() || sqlTypes2.isBinary()) && (sqlTypes = this.m_typeNormalizer.fitBinaryOrCharType(sqlTypes2, columnMetadata.getColumnLength())) != sqlTypes2) {
            columnMetadata.setTypeMetadata(this.getBinaryOrCharTypeReplacement(columnMetadata.getTypeMetadata(), sqlTypes));
        }
        columnMetadata.setName(null);
    }

    protected final void overrideCoercionType(CoercionOperation coercionOperation, int n, int n2, int n3) throws ErrorException {
        this.m_typeCoercer.overrideCoercionType(coercionOperation, n, n2, n3);
    }

    private ColumnMetadata generalizedCoercion(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        if (coercionOperation == null || iColumnInfo == null || iColumnInfo2 == null) {
            throw new NullPointerException("Coercion handler are called with null argument.");
        }
        int n = this.coerceType(coercionOperation, iColumnInfo, iColumnInfo2);
        n = this.normalizeCoercionType(n);
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(n);
        ColumnMetadata columnMetadata = new ColumnMetadata(typeMetadata);
        PrecisionScale precisionScale = this.calcPrecisionScale(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata);
        typeMetadata.setPrecision(precisionScale.getPrecision());
        typeMetadata.setScale(precisionScale.getScale());
        typeMetadata.setSigned(this.coerceIsSigned(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata));
        typeMetadata.setIsCurrency(this.coerceIsCurrency(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata));
        try {
            columnMetadata.setColumnLength(this.calcColumnLength(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata));
        }
        catch (NumericOverflowException numericOverflowException) {
            throw SQLEngineExceptionFactory.numericOverflowException(numericOverflowException.getMessage());
        }
        columnMetadata.setNullable(this.coerceNullable(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata));
        columnMetadata.setCaseSensitive(this.coerceIsCaseSensitive(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata));
        columnMetadata.setSearchable(this.coerceSearchability(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata));
        columnMetadata.setUpdatable(this.coerceUpdatability(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata));
        columnMetadata.setAutoUnique(this.coerceIsAutoUnique(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata));
        this.finalizeCoercion(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata);
        return columnMetadata;
    }

    private TypeMetadata getBinaryOrCharTypeReplacement(TypeMetadata typeMetadata, SqlTypes sqlTypes) throws ErrorException {
        SqlTypes sqlTypes2 = SqlTypes.getValueOf(typeMetadata.getType());
        assert (sqlTypes2.isBinary() && sqlTypes.isBinary() || sqlTypes2.isChar() && sqlTypes.isChar() || sqlTypes2.isWChar() && sqlTypes.isWChar());
        TypeMetadata typeMetadata2 = TypeMetadata.createTypeMetadata(sqlTypes.getSqlType());
        typeMetadata2.setIsSortable(typeMetadata.isSortable());
        typeMetadata2.setPrecision(typeMetadata.getPrecision());
        return typeMetadata2;
    }

    protected static final class PrecisionScale {
        private short m_precision;
        private short m_scale;

        public PrecisionScale(short s, short s2) {
            this.m_precision = s;
            this.m_scale = s2;
        }

        public short getPrecision() {
            return this.m_precision;
        }

        public void setPrecision(short s) {
            this.m_precision = s;
        }

        public short getScale() {
            return this.m_scale;
        }

        public void setScale(short s) {
            this.m_scale = s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum CoercionOperation {
        COMPARISON,
        CONCAT,
        IN,
        LIKE,
        UNION,
        DIVISION,
        MINUS,
        PLUS,
        MULTIPLICATION;

    }
}

