/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.WeightAdjuster;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NewAppWeightBooster
extends Configured
implements WeightAdjuster {
    private static final float DEFAULT_FACTOR = 3.0f;
    private static final long DEFAULT_DURATION = 300000L;
    private float factor;
    private long duration;

    public void setConf(Configuration conf) {
        if (conf != null) {
            this.factor = conf.getFloat("mapred.newjobweightbooster.factor", 3.0f);
            this.duration = conf.getLong("mapred.newjobweightbooster.duration", 300000L);
        }
        super.setConf(conf);
    }

    @Override
    public double adjustWeight(FSAppAttempt app, double curWeight) {
        long start = app.getStartTime();
        long now = System.currentTimeMillis();
        if (now - start < this.duration) {
            return curWeight * (double)this.factor;
        }
        return curWeight;
    }
}

