/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;

@Metrics(context="yarn")
public class FSQueueMetrics
extends QueueMetrics {
    @Metric(value={"Fair share of memory in MB"})
    MutableGaugeInt fairShareMB;
    @Metric(value={"Fair share of CPU in vcores"})
    MutableGaugeInt fairShareVCores;
    @Metric(value={"Steady fair share of memory in MB"})
    MutableGaugeInt steadyFairShareMB;
    @Metric(value={"Steady fair share of CPU in vcores"})
    MutableGaugeInt steadyFairShareVCores;
    @Metric(value={"Minimum share of memory in MB"})
    MutableGaugeInt minShareMB;
    @Metric(value={"Minimum share of CPU in vcores"})
    MutableGaugeInt minShareVCores;
    @Metric(value={"Maximum share of memory in MB"})
    MutableGaugeInt maxShareMB;
    @Metric(value={"Maximum share of CPU in vcores"})
    MutableGaugeInt maxShareVCores;

    FSQueueMetrics(MetricsSystem ms, String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        super(ms, queueName, parent, enableUserMetrics, conf);
    }

    public void setFairShare(Resource resource) {
        this.fairShareMB.set(resource.getMemory());
        this.fairShareVCores.set(resource.getVirtualCores());
    }

    public int getFairShareMB() {
        return this.fairShareMB.value();
    }

    public int getFairShareVirtualCores() {
        return this.fairShareVCores.value();
    }

    public void setSteadyFairShare(Resource resource) {
        this.steadyFairShareMB.set(resource.getMemory());
        this.steadyFairShareVCores.set(resource.getVirtualCores());
    }

    public int getSteadyFairShareMB() {
        return this.steadyFairShareMB.value();
    }

    public int getSteadyFairShareVCores() {
        return this.steadyFairShareVCores.value();
    }

    public void setMinShare(Resource resource) {
        this.minShareMB.set(resource.getMemory());
        this.minShareVCores.set(resource.getVirtualCores());
    }

    public int getMinShareMB() {
        return this.minShareMB.value();
    }

    public int getMinShareVirtualCores() {
        return this.minShareVCores.value();
    }

    public void setMaxShare(Resource resource) {
        this.maxShareMB.set(resource.getMemory());
        this.maxShareVCores.set(resource.getVirtualCores());
    }

    public int getMaxShareMB() {
        return this.maxShareMB.value();
    }

    public int getMaxShareVirtualCores() {
        return this.maxShareVCores.value();
    }

    public static synchronized FSQueueMetrics forQueue(String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        QueueMetrics metrics = (QueueMetrics)queueMetrics.get(queueName);
        if (metrics == null) {
            metrics = new FSQueueMetrics(ms, queueName, parent, enableUserMetrics, conf).tag(QUEUE_INFO, queueName);
            if (ms != null) {
                metrics = (QueueMetrics)ms.register(FSQueueMetrics.sourceName(queueName).toString(), "Metrics for queue: " + queueName, (Object)metrics);
            }
            queueMetrics.put(queueName, metrics);
        }
        return (FSQueueMetrics)metrics;
    }
}

