/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.parser;

import com.cloudera.sqlengine.exceptions.SQLEngineException;
import com.cloudera.sqlengine.parser.DefaultLimitChecker;
import com.cloudera.sqlengine.parser.IPTLimitChecker;
import com.cloudera.sqlengine.parser.generated.Parser;
import com.cloudera.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.sqlengine.parser.type.PTStringConstraint;

public class PTParser {
    private PTParser() {
        throw new UnsupportedOperationException("Not instantiable");
    }

    public static IPTNode parse(String string) throws SQLEngineException {
        return PTParser.parse(string, new DefaultLimitChecker());
    }

    public static IPTNode parse(String string, IPTLimitChecker iPTLimitChecker) throws SQLEngineException {
        if (null == string) {
            throw new NullPointerException("sqlStatement must not be null");
        }
        if (null == iPTLimitChecker) {
            throw new NullPointerException("limitChecker must not be null");
        }
        iPTLimitChecker.checkString(PTStringConstraint.STATEMENT_LEN, string);
        return new Parser(string, iPTLimitChecker).parse();
    }
}

