/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.etree.statement;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.dsi.dataengine.utilities.CursorType;
import com.cloudera.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.cloudera.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.sqlengine.executor.etree.IETNode;
import com.cloudera.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.sqlengine.executor.etree.relation.ETTable;
import com.cloudera.sqlengine.executor.etree.statement.IETRowCountStatement;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.Pair;
import com.cloudera.support.exceptions.DiagState;
import com.cloudera.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETInsert
implements IETRowCountStatement {
    private long m_rowcount = -1L;
    private ETTable m_table;
    private ArrayList<Pair<Integer, ETDataRequest>> m_insertColumnReqs;
    private ETRelationalExpr m_dataRelation;
    private int[] m_defaultCols;
    private short[] m_tgtTableTypes;

    public ETInsert(ETTable eTTable, List<Pair<Integer, IColumn>> list, ETRelationalExpr eTRelationalExpr) throws ErrorException {
        if (eTTable == null || list == null || eTRelationalExpr == null) {
            throw new NullPointerException();
        }
        if (list.size() != eTRelationalExpr.getColumnCount()) {
            throw new IllegalArgumentException("column count mismatch");
        }
        this.m_table = eTTable;
        this.m_dataRelation = eTRelationalExpr;
        this.m_tgtTableTypes = new short[this.m_table.getColumnCount()];
        HashSet<Integer> hashSet = new HashSet<Integer>(this.m_table.getColumnCount());
        for (int i = 0; i < this.m_tgtTableTypes.length; ++i) {
            this.m_tgtTableTypes[i] = this.m_table.getColumn(i).getTypeMetadata().getType();
            hashSet.add(i);
        }
        this.m_insertColumnReqs = new ArrayList(list.size());
        for (Pair<Integer, IColumn> object2 : list) {
            ETDataRequest n2 = new ETDataRequest(object2.value());
            this.m_insertColumnReqs.add(new Pair<Integer, ETDataRequest>(object2.key(), n2));
            hashSet.remove(object2.key());
        }
        this.m_defaultCols = new int[hashSet.size()];
        int n = 0;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            this.m_defaultCols[n++] = n2;
        }
    }

    @Override
    public boolean isResultSet() {
        return false;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public String getLogString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.m_rowcount;
    }

    @Override
    public void execute() throws ErrorException {
        this.m_table.open(CursorType.FORWARD_ONLY);
        this.m_dataRelation.open(CursorType.FORWARD_ONLY);
        this.m_table.onStartDMLBatch(DSIExtJResultSet.DMLType.INSERT, -1L);
        this.insertData();
        this.m_table.onFinishDMLBatch();
        this.m_table.close();
        this.m_dataRelation.close();
    }

    private void insertData() throws ErrorException {
        DataWrapper dataWrapper = new DataWrapper();
        this.m_rowcount = 0L;
        while (this.m_dataRelation.move()) {
            this.m_table.appendRow();
            for (int n : this.m_defaultCols) {
                dataWrapper.setNull(this.m_tgtTableTypes[n]);
                if (!this.m_table.writeData(n, dataWrapper, 0L, true)) continue;
                throw new ErrorException(DiagState.DIAG_INTERVAL_OVERFLOW, 7, SQLEngineMessageKey.RIGHT_DATA_TRUNCATION.name(), -1, n);
            }
            for (int i = 0; i < this.m_insertColumnReqs.size(); ++i) {
                Pair<Integer, ETDataRequest> pair = this.m_insertColumnReqs.get(i);
                int n = pair.key();
                ETDataRequest eTDataRequest = pair.value();
                eTDataRequest.setOffset(0L);
                boolean bl = true;
                while (bl) {
                    bl = this.m_dataRelation.retrieveData(i, eTDataRequest);
                    boolean bl2 = false;
                    long l = 0L;
                    if (eTDataRequest.isDefault()) {
                        bl2 = true;
                        dataWrapper.setNull(this.m_tgtTableTypes[n]);
                    } else {
                        eTDataRequest.getData().retrieveData(dataWrapper);
                        l = eTDataRequest.getOffset();
                    }
                    if (this.m_table.writeData(n, dataWrapper, l, bl2)) {
                        throw new ErrorException(DiagState.DIAG_STR_RIGHT_TRUNC_ERR, 7, SQLEngineMessageKey.RIGHT_DATA_TRUNCATION.name(), -1, n);
                    }
                    if (!bl) continue;
                    eTDataRequest.setOffset(eTDataRequest.getOffset() + eTDataRequest.getMaxSize());
                }
            }
            this.m_table.onFinishRowUpdate();
            ++this.m_rowcount;
        }
    }

    private IETNode getChild(int n) {
        switch (n) {
            case 0: {
                return this.m_table;
            }
            case 1: {
                return this.m_dataRelation;
            }
        }
        throw new IndexOutOfBoundsException("index: " + n);
    }

    @Override
    public Iterator<? extends IETNode> getChildItr() {
        return new AbstractList<IETNode>(){

            @Override
            public IETNode get(int n) {
                return ETInsert.this.getChild(n);
            }

            @Override
            public int size() {
                return ETInsert.this.getNumChildren();
            }
        }.iterator();
    }
}

