/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.etree.bool;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.dsi.exceptions.NumericOverflowException;
import com.cloudera.sqlengine.exceptions.SQLEngineException;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.executor.etree.ETBoolean;
import com.cloudera.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.sqlengine.executor.etree.IETNode;
import com.cloudera.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.cloudera.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.exceptions.DiagState;
import com.cloudera.support.exceptions.ErrorException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETLike
extends ETBooleanExpr {
    private static final boolean[] REGEX_SPECIAL_CHAR = new boolean[256];
    private ETValueExpr m_leftOperand;
    private ETValueExpr m_rightOperand;
    private ETValueExpr m_escapeChar;
    private ETDataRequest m_leftData;
    private ETDataRequest m_rightData;
    private ETDataRequest m_escpData;
    private boolean m_hasEscapeChar = false;

    public ETLike(IColumn iColumn, ETValueExpr eTValueExpr, ETValueExpr eTValueExpr2, ETValueExpr eTValueExpr3) throws ErrorException {
        if (eTValueExpr == null || iColumn == null || eTValueExpr2 == null) {
            throw new NullPointerException();
        }
        if (!iColumn.getTypeMetadata().isCharacterType()) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("LIKE predicate on type : " + iColumn.getTypeMetadata().getTypeName());
        }
        this.m_leftData = new ETDataRequest(iColumn);
        this.m_rightData = new ETDataRequest(iColumn);
        if (eTValueExpr3 != null) {
            this.m_hasEscapeChar = true;
            ColumnMetadata columnMetadata = new ColumnMetadata(TypeMetadata.createTypeMetadata(1));
            try {
                columnMetadata.setColumnLength(2L);
            }
            catch (NumericOverflowException numericOverflowException) {
                // empty catch block
            }
            this.m_escpData = new ETDataRequest(columnMetadata);
        } else {
            this.m_hasEscapeChar = false;
            this.m_escpData = null;
        }
        this.m_leftOperand = eTValueExpr;
        this.m_rightOperand = eTValueExpr2;
        this.m_escapeChar = eTValueExpr3;
    }

    @Override
    public void close() {
        this.m_leftOperand.close();
        this.m_rightOperand.close();
        if (this.m_hasEscapeChar) {
            this.m_escapeChar.close();
        }
    }

    @Override
    public boolean isOpen() {
        boolean bl;
        boolean bl2 = bl = this.m_leftOperand.isOpen() && this.m_rightOperand.isOpen();
        if (this.m_hasEscapeChar) {
            return bl && this.m_escapeChar.isOpen();
        }
        return bl;
    }

    @Override
    public void reset() throws ErrorException {
        this.m_leftOperand.reset();
        this.m_rightOperand.reset();
        if (this.m_hasEscapeChar) {
            this.m_escapeChar.reset();
        }
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public int getNumChildren() {
        return this.m_hasEscapeChar ? 3 : 2;
    }

    @Override
    public ETBoolean evaluate() throws ErrorException {
        String string;
        this.m_leftOperand.retrieveData(this.m_leftData);
        this.m_rightOperand.retrieveData(this.m_rightData);
        if (this.m_leftData.getData().isNull() || this.m_rightData.getData().isNull()) {
            return ETBoolean.SQL_BOOLEAN_UNKNOWN;
        }
        char c = '\u0000';
        if (this.m_hasEscapeChar) {
            this.m_escapeChar.retrieveData(this.m_escpData);
            if (this.m_escpData.getData().isNull()) {
                return ETBoolean.SQL_BOOLEAN_UNKNOWN;
            }
            string = this.m_escpData.getData().getChar();
            if (string.length() != 1) {
                throw new SQLEngineException(DiagState.DIAG_INVALID_ESC_CHAR, SQLEngineMessageKey.INVALID_ESC_CHAR.name(), new String[]{string});
            }
            c = string.charAt(0);
        }
        string = this.m_leftData.getData().getChar();
        String string2 = this.m_rightData.getData().getChar();
        String string3 = this.createPattern(string2, c);
        if (Pattern.matches(string3, string)) {
            return ETBoolean.SQL_BOOLEAN_TRUE;
        }
        return ETBoolean.SQL_BOOLEAN_FALSE;
    }

    private String createPattern(String string, char c) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block0: for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (this.m_hasEscapeChar && c == c2) {
                if (++i >= string.length()) {
                    throw SQLEngineExceptionFactory.invalidEscapeSequenceException();
                }
                c2 = string.charAt(i);
                if ('_' == c2 || '%' == c2) {
                    stringBuilder.append(c2);
                    continue;
                }
                if (c != c2) {
                    throw SQLEngineExceptionFactory.invalidEscapeSequenceException();
                }
            }
            if ('%' == c2) {
                stringBuilder.append(".*");
                int n = i + 1;
                while (true) {
                    if (n == string.length()) {
                        return stringBuilder.toString();
                    }
                    if ('%' != string.charAt(n)) {
                        i = n - 1;
                        continue block0;
                    }
                    ++n;
                }
            }
            if ('_' == c2) {
                stringBuilder.append('.');
                continue;
            }
            if (ETLike.isRegexSpecialChar(c2)) {
                stringBuilder.append('\\').append(c2);
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.append(" *").toString();
    }

    private static boolean isRegexSpecialChar(char c) {
        return c < '\u0100' && REGEX_SPECIAL_CHAR[c];
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return this.m_leftOperand;
            }
            case 1: {
                return this.m_rightOperand;
            }
            case 2: {
                if (this.m_hasEscapeChar) {
                    return this.m_escapeChar;
                }
                throw new IndexOutOfBoundsException("index: " + n);
            }
        }
        throw new IndexOutOfBoundsException("index: " + n);
    }

    @Override
    public void open() throws ErrorException {
        this.m_leftOperand.open();
        this.m_rightOperand.open();
        if (this.m_hasEscapeChar) {
            this.m_escapeChar.open();
        }
    }

    static {
        ETLike.REGEX_SPECIAL_CHAR[91] = true;
        ETLike.REGEX_SPECIAL_CHAR[123] = true;
        ETLike.REGEX_SPECIAL_CHAR[40] = true;
        ETLike.REGEX_SPECIAL_CHAR[41] = true;
        ETLike.REGEX_SPECIAL_CHAR[43] = true;
        ETLike.REGEX_SPECIAL_CHAR[42] = true;
        ETLike.REGEX_SPECIAL_CHAR[46] = true;
        ETLike.REGEX_SPECIAL_CHAR[94] = true;
        ETLike.REGEX_SPECIAL_CHAR[36] = true;
        ETLike.REGEX_SPECIAL_CHAR[124] = true;
        ETLike.REGEX_SPECIAL_CHAR[63] = true;
        ETLike.REGEX_SPECIAL_CHAR[92] = true;
    }
}

