/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.datawrapper;

import com.cloudera.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.dsi.exceptions.IncorrectTypeException;
import com.cloudera.sqlengine.exceptions.SQLEngineException;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.exceptions.ErrorException;

public final class SqlRealDataWrapper
extends DefaultSqlDataWrapper {
    private float m_data;
    private boolean m_isSet = false;
    private boolean m_isNull = false;

    public double getDouble() throws ErrorException, NullPointerException {
        return this.getData();
    }

    public float getReal() throws ErrorException, NullPointerException {
        return this.getData();
    }

    public int getType() {
        return 7;
    }

    public boolean isNull() {
        return this.m_isNull;
    }

    public boolean isSet() {
        return this.m_isSet;
    }

    public void setBoolean(boolean bl) {
        this.m_isSet = true;
        this.m_isNull = false;
        this.m_data = bl ? 1.0f : 0.0f;
    }

    public void setReal(float f) {
        this.m_isSet = true;
        this.m_data = f;
        this.m_isNull = false;
    }

    public void setTinyInt(short s) {
        this.m_isSet = true;
        this.m_data = s;
        this.m_isNull = false;
    }

    private float getData() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
        if (this.m_isNull) {
            throw new NullPointerException("Data requested, but the data is null.");
        }
        return this.m_data;
    }

    public void setNull() {
        this.m_isSet = true;
        this.m_isNull = true;
    }

    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        if (dataWrapper.isNull()) {
            this.setNull();
        } else {
            try {
                switch (dataWrapper.getType()) {
                    case 16: {
                        this.setBoolean(dataWrapper.getBoolean());
                        break;
                    }
                    case -7: {
                        this.setBoolean(dataWrapper.getBit());
                        break;
                    }
                    case -6: {
                        this.setTinyInt(dataWrapper.getTinyInt());
                        break;
                    }
                    case 7: {
                        this.setReal(dataWrapper.getReal().floatValue());
                        break;
                    }
                    default: {
                        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                    }
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
            }
        }
    }

    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        if (!this.m_isSet) {
            throw new IllegalStateException("ISqlDataWrapper is not set with data for retrieval");
        }
        if (this.m_isNull) {
            dataWrapper.setNull(7);
            return;
        }
        dataWrapper.setReal(this.m_data);
    }
}

