/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.aeprocessor.aetree.statement;

import com.cloudera.sqlengine.aeprocessor.aetree.AETreeWalker;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AETable;
import com.cloudera.sqlengine.aeprocessor.aetree.statement.AERowCountStatement;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.sqlengine.exceptions.SQLEngineException;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.exceptions.DiagState;
import com.cloudera.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AEInsert
extends AERowCountStatement {
    private static final int NUM_CHILDREN = 2;
    private AETable m_table;
    private AEValueExprList m_insertColumns;
    private AERelationalExpr m_relExpr;
    private boolean m_hasBeenValidated = false;
    private boolean m_isRecursive;
    private boolean m_hasCalculatedIfRecursive;

    public AEInsert(AETable aETable, AEValueExprList aEValueExprList, AERelationalExpr aERelationalExpr, SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        this(aETable, aEValueExprList, aERelationalExpr);
        this.validate();
    }

    private AEInsert(AETable aETable, AEValueExprList aEValueExprList, AERelationalExpr aERelationalExpr) {
        this.m_table = aETable;
        this.m_table.setParent(this);
        this.m_insertColumns = aEValueExprList;
        this.m_insertColumns.setParent(this);
        this.m_relExpr = aERelationalExpr;
        this.m_relExpr.setParent(this);
        this.m_isRecursive = false;
        this.m_hasCalculatedIfRecursive = false;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public AEInsert copy() {
        return new AEInsert(this.m_table.copy(), this.m_insertColumns.copy(), this.m_relExpr.copy());
    }

    @Override
    public Iterator<? extends IAENode> getChildItr() {
        return new AbstractList<IAENode>(){

            @Override
            public IAENode get(int n) {
                if (0 == n) {
                    return AEInsert.this.m_table;
                }
                if (1 == n) {
                    return AEInsert.this.m_relExpr;
                }
                throw new IndexOutOfBoundsException("" + n);
            }

            @Override
            public int size() {
                return 2;
            }
        }.iterator();
    }

    @Override
    public String getLogString() {
        return "AEInsert";
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    public AEValueExprList getInsertColumns() {
        return this.m_insertColumns;
    }

    public AERelationalExpr getRelationalExpr() {
        return this.m_relExpr;
    }

    public AETable getTable() {
        return this.m_table;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AEInsert)) {
            return false;
        }
        AEInsert aEInsert = (AEInsert)iAENode;
        return this.m_table.isEquivalent(aEInsert.m_table) && this.m_insertColumns.isEquivalent(aEInsert.m_insertColumns) && this.m_relExpr.isEquivalent(aEInsert.m_relExpr);
    }

    @Override
    public void reprocessMetadata() throws ErrorException {
        this.m_relExpr.acceptVisitor(AEInsert.getMetadataProcessor());
        this.validate();
    }

    public boolean isRecursive() {
        if (!this.m_hasCalculatedIfRecursive) {
            this.m_isRecursive = false;
            AETreeWalker aETreeWalker = new AETreeWalker(this.m_relExpr);
            while (aETreeWalker.hasNext()) {
                AETable aETable;
                IAENode iAENode = aETreeWalker.next();
                if (!(iAENode instanceof AETable) || !(aETable = (AETable)iAENode).getTableName().equals(this.m_table.getTableName()) || !aETable.getSchemaName().equals(this.m_table.getSchemaName()) || !aETable.getCatalogName().equals(this.m_table.getCatalogName())) continue;
                this.m_isRecursive = true;
            }
        }
        return this.m_isRecursive;
    }

    private void checkDuplicateColumns() throws ErrorException {
        int n = this.m_insertColumns.getNumChildren();
        for (int i = 0; i < n - 1; ++i) {
            AEValueExpr aEValueExpr = (AEValueExpr)this.m_insertColumns.getChild(i);
            assert (aEValueExpr instanceof AEColumnReference);
            for (int j = i + 1; j < n; ++j) {
                if (!aEValueExpr.isEquivalent((IAENode)this.m_insertColumns.getChild(j))) continue;
                throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.DUPLICATE_INSERT_COLUMN.name(), new String[]{aEValueExpr.getName()});
            }
        }
    }

    private void validate() throws ErrorException {
        if (!this.m_hasBeenValidated) {
            this.validateNumberOfColumns();
            this.checkDuplicateColumns();
        }
        this.m_hasBeenValidated = true;
    }

    private void validateNumberOfColumns() throws ErrorException {
        int n = 0 == this.m_insertColumns.getNumChildren() ? this.m_table.getColumnCount() : this.m_insertColumns.getNumChildren();
        if (this.m_relExpr.getColumnCount() != n) {
            throw new SQLEngineException(DiagState.DIAG_INSERT_VAL_LIST_COL_LIST_MISMATCH, SQLEngineMessageKey.INVALID_NUMBER_INSERT_VALUES.name(), new String[]{"" + this.m_relExpr.getColumnCount(), "" + n});
        }
    }
}

