/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.jdbc.kerberos;

import com.cloudera.hivecommon.api.HiveServerHttpPrivilegedAction;
import java.io.IOException;
import javax.security.auth.Subject;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class KerberosHttpInterceptor
implements HttpRequestInterceptor {
    private Subject m_kerberosSubject;
    HiveServerHttpPrivilegedAction m_action;

    public KerberosHttpInterceptor(String string, String string2, Subject subject) {
        this.m_kerberosSubject = subject;
        this.m_action = new HiveServerHttpPrivilegedAction(string + "@" + string2);
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        try {
            this.addHttpAuthHeader(httpRequest);
        }
        catch (Exception exception) {
            throw new HttpException(exception.getMessage(), (Throwable)exception);
        }
    }

    protected void addHttpAuthHeader(HttpRequest httpRequest) throws Exception {
        Subject.doAs(this.m_kerberosSubject, this.m_action);
        httpRequest.addHeader("Authorization", "Negotiate " + this.m_action.getKerberosTokenString());
    }
}

