/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.core;

import com.cloudera.hivecommon.AuthMech;
import com.cloudera.hivecommon.HiveJDBCCasePreservingAlias;
import com.cloudera.hivecommon.HiveJDBCSettings;
import com.cloudera.hivecommon.IServerVersion;
import com.cloudera.hivecommon.IServerVersionUtils;
import com.cloudera.impala.core.ImpalaJDBCServerVersion;

public class ImpalaJDBCServerVersionUtils
implements IServerVersionUtils {
    @Override
    public boolean isServerVersionSet(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case AUTO: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getIsTemporaryColIndex(IServerVersion iServerVersion) {
        return 1;
    }

    @Override
    public int getTableNameColIndex(IServerVersion iServerVersion) {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IServerVersion parseServerVersion(String string) {
        try {
            String[] stringArray;
            if (string == "AUTO") {
                return ImpalaJDBCServerVersion.AUTO;
            }
            int n = string.indexOf(45);
            if (-1 != n) {
                string = string.substring(0, n);
            }
            if ((stringArray = string.split("\\.")).length < 1) return ImpalaJDBCServerVersion.Im_1_0_1;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            n2 = new Integer(stringArray[0]);
            if (stringArray.length >= 2) {
                n3 = new Integer(stringArray[1]);
                if (stringArray.length >= 3) {
                    try {
                        n4 = new Integer(stringArray[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n4 = 0;
                    }
                }
            }
            if (1 == n2) {
                if (0 == n3) {
                    return ImpalaJDBCServerVersion.Im_1_0_1;
                }
                if (1 == n3) {
                    return ImpalaJDBCServerVersion.Im_1_1_1;
                }
                if (2 == n3) {
                    if (0 == n4) {
                        return ImpalaJDBCServerVersion.Im_1_2_0;
                    }
                    if (1 == n4) {
                        return ImpalaJDBCServerVersion.Im_1_2_1;
                    }
                    if (2 == n4) {
                        return ImpalaJDBCServerVersion.Im_1_2_2;
                    }
                    if (3 == n4) {
                        return ImpalaJDBCServerVersion.Im_1_2_3;
                    }
                    if (4 > n4) return ImpalaJDBCServerVersion.Im_1_0_1;
                    return ImpalaJDBCServerVersion.Im_1_2_4;
                }
                if (3 == n3) {
                    if (0 == n4) {
                        return ImpalaJDBCServerVersion.Im_1_3_0;
                    }
                    if (1 > n4) return ImpalaJDBCServerVersion.Im_1_0_1;
                    return ImpalaJDBCServerVersion.Im_1_3_1;
                }
                if (4 != n3) return ImpalaJDBCServerVersion.Im_1_4_3;
                if (3 > n4) {
                    return ImpalaJDBCServerVersion.Im_1_4_0;
                }
                if (3 > n4) return ImpalaJDBCServerVersion.Im_1_0_1;
                return ImpalaJDBCServerVersion.Im_1_4_3;
            }
            if (2 != n2) {
                if (2 >= n2) return ImpalaJDBCServerVersion.Im_1_0_1;
                return ImpalaJDBCServerVersion.Im_2_9_0;
            }
            if (0 == n3) {
                if (0 == n4) {
                    return ImpalaJDBCServerVersion.Im_2_0_0;
                }
                if (true > n4) return ImpalaJDBCServerVersion.Im_1_0_1;
                return ImpalaJDBCServerVersion.Im_2_0_1;
            }
            if (1 == n3) {
                return ImpalaJDBCServerVersion.Im_2_1_0;
            }
            if (2 == n3) {
                return ImpalaJDBCServerVersion.Im_2_2_0;
            }
            if (3 == n3) {
                return ImpalaJDBCServerVersion.Im_2_3_0;
            }
            if (4 == n3) {
                return ImpalaJDBCServerVersion.Im_2_4_0;
            }
            if (5 == n3) {
                return ImpalaJDBCServerVersion.Im_2_5_0;
            }
            if (6 == n3) {
                return ImpalaJDBCServerVersion.Im_2_6_0;
            }
            if (7 == n3) {
                return ImpalaJDBCServerVersion.Im_2_7_0;
            }
            if (8 != n3) return ImpalaJDBCServerVersion.Im_2_9_0;
            return ImpalaJDBCServerVersion.Im_2_8_0;
        }
        catch (Exception exception) {
            return ImpalaJDBCServerVersion.Im_2_9_0;
        }
    }

    @Override
    public AuthMech resolveDefaultAuthMech(HiveJDBCSettings hiveJDBCSettings) {
        return AuthMech.NOAUTH;
    }

    @Override
    public boolean supportsComplexTypesInResults() {
        return false;
    }

    @Override
    public boolean supportsHttpTransportMode(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsDescribeTable(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsV3Protocol(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsV6Protocol(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_2_0_0: 
            case Im_2_0_1: 
            case Im_2_1_0: 
            case Im_2_2_0: 
            case Im_2_3_0: 
            case Im_2_4_0: 
            case Im_2_5_0: 
            case Im_2_6_0: 
            case Im_2_7_0: 
            case Im_2_8_0: 
            case Im_2_9_0: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsAsynchronousOperations(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsCharLength(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_2_0_0: 
            case Im_2_0_1: 
            case Im_2_1_0: 
            case Im_2_2_0: 
            case Im_2_3_0: 
            case Im_2_4_0: 
            case Im_2_5_0: 
            case Im_2_6_0: 
            case Im_2_7_0: 
            case Im_2_8_0: 
            case Im_2_9_0: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsVarcharLength(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_2_0_0: 
            case Im_2_0_1: 
            case Im_2_1_0: 
            case Im_2_2_0: 
            case Im_2_3_0: 
            case Im_2_4_0: 
            case Im_2_5_0: 
            case Im_2_6_0: 
            case Im_2_7_0: 
            case Im_2_8_0: 
            case Im_2_9_0: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDecimalPrecisionAndScale(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_2_0_0: 
            case Im_2_0_1: 
            case Im_2_1_0: 
            case Im_2_2_0: 
            case Im_2_3_0: 
            case Im_2_4_0: 
            case Im_2_5_0: 
            case Im_2_6_0: 
            case Im_2_7_0: 
            case Im_2_8_0: 
            case Im_2_9_0: 
            case Im_1_4_0: 
            case Im_1_4_3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTypeBinary(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsTypeChar(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_2_0_0: 
            case Im_2_0_1: 
            case Im_2_1_0: 
            case Im_2_2_0: 
            case Im_2_3_0: 
            case Im_2_4_0: 
            case Im_2_5_0: 
            case Im_2_6_0: 
            case Im_2_7_0: 
            case Im_2_8_0: 
            case Im_2_9_0: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTypeDate(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsTypeDecimal(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_2_0_0: 
            case Im_2_0_1: 
            case Im_2_1_0: 
            case Im_2_2_0: 
            case Im_2_3_0: 
            case Im_2_4_0: 
            case Im_2_5_0: 
            case Im_2_6_0: 
            case Im_2_7_0: 
            case Im_2_8_0: 
            case Im_2_9_0: 
            case Im_1_4_0: 
            case Im_1_4_3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportSTypeReal(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_2_0_0: 
            case Im_2_0_1: 
            case Im_2_1_0: 
            case Im_2_2_0: 
            case Im_2_3_0: 
            case Im_2_4_0: 
            case Im_2_5_0: 
            case Im_2_6_0: 
            case Im_2_7_0: 
            case Im_2_8_0: 
            case Im_2_9_0: 
            case Im_1_4_0: 
            case Im_1_4_3: 
            case Im_1_2_4: 
            case Im_1_3_0: 
            case Im_1_3_1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTypeTimestamp(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsTypeVarchar(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_2_0_0: 
            case Im_2_0_1: 
            case Im_2_1_0: 
            case Im_2_2_0: 
            case Im_2_3_0: 
            case Im_2_4_0: 
            case Im_2_5_0: 
            case Im_2_6_0: 
            case Im_2_7_0: 
            case Im_2_8_0: 
            case Im_2_9_0: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsNestedDataTypes(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_2_3_0: 
            case Im_2_4_0: 
            case Im_2_5_0: 
            case Im_2_6_0: 
            case Im_2_7_0: 
            case Im_2_8_0: 
            case Im_2_9_0: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsUnionDataTypes(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsDMLstatement(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean hqlSupportsDefaultOuterJoin(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public String supportsBackTickedAliases(IServerVersion iServerVersion, String string) {
        return "`" + string + "`";
    }

    @Override
    public boolean supportI16BufferForSmallInt(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportPushdownCatalogFilter(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_1_2_4: 
            case Im_1_0_1: 
            case Im_1_1_1: 
            case Im_1_2_0: 
            case Im_1_2_1: 
            case Im_1_2_2: 
            case Im_1_2_3: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean supportsAliasingInScalarFun(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsGetColumnsAPI(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsQueryCommentHints(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_1_4_0: 
            case Im_1_4_3: 
            case Im_1_2_4: 
            case Im_1_3_0: 
            case Im_1_3_1: 
            case Im_1_0_1: 
            case Im_1_1_1: 
            case Im_1_2_0: 
            case Im_1_2_1: 
            case Im_1_2_2: 
            case Im_1_2_3: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isDisableLimitZeroForSimpleQuery() {
        return true;
    }

    @Override
    public boolean hasIssueWithNullTypeMetadata(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_1_2_4: 
            case Im_1_3_0: 
            case Im_1_0_1: 
            case Im_1_1_1: 
            case Im_1_2_0: 
            case Im_1_2_1: 
            case Im_1_2_2: 
            case Im_1_2_3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasIssueWithNullTypeData(IServerVersion iServerVersion) {
        switch ((ImpalaJDBCServerVersion)iServerVersion) {
            case Im_2_0_0: 
            case Im_2_0_1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsGetSchemasAPI(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsGetTablesAPI(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean needsColumnTypeCastForInsert(IServerVersion iServerVersion) {
        return this.supportsCharLength(iServerVersion);
    }

    @Override
    public boolean needsInsertOptimization(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean preservesAliasCase(HiveJDBCSettings hiveJDBCSettings) {
        return HiveJDBCCasePreservingAlias.PRESERVE_CASE == hiveJDBCSettings.m_lowercaseColumnNameAliase;
    }

    @Override
    public boolean supportsTimeOnlyTimestamp(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsDateOnlyTimestamp(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean usesTransportMode() {
        return false;
    }
}

