/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.dataengine.metadata;

import com.cloudera.dsi.dataengine.interfaces.IMetadataSource;
import com.cloudera.dsi.dataengine.utilities.DSITypeUtilities;
import com.cloudera.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.dsi.dataengine.utilities.Nullable;
import com.cloudera.dsi.dataengine.utilities.Searchable;
import com.cloudera.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.hivecommon.HiveJDBCSettings;
import com.cloudera.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.support.ILogger;
import com.cloudera.support.LogUtilities;
import com.cloudera.support.exceptions.ErrorException;
import java.util.ArrayList;

public class HiveJDBCTypeInfoMetadataSource
implements IMetadataSource {
    private boolean m_isFetching = false;
    private int m_currentIndex = 0;
    private HiveJDBCSettings m_settings;
    ArrayList<TypeInfo> m_dataTypes = new ArrayList();
    private ILogger m_logger;

    public HiveJDBCTypeInfoMetadataSource(ILogger iLogger, HiveJDBCSettings hiveJDBCSettings) {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_settings = hiveJDBCSettings;
        this.m_logger = iLogger;
        this.initializeDataTypes();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_isFetching = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case DATA_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_typeName, dataWrapper, l, l2);
            }
            case DATA_TYPE: {
                dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_sqlType);
                return false;
            }
            case COLUMN_SIZE: {
                dataWrapper.setInteger(this.m_dataTypes.get((int)this.m_currentIndex).m_columnSize);
                return false;
            }
            case LITERAL_PREFIX: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_literalPrefix, dataWrapper, l, l2);
            }
            case LITERAL_SUFFIX: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_literalSuffix, dataWrapper, l, l2);
            }
            case CREATE_PARAM: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_createParams, dataWrapper, l, l2);
            }
            case NULLABLE: {
                dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_nullable.ordinal());
                return false;
            }
            case CASE_SENSITIVE: {
                if (this.m_dataTypes.get((int)this.m_currentIndex).m_caseSensitive) {
                    dataWrapper.setSmallInt(1);
                } else {
                    dataWrapper.setSmallInt(0);
                }
                return false;
            }
            case SEARCHABLE: {
                dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_searchable.ordinal());
                return false;
            }
            case UNSIGNED_ATTRIBUTE: {
                TypeInfo typeInfo = this.m_dataTypes.get(this.m_currentIndex);
                if (!(TypeUtilities.isApproximateNumericType(typeInfo.m_sqlType) || TypeUtilities.isExactNumericType(typeInfo.m_sqlType) || TypeUtilities.isIntegerType(typeInfo.m_sqlType))) {
                    dataWrapper.setNull(5);
                } else if (this.m_dataTypes.get((int)this.m_currentIndex).m_unsignedAttr) {
                    dataWrapper.setSmallInt(1);
                } else {
                    dataWrapper.setSmallInt(0);
                }
                return false;
            }
            case FIXED_PREC_SCALE: {
                dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_fixedPrecScale);
                return false;
            }
            case AUTO_UNIQUE: {
                TypeInfo typeInfo = this.m_dataTypes.get(this.m_currentIndex);
                if (!(TypeUtilities.isApproximateNumericType(typeInfo.m_sqlType) || TypeUtilities.isExactNumericType(typeInfo.m_sqlType) || TypeUtilities.isIntegerType(typeInfo.m_sqlType))) {
                    dataWrapper.setNull(5);
                } else if (-1 == this.m_dataTypes.get((int)this.m_currentIndex).m_autoUnique) {
                    dataWrapper.setNull(5);
                } else {
                    dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_autoUnique);
                }
                return false;
            }
            case LOCAL_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_typeName, dataWrapper, l, l2);
            }
            case MINIMUM_SCALE: {
                TypeInfo typeInfo = this.m_dataTypes.get(this.m_currentIndex);
                if (TypeUtilities.isExactNumericType(typeInfo.m_sqlType) || TypeUtilities.isIntegerType(typeInfo.m_sqlType) || -7 == typeInfo.m_sqlType || 92 == typeInfo.m_sqlType || 93 == typeInfo.m_sqlType) {
                    dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_minScale);
                } else {
                    dataWrapper.setNull(5);
                }
                return false;
            }
            case MAXIMUM_SCALE: {
                TypeInfo typeInfo = this.m_dataTypes.get(this.m_currentIndex);
                if (TypeUtilities.isExactNumericType(typeInfo.m_sqlType) || TypeUtilities.isIntegerType(typeInfo.m_sqlType) || -7 == typeInfo.m_sqlType || 92 == typeInfo.m_sqlType || 93 == typeInfo.m_sqlType) {
                    dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_maxScale);
                } else {
                    dataWrapper.setNull(5);
                }
                return false;
            }
            case SQL_DATA_TYPE: {
                int n = this.m_dataTypes.get((int)this.m_currentIndex).m_sqlType;
                dataWrapper.setSmallInt(TypeUtilities.getVerboseTypeFromConciseType(n));
                return false;
            }
            case SQL_DATETIME_SUB: {
                TypeInfo typeInfo = this.m_dataTypes.get(this.m_currentIndex);
                short s = TypeUtilities.getIntervalCodeFromConciseType(typeInfo.m_sqlType);
                if (0 == s) {
                    dataWrapper.setNull(5);
                } else {
                    dataWrapper.setSmallInt(s);
                }
                return false;
            }
            case NUM_PREC_RADIX: {
                TypeInfo typeInfo = this.m_dataTypes.get(this.m_currentIndex);
                if (TypeUtilities.isApproximateNumericType(typeInfo.m_sqlType)) {
                    dataWrapper.setInteger(2L);
                } else if (TypeUtilities.isExactNumericType(typeInfo.m_sqlType) || TypeUtilities.isIntegerType(typeInfo.m_sqlType)) {
                    dataWrapper.setInteger(10L);
                } else {
                    dataWrapper.setNull(4);
                }
                return false;
            }
            case INTERVAL_PRECISION: {
                dataWrapper.setNull(5);
                return false;
            }
            case USER_DATA_TYPE: {
                dataWrapper.setSmallInt(0);
                return false;
            }
        }
        throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currentIndex + 1 < this.m_dataTypes.size();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_isFetching) {
            ++this.m_currentIndex;
        } else {
            this.m_isFetching = true;
            this.m_currentIndex = 0;
        }
        return this.m_currentIndex < this.m_dataTypes.size();
    }

    private void initializeDataTypes() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        TypeInfo typeInfo = new TypeInfo(-5, "BIGINT", 19);
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        typeInfo.m_unsignedAttr = false;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(16, "BOOLEAN", 1);
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(8, "DOUBLE", 15);
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        typeInfo.m_unsignedAttr = false;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(7, "FLOAT", 7);
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        typeInfo.m_unsignedAttr = false;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(4, "INT", 10);
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        typeInfo.m_unsignedAttr = false;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(5, "SMALLINT", 5);
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        typeInfo.m_unsignedAttr = false;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(12, "STRING", 510);
        typeInfo.m_literalPrefix = "'";
        typeInfo.m_literalSuffix = "'";
        typeInfo.m_createParams = "max length";
        typeInfo.m_caseSensitive = true;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(-6, "TINYINT", 3);
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        typeInfo.m_unsignedAttr = false;
        this.m_dataTypes.add(typeInfo);
        if (this.m_settings.m_platformVersionUtils.supportsTypeBinary(this.m_settings.m_serverVersion)) {
            typeInfo = new TypeInfo(-2, "BINARY", Short.MAX_VALUE);
            typeInfo.m_literalPrefix = "0x";
            typeInfo.m_createParams = "LENGTH";
            typeInfo.m_searchable = Searchable.PREDICATE_NONE;
            this.m_dataTypes.add(typeInfo);
        }
        if (this.m_settings.m_platformVersionUtils.supportsTypeChar(this.m_settings.m_serverVersion)) {
            typeInfo = new TypeInfo(1, "CHAR", 255);
            typeInfo.m_literalPrefix = "'";
            typeInfo.m_literalSuffix = "'";
            typeInfo.m_createParams = "LENGTH";
            typeInfo.m_caseSensitive = true;
            this.m_dataTypes.add(typeInfo);
        }
        if (this.m_settings.m_platformVersionUtils.supportsTypeDate(this.m_settings.m_serverVersion)) {
            typeInfo = new TypeInfo(91, "DATE", 10);
            typeInfo.m_literalPrefix = "'";
            typeInfo.m_literalSuffix = "'";
            this.m_dataTypes.add(typeInfo);
        }
        if (this.m_settings.m_platformVersionUtils.supportsTypeDecimal(this.m_settings.m_serverVersion)) {
            typeInfo = new TypeInfo(3, "DECIMAL", 38);
            typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
            typeInfo.m_unsignedAttr = false;
            this.m_dataTypes.add(typeInfo);
        }
        if (this.m_settings.m_platformVersionUtils.supportSTypeReal(this.m_settings.m_serverVersion)) {
            typeInfo = new TypeInfo(7, "REAL", 7);
            typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
            typeInfo.m_unsignedAttr = false;
            this.m_dataTypes.add(typeInfo);
        }
        if (this.m_settings.m_platformVersionUtils.supportsTypeTimestamp(this.m_settings.m_serverVersion)) {
            typeInfo = new TypeInfo(93, "TIMESTAMP", 29);
            typeInfo.m_literalPrefix = "'";
            typeInfo.m_literalSuffix = "'";
            this.m_dataTypes.add(typeInfo);
        }
        if (this.m_settings.m_platformVersionUtils.supportsTypeVarchar(this.m_settings.m_serverVersion)) {
            typeInfo = new TypeInfo(12, "VARCHAR", 510);
            typeInfo.m_literalPrefix = "'";
            typeInfo.m_literalSuffix = "'";
            typeInfo.m_createParams = "max length";
            typeInfo.m_caseSensitive = true;
            this.m_dataTypes.add(typeInfo);
        }
        if (this.m_settings.m_platformVersionUtils.supportsNestedDataTypes(this.m_settings.m_serverVersion)) {
            typeInfo = new TypeInfo(12, "ARRAY", Short.MAX_VALUE);
            typeInfo.m_literalPrefix = "'";
            typeInfo.m_literalSuffix = "'";
            typeInfo.m_createParams = "Type";
            this.m_dataTypes.add(typeInfo);
            typeInfo = new TypeInfo(12, "MAP", Short.MAX_VALUE);
            typeInfo.m_literalPrefix = "'";
            typeInfo.m_literalSuffix = "'";
            typeInfo.m_createParams = "Key,Value";
            this.m_dataTypes.add(typeInfo);
            typeInfo = new TypeInfo(12, "STRUCT", Short.MAX_VALUE);
            typeInfo.m_literalPrefix = "'";
            typeInfo.m_literalSuffix = "'";
            typeInfo.m_createParams = "Column Type, ...";
            this.m_dataTypes.add(typeInfo);
        }
        if (this.m_settings.m_platformVersionUtils.supportsUnionDataTypes(this.m_settings.m_serverVersion)) {
            typeInfo = new TypeInfo(12, "UNIONTYPE", Short.MAX_VALUE);
            typeInfo.m_literalPrefix = "'";
            typeInfo.m_literalSuffix = "'";
            typeInfo.m_createParams = "Data Type, ...";
            this.m_dataTypes.add(typeInfo);
        }
    }

    private static class TypeInfo {
        public String m_typeName;
        public int m_sqlType;
        public int m_columnSize;
        public String m_literalPrefix;
        public String m_literalSuffix;
        public String m_createParams;
        public Nullable m_nullable;
        public boolean m_caseSensitive;
        public Searchable m_searchable;
        public boolean m_unsignedAttr;
        public short m_fixedPrecScale;
        public short m_autoUnique;
        public short m_minScale;
        public short m_maxScale;

        public TypeInfo(int n, String string, int n2) {
            this.m_sqlType = n;
            this.m_typeName = string;
            this.m_columnSize = n2;
            this.m_literalPrefix = null;
            this.m_literalSuffix = null;
            this.m_createParams = null;
            this.m_nullable = Nullable.NULLABLE;
            this.m_caseSensitive = false;
            this.m_searchable = Searchable.SEARCHABLE;
            this.m_unsignedAttr = true;
            this.m_fixedPrecScale = 0;
            this.m_autoUnique = (short)-1;
            this.m_minScale = 0;
            this.m_maxScale = 0;
        }
    }
}

