/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.api;

import com.cloudera.hivecommon.AuthMech;
import com.cloudera.hivecommon.HiveJDBCSettings;
import com.cloudera.hivecommon.KrbAuthType;
import com.cloudera.hivecommon.TransportMode;
import com.cloudera.hivecommon.api.DelegationToken;
import com.cloudera.hivecommon.api.HS2Client;
import com.cloudera.hivecommon.api.HiveServerPrivilegedAction;
import com.cloudera.hivecommon.api.IHiveClient;
import com.cloudera.hivecommon.api.IHiveClientFactory;
import com.cloudera.hivecommon.api.SaslCallbackHandler;
import com.cloudera.hivecommon.api.TETSSLTransportFactory;
import com.cloudera.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.jdbc.kerberos.Kerberos;
import com.cloudera.jdbc.kerberos.KerberosHttpInterceptor;
import com.cloudera.support.ILogger;
import com.cloudera.support.IMessageSource;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.LogUtilities;
import com.cloudera.support.exceptions.ErrorException;
import java.net.SocketTimeoutException;
import java.util.Locale;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class HiveServer2ClientFactory
implements IHiveClientFactory {
    @Override
    public IHiveClient createClient(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        TTransport tTransport = HiveServer2ClientFactory.createTransport(hiveJDBCSettings, iWarningListener.getMessageSource(), iWarningListener.getLocale(), iLogger);
        return new HS2Client(hiveJDBCSettings, (TProtocol)new TBinaryProtocol(tTransport), iLogger, iWarningListener);
    }

    protected static TTransport createTransport(HiveJDBCSettings hiveJDBCSettings, IMessageSource iMessageSource, Locale locale, ILogger iLogger) throws ErrorException {
        Object object = null;
        TSocket tSocket = null;
        DefaultHttpClient defaultHttpClient = null;
        try {
            Object object2;
            if (TransportMode.HTTP != hiveJDBCSettings.m_transportMode) {
                if (hiveJDBCSettings.m_enableSSL) {
                    object2 = HiveServer2ClientFactory.createTETSSLTransportParams(hiveJDBCSettings);
                    tSocket = TETSSLTransportFactory.getClientSocket(hiveJDBCSettings.m_host, hiveJDBCSettings.m_port, hiveJDBCSettings.m_timeout, (TETSSLTransportFactory.TETSSLTransportParameters)object2);
                } else {
                    tSocket = new TSocket(hiveJDBCSettings.m_host, hiveJDBCSettings.m_port, hiveJDBCSettings.m_timeout);
                }
            } else {
                if (null == hiveJDBCSettings.m_httpPath || 0 == hiveJDBCSettings.m_httpPath.length()) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_HTTP_PATH_ERR.name());
                    throw errorException;
                }
                if (hiveJDBCSettings.m_enableSSL) {
                    object2 = HiveServer2ClientFactory.createTETSSLTransportParams(hiveJDBCSettings);
                    defaultHttpClient = (DefaultHttpClient)TETSSLTransportFactory.getHttpClient(hiveJDBCSettings.m_host, hiveJDBCSettings.m_port, hiveJDBCSettings.m_timeout, (TETSSLTransportFactory.TETSSLTransportParameters)object2);
                } else {
                    defaultHttpClient = new DefaultHttpClient();
                }
            }
            switch (hiveJDBCSettings.m_authMech) {
                case NOAUTH: {
                    object = tSocket;
                    break;
                }
                case DELEGATION_TOKEN: {
                    object2 = null;
                    if (hiveJDBCSettings.m_delegationToken != null) {
                        try {
                            object2 = DelegationToken.decodeToken(hiveJDBCSettings.m_delegationToken);
                        }
                        catch (Exception exception) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATION_TOKEN_DECODE_FAILED.name());
                            errorException.initCause(exception);
                            errorException.loadMessage(iMessageSource, locale);
                            ErrorException errorException2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATION_TOKEN_FAILED.name(), errorException.getMessage());
                            errorException2.initCause(errorException);
                            throw errorException2;
                        }
                        try {
                            object = new TSaslClientTransport("DIGEST-MD5", null, null, "default", null, (CallbackHandler)new SaslCallbackHandler((DelegationToken)object2), (TTransport)tSocket);
                            break;
                        }
                        catch (Exception exception) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATION_TOKEN_FAILED.name(), exception.getMessage());
                            errorException.initCause(exception);
                            throw errorException;
                        }
                    }
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATION_TOKEN_FAILED.name(), "Unable to obtain the token from the connection string");
                    throw errorException;
                }
                case SASL_KERBEROS: {
                    if (KrbAuthType.JAAS == hiveJDBCSettings.m_krbAuthType) {
                        try {
                            object2 = Kerberos.getSubjectViaJAASConfig(iLogger);
                        }
                        catch (LoginException loginException) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_KERBEROS_AUTHENTICATION_ERROR_GET_JAASCONFIGURE.name(), loginException.getMessage());
                            errorException.initCause(loginException);
                            throw errorException;
                        }
                        if (iLogger.isEnabled() && null != object2) {
                            LogUtilities.logDebug("Kerberos subject retrieved via JAAS config", iLogger);
                        }
                    } else if (KrbAuthType.TICKET_CACHE == hiveJDBCSettings.m_krbAuthType) {
                        try {
                            object2 = Kerberos.getSubjectViaTicketCache(iLogger);
                        }
                        catch (LoginException loginException) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_KERBEROS_AUTHENTICATION_ERROR_GET_TICKETCACHE.name(), loginException.getMessage());
                            errorException.initCause(loginException);
                            throw errorException;
                        }
                        if (iLogger.isEnabled() && null != object2) {
                            LogUtilities.logDebug("Kerberos subject retrieved via ticket cache lookup", iLogger);
                        }
                    } else {
                        object2 = Kerberos.getSubjectViaAccessControlContext(iLogger);
                        if (iLogger.isEnabled() && null != object2) {
                            LogUtilities.logDebug("Kerberos subject retrieved via AccessControlContext", iLogger);
                        }
                        if (null == object2) {
                            boolean bl = false;
                            try {
                                object2 = Kerberos.getSubjectViaJAASConfig(iLogger);
                            }
                            catch (LoginException loginException) {
                                LogUtilities.logWarning(loginException, iLogger);
                                bl = true;
                            }
                            if (iLogger.isEnabled() && null != object2) {
                                LogUtilities.logDebug("Kerberos subject retrieved via JAAS config", iLogger);
                            }
                            if (null == object2 || bl) {
                                try {
                                    object2 = Kerberos.getSubjectViaTicketCache(iLogger);
                                }
                                catch (LoginException loginException) {
                                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_KERBEROS_AUTHENTICATION_ERROR_GET_TICKETCACHE.name(), loginException.getMessage());
                                    errorException.initCause(loginException);
                                    throw errorException;
                                }
                                if (iLogger.isEnabled() && null != object2) {
                                    LogUtilities.logDebug("Kerberos subject retrieved via ticket cache lookup", iLogger);
                                }
                            }
                        }
                    }
                    if (null == object2) {
                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SASL_KERSEROS_ERR.name(), "Cannot setup Kerberos authentication");
                        throw errorException;
                    }
                    if (null == hiveJDBCSettings.m_krbServiceName || null == hiveJDBCSettings.m_krbHostFQDN) {
                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SASL_KERSEROS_ERR.name(), "Kerberos service name error");
                        throw errorException;
                    }
                    if (TransportMode.HTTP != hiveJDBCSettings.m_transportMode) {
                        HiveServerPrivilegedAction hiveServerPrivilegedAction = new HiveServerPrivilegedAction(null, tSocket, hiveJDBCSettings.m_krbServiceName, hiveJDBCSettings.m_krbHostFQDN, iMessageSource, locale, hiveJDBCSettings.m_userGSSCredential);
                        Subject.doAs((Subject)object2, hiveServerPrivilegedAction);
                        return hiveServerPrivilegedAction.getTransKerberos();
                    }
                    defaultHttpClient.addRequestInterceptor((HttpRequestInterceptor)new KerberosHttpInterceptor(hiveJDBCSettings.m_krbServiceName, hiveJDBCSettings.m_krbHostFQDN, (Subject)object2));
                    THttpClient tHttpClient = new THttpClient(HiveServer2ClientFactory.getFullHttpPath(hiveJDBCSettings), (HttpClient)defaultHttpClient);
                    object = tHttpClient;
                    break;
                }
                case SASL_PLAIN_UID: {
                    object = new TSaslClientTransport("PLAIN", null, null, null, null, (CallbackHandler)new SaslCallbackHandler(hiveJDBCSettings), (TTransport)tSocket);
                    break;
                }
                case UIDPWD: {
                    if (TransportMode.HTTP == hiveJDBCSettings.m_transportMode) {
                        object2 = new THttpClient(HiveServer2ClientFactory.getFullHttpPath(hiveJDBCSettings), (HttpClient)defaultHttpClient);
                        HiveServer2ClientFactory.addCredentialsToHeader(hiveJDBCSettings, (THttpClient)object2);
                        object = object2;
                        break;
                    }
                    if (TransportMode.BINARY == hiveJDBCSettings.m_transportMode) {
                        object = tSocket;
                        break;
                    }
                    object = new TSaslClientTransport("PLAIN", null, null, null, null, (CallbackHandler)new SaslCallbackHandler(hiveJDBCSettings), (TTransport)tSocket);
                    break;
                }
                default: {
                    object2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CREATE_AUTHENTICATION_TRANSPORT_ERR.name(), "Unexpected authentication mechanism selected!");
                    throw object2;
                }
            }
            if (hiveJDBCSettings.m_transportMode != TransportMode.BINARY || !hiveJDBCSettings.m_enableSSL) {
                object.open();
            }
        }
        catch (Exception exception) {
            if (object != null) {
                object.close();
            }
            if (tSocket != null) {
                tSocket.close();
            }
            if (exception instanceof TTransportException && exception.getCause() != null && exception.getCause() instanceof SocketTimeoutException) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_HS2_CLIENT_SOCKET_ERR.name());
                errorException.initCause(exception);
                throw errorException;
            }
            if (exception instanceof ErrorException) {
                throw (ErrorException)exception;
            }
            if (AuthMech.DELEGATION_TOKEN == hiveJDBCSettings.m_authMech) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATION_TOKEN_FAILED.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
            String string = exception.getMessage();
            if (null == string) {
                string = iMessageSource.loadMessage(locale, 101, HiveJDBCMessageKey.CONN_AUTHENTICATION_FAILED.name());
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CREATE_AUTHENTICATION_TRANSPORT_ERR.name(), string);
            errorException.initCause(exception);
            throw errorException;
        }
        return object;
    }

    private static void addCredentialsToHeader(HiveJDBCSettings hiveJDBCSettings, THttpClient tHttpClient) {
        byte[] byArray = Base64.encodeBase64((byte[])(hiveJDBCSettings.m_username + ":" + hiveJDBCSettings.m_password).getBytes());
        tHttpClient.setCustomHeader("Authorization", "Basic " + new String(byArray));
    }

    private static TETSSLTransportFactory.TETSSLTransportParameters createTETSSLTransportParams(HiveJDBCSettings hiveJDBCSettings) {
        TETSSLTransportFactory.TETSSLTransportParameters tETSSLTransportParameters = new TETSSLTransportFactory.TETSSLTransportParameters();
        if (null != hiveJDBCSettings.m_sslKeyStore) {
            tETSSLTransportParameters.setKeyStore(hiveJDBCSettings.m_sslKeyStore, hiveJDBCSettings.m_sslKeyStorePwd);
        }
        if (null != hiveJDBCSettings.m_sslTrustStore) {
            tETSSLTransportParameters.setTrustStore(hiveJDBCSettings.m_sslTrustStore, hiveJDBCSettings.m_sslTrustStorePwd);
        }
        tETSSLTransportParameters.requireClientAuth(false);
        tETSSLTransportParameters.allowSelfSigned(hiveJDBCSettings.m_allowSelfSigned);
        tETSSLTransportParameters.certNamesMismatch(hiveJDBCSettings.m_certNamesMismatch);
        tETSSLTransportParameters.hostNameInSAN(hiveJDBCSettings.m_hostNameInSAN);
        return tETSSLTransportParameters;
    }

    private static String getFullHttpPath(HiveJDBCSettings hiveJDBCSettings) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(hiveJDBCSettings.m_enableSSL ? "https://" : "http://");
        stringBuilder.append(hiveJDBCSettings.m_host);
        stringBuilder.append(":");
        stringBuilder.append(hiveJDBCSettings.m_port);
        stringBuilder.append(hiveJDBCSettings.m_httpPath.startsWith("/") ? "" : "/");
        stringBuilder.append(hiveJDBCSettings.m_httpPath);
        return stringBuilder.toString();
    }
}

