/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ds.common;

import com.kingbase8.ds.KBConnectionPoolDataSource;
import com.kingbase8.ds.KBPoolingDataSource;
import com.kingbase8.ds.KBSimpleDataSource;
import com.kingbase8.ds.common.BaseDataSource;
import com.kingbase8.util.TraceLogger;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class KBObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object objt, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Reference reference = (Reference)objt;
        String className = reference.getClassName();
        if (className.equals("com.kingbase8.ds.KBSimpleDataSource") || className.equals("com.kingbase8.jdbc2.optional.SimpleDataSource") || className.equals("com.kingbase8.jdbc3.Jdbc3SimpleDataSource")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.loadSimpleDataSource(reference);
        }
        if (className.equals("com.kingbase8.ds.KBConnectionPoolDataSource") || className.equals("com.kingbase8.jdbc2.optional.ConnectionPool") || className.equals("com.kingbase8.jdbc3.Jdbc3ConnectionPool")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.loadConnectionPool(reference);
        }
        if (className.equals("com.kingbase8.ds.KBPoolingDataSource") || className.equals("com.kingbase8.jdbc2.optional.PoolingDataSource") || className.equals("com.kingbase8.jdbc3.Jdbc3PoolingDataSource")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.loadPoolingDataSource(reference);
        }
        return null;
    }

    private Object loadPoolingDataSource(Reference reference) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String name = this.getProperty(reference, "dSName");
        KBPoolingDataSource poolingDataSource = KBPoolingDataSource.getDataSource(name);
        if (poolingDataSource != null) {
            return poolingDataSource;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        poolingDataSource = new KBPoolingDataSource();
        poolingDataSource.setDataSourceName(name);
        this.loadBaseDataSource(poolingDataSource, reference);
        String minString = this.getProperty(reference, "initialConnections");
        if (minString != null) {
            poolingDataSource.setInitialConnections(Integer.parseInt(minString));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String maxString = this.getProperty(reference, "maxConnections");
        if (maxString != null) {
            poolingDataSource.setMaxConnections(Integer.parseInt(maxString));
        }
        return poolingDataSource;
    }

    private Object loadSimpleDataSource(Reference reference) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBSimpleDataSource ds = new KBSimpleDataSource();
        return this.loadBaseDataSource(ds, reference);
    }

    private Object loadConnectionPool(Reference reference) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBConnectionPoolDataSource cp = new KBConnectionPoolDataSource();
        return this.loadBaseDataSource(cp, reference);
    }

    protected Object loadBaseDataSource(BaseDataSource ds, Reference reference) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ds.setFromReference(reference);
        return ds;
    }

    protected String getProperty(Reference reference, String s) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        RefAddr addr = reference.get(s);
        if (addr == null) {
            return null;
        }
        return (String)addr.getContent();
    }
}

