/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ds;

import com.kingbase8.KBConnection;
import com.kingbase8.KBStatement;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class KBPooledConnection
implements PooledConnection {
    private final List<ConnectionEventListener> listeners = new LinkedList<ConnectionEventListener>();
    private Connection _con;
    private ConnectionHandler lastHandler;
    private final boolean _autoCommit;
    private final boolean isXA;
    private static String[] fatalClassesArray = new String[]{"08", "53", "57P01", "57P02", "57P03", "58", "60", "99", "F0", "XX"};

    public KBPooledConnection(Connection _con, boolean _autoCommit, boolean isXA) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._con = _con;
        this._autoCommit = _autoCommit;
        this.isXA = isXA;
    }

    public KBPooledConnection(Connection _con, boolean _autoCommit) {
        this(_con, _autoCommit, false);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener eventListener) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.listeners.remove(eventListener);
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener eventListener) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.listeners.add(eventListener);
    }

    @Override
    public void close() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.lastHandler != null) {
            this.lastHandler.close();
            if (!this._con.isClosed()) {
                if (!this._con.getAutoCommit()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    try {
                        this._con.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._con.close();
        }
        finally {
            this._con = null;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        ConnectionHandler _handler;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._con == null) {
            KSQLException _sqlException = new KSQLException(GT.tr("This PooledConnection has already been closed.", new Object[0]), KSQLState.CONNECTION_DOES_NOT_EXIST);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.fireConnectionFatalError(_sqlException);
            throw _sqlException;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            if (this.lastHandler != null) {
                this.lastHandler.close();
                if (!this._con.getAutoCommit()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    try {
                        this._con.rollback();
                    }
                    catch (SQLException _sqlException) {
                        // empty catch block
                    }
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._con.clearWarnings();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!this.isXA) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._con.setAutoCommit(this._autoCommit);
            }
        }
        catch (SQLException _sqlException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.fireConnectionFatalError(_sqlException);
            throw (SQLException)_sqlException.fillInStackTrace();
        }
        this.lastHandler = _handler = new ConnectionHandler(this._con);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Connection proxyCon = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class, KBConnection.class}, (InvocationHandler)_handler);
        this.lastHandler.setProxy(proxyCon);
        return proxyCon;
    }

    void fireConnectionClosed_() {
        ConnectionEventListener[] local;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ConnectionEvent event = null;
        for (ConnectionEventListener listener : local = this.listeners.toArray(new ConnectionEventListener[0])) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (event == null) {
                event = this.createConnectionEvent(null);
            }
            listener.connectionClosed(event);
        }
    }

    void fireConnectionFatalError(SQLException e) {
        ConnectionEventListener[] local;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ConnectionEvent event = null;
        for (ConnectionEventListener listener : local = this.listeners.toArray(new ConnectionEventListener[0])) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (event == null) {
                event = this.createConnectionEvent(e);
            }
            listener.connectionErrorOccurred(event);
        }
    }

    protected ConnectionEvent createConnectionEvent(SQLException e) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new ConnectionEvent(this, e);
    }

    private static boolean isFatalState(String stateStr) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean v = false;
        if (stateStr == null) {
            v = true;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return v;
        }
        if (stateStr.length() < 2) {
            v = true;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return v;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (String fatalClzz : fatalClassesArray) {
            if (!stateStr.startsWith(fatalClzz)) continue;
            v = true;
            return v;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return v;
    }

    private void fireConnectionError_(SQLException sqlException) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!KBPooledConnection.isFatalState(sqlException.getSQLState())) {
            return;
        }
        this.fireConnectionFatalError(sqlException);
    }

    @Override
    public void addStatementEventListener(StatementEventListener eventListener) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    public void removeStatementEventListener(StatementEventListener eventListener) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private class StatementHandler
    implements InvocationHandler {
        private ConnectionHandler _con;
        private Statement statement;

        StatementHandler(ConnectionHandler _con, Statement statement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._con = _con;
            this.statement = statement;
        }

        @Override
        public Object invoke(Object proxy, Method mtd, Object[] args) throws Throwable {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String mtdName = mtd.getName();
            if (mtd.getDeclaringClass() == Object.class) {
                if (mtdName.equals("toString")) {
                    return "Pooled stmt wrapping physical stmt " + this.statement;
                }
                if (mtdName.equals("hashCode")) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return System.identityHashCode(proxy);
                }
                if (mtdName.equals("equals")) {
                    return proxy == args[0];
                }
                return mtd.invoke((Object)this.statement, args);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (mtdName.equals("isClosed")) {
                return this.statement == null || this.statement.isClosed();
            }
            if (mtdName.equals("close")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.statement == null || this.statement.isClosed()) {
                    return null;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._con = null;
                Statement oldStement = this.statement;
                this.statement = null;
                oldStement.close();
                return null;
            }
            if (this.statement == null || this.statement.isClosed()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Statement has been closed.", new Object[0]), KSQLState.OBJECT_NOT_IN_STATE);
            }
            if (mtdName.equals("getConnection")) {
                return this._con.getProxy();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                return mtd.invoke((Object)this.statement, args);
            }
            catch (InvocationTargetException ite) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Throwable throwablee = ite.getTargetException();
                if (throwablee instanceof SQLException) {
                    KBPooledConnection.this.fireConnectionError_((SQLException)throwablee);
                }
                throw throwablee;
            }
        }
    }

    private class ConnectionHandler
    implements InvocationHandler {
        private Connection connection;
        private Connection proxyConnection;
        private boolean automaticT = false;

        ConnectionHandler(Connection _con) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.connection = _con;
        }

        @Override
        public Object invoke(Object proxy, Method mtd, Object[] args) throws Throwable {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String mtdName = mtd.getName();
            if (mtd.getDeclaringClass() == Object.class) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (mtdName.equals("toString")) {
                    return "Pooled _connection wrapping physical _connection " + this.connection;
                }
                if (mtdName.equals("equals")) {
                    return proxy == args[0];
                }
                if (mtdName.equals("hashCode")) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return System.identityHashCode(proxy);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    return mtd.invoke((Object)this.connection, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (mtdName.equals("isClosed")) {
                return this.connection == null || this.connection.isClosed();
            }
            if (mtdName.equals("close")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.connection == null) {
                    return null;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                SQLException sqlException = null;
                if (!this.connection.isClosed()) {
                    if (!KBPooledConnection.this.isXA && !this.connection.getAutoCommit()) {
                        try {
                            this.connection.rollback();
                        }
                        catch (SQLException e) {
                            sqlException = e;
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    }
                    this.connection.clearWarnings();
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                KBPooledConnection.this.lastHandler = null;
                this.proxyConnection = null;
                this.connection = null;
                KBPooledConnection.this.fireConnectionClosed_();
                if (sqlException != null) {
                    throw sqlException;
                }
                return null;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.connection == null || this.connection.isClosed()) {
                throw new KSQLException(this.automaticT ? GT.tr("Connection has been closed automatically because a new _connection was opened for the same PooledConnection or the PooledConnection has been closed.", new Object[0]) : GT.tr("Connection has been closed.", new Object[0]), KSQLState.CONNECTION_DOES_NOT_EXIST);
            }
            try {
                if (mtdName.equals("createStatement")) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    Statement statement = (Statement)mtd.invoke((Object)this.connection, args);
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Statement.class, KBStatement.class}, (InvocationHandler)new StatementHandler(this, statement));
                }
                if (mtdName.equals("prepareCall")) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    Statement statement = (Statement)mtd.invoke((Object)this.connection, args);
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{CallableStatement.class, KBStatement.class}, (InvocationHandler)new StatementHandler(this, statement));
                }
                if (mtdName.equals("prepareStatement")) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    Statement statement = (Statement)mtd.invoke((Object)this.connection, args);
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{PreparedStatement.class, KBStatement.class}, (InvocationHandler)new StatementHandler(this, statement));
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return mtd.invoke((Object)this.connection, args);
            }
            catch (InvocationTargetException invocationTargetException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SQLException) {
                    KBPooledConnection.this.fireConnectionError_((SQLException)throwable);
                }
                throw throwable;
            }
        }

        void setProxy(Connection proxy) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.proxyConnection = proxy;
        }

        Connection getProxy() {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.proxyConnection;
        }

        public boolean isClosed() {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.connection == null;
        }

        public void close() {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.connection != null) {
                this.automaticT = true;
            }
            this.connection = null;
            this.proxyConnection = null;
        }
    }
}

