/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.dispatcher.sqlParser.sql;

import com.kingbase8.KBProperty;
import com.kingbase8.dispatcher.entity.DispatchConnection;
import com.kingbase8.dispatcher.parser.ParseException;
import com.kingbase8.dispatcher.parser.statement.AbstractStatement;
import com.kingbase8.dispatcher.parser.statement.BeginStatement;
import com.kingbase8.dispatcher.parser.statement.EndStatement;
import com.kingbase8.dispatcher.parser.statement.MasterStatement;
import com.kingbase8.dispatcher.parser.statement.OtherStatement;
import com.kingbase8.dispatcher.parser.statement.SelectStatement;
import com.kingbase8.dispatcher.parser.statement.SetStatement;
import com.kingbase8.dispatcher.parser.statement.Statement;
import com.kingbase8.dispatcher.parser.statement.TransactionStatement;
import com.kingbase8.util.Word;
import java.sql.SQLException;

public class SqlParser {
    private Statement stmt;
    private String commandText = "";
    private String strategyValue;

    public String getStrategyValue() {
        return this.strategyValue;
    }

    public SqlParser(String _sql, String strategyValue) {
        this.commandText = _sql.trim().endsWith(";") ? _sql.trim().substring(0, _sql.trim().length() - 1) : _sql.trim();
        this.strategyValue = strategyValue;
    }

    public Statement doParse(DispatchConnection dispatchConnection) throws ParseException {
        try {
            this.stmt = this.parse(dispatchConnection);
            this.stmt.setCommandText(this.commandText);
            return this.stmt;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public Statement getParsedStatement() {
        return this.stmt;
    }

    public final Statement parse(DispatchConnection dispatchConnection) throws SQLException {
        int _result;
        AbstractStatement stmt = null;
        String blackSqlList = KBProperty.BLACKSQLLIST.get(dispatchConnection.m_pros);
        if (blackSqlList != null) {
            String[] _sqls;
            for (String _sql : _sqls = blackSqlList.split(";")) {
                if (!_sql.equalsIgnoreCase(this.commandText)) continue;
                return new MasterStatement();
            }
        }
        if (this.commandText.toLowerCase().startsWith("begin")) {
            return new BeginStatement();
        }
        if (this.commandText.toLowerCase().startsWith("commit") || this.commandText.toLowerCase().startsWith("rollback") || this.commandText.toLowerCase().startsWith("end")) {
            return new EndStatement();
        }
        if (this.commandText.toLowerCase().startsWith("set") || this.commandText.toLowerCase().startsWith("reset")) {
            return new SetStatement();
        }
        if (this.commandText.toLowerCase().contains("nextval") || this.commandText.toLowerCase().contains("currvalue") || this.commandText.toLowerCase().contains("setvalue") || this.commandText.toLowerCase().contains("lastvalue")) {
            return new OtherStatement();
        }
        stmt = !dispatchConnection.getAutoCommit() ? (dispatchConnection.isHasUpdate() ? new TransactionStatement() : ("2".equals(this.strategyValue) ? ((_result = Word.parsing(this.commandText, dispatchConnection.whiteList, dispatchConnection.blackList, dispatchConnection.masterFunctionList, dispatchConnection.allSendFunctionList, dispatchConnection.tempTables, dispatchConnection.masterKeyword)) == 1 ? new SelectStatement() : (_result == 2 ? new MasterStatement() : (_result == 3 ? new SetStatement() : new OtherStatement()))) : new TransactionStatement())) : ((_result = Word.parsing(this.commandText, dispatchConnection.whiteList, dispatchConnection.blackList, dispatchConnection.masterFunctionList, dispatchConnection.allSendFunctionList, dispatchConnection.tempTables, dispatchConnection.masterKeyword)) == 1 ? new SelectStatement() : (_result == 3 ? new SetStatement() : new OtherStatement()));
        return stmt;
    }
}

