/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core.v3;

import com.kingbase8.core.NativeQuery;
import com.kingbase8.core.ParameterList;
import com.kingbase8.core.v3.SimpleQuery;
import com.kingbase8.core.v3.TypeTransferModeRegistry;
import com.kingbase8.util.TraceLogger;
import java.util.logging.Level;

public class BatchedQuery
extends SimpleQuery {
    private String sqlStr;
    private final int valuesBraceOpenPos;
    private final int valuesBraceClosePos;
    private final int batchSizeT;
    private BatchedQuery[] blocksT;

    public BatchedQuery(NativeQuery query, TypeTransferModeRegistry transferModeRegistry, int valuesBraceOpenPosition, int valuesBraceClosePosition, boolean sanitiserDisabled) {
        super(query, transferModeRegistry, sanitiserDisabled);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.valuesBraceOpenPos = valuesBraceOpenPosition;
        this.valuesBraceClosePos = valuesBraceClosePosition;
        this.batchSizeT = 1;
    }

    private BatchedQuery(BatchedQuery batchedQuery, int batchSize) {
        super(batchedQuery);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.valuesBraceOpenPos = batchedQuery.valuesBraceOpenPos;
        this.valuesBraceClosePos = batchedQuery.valuesBraceClosePos;
        this.batchSizeT = batchSize;
    }

    public BatchedQuery deriveForMultiBatch(int valueBlockT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.getBatchSize() != 1) {
            throw new IllegalStateException("Only the original decorator can be derived.");
        }
        if (valueBlockT == 1) {
            return this;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int indexT = Integer.numberOfTrailingZeros(valueBlockT) - 1;
        if (valueBlockT > 128 || valueBlockT != 1 << indexT + 1) {
            throw new IllegalArgumentException("Expected _value block should be a power of 2 smaller or equal to 128. Actual block is " + valueBlockT);
        }
        if (this.blocksT == null) {
            this.blocksT = new BatchedQuery[7];
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        BatchedQuery batchedQueryT = this.blocksT[indexT];
        if (batchedQueryT == null) {
            this.blocksT[indexT] = batchedQueryT = new BatchedQuery(this, valueBlockT);
        }
        return batchedQueryT;
    }

    @Override
    public int getBatchSize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.batchSizeT;
    }

    @Override
    public String getNativeSql() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.sqlStr != null) {
            return this.sqlStr;
        }
        this.sqlStr = this.buildNativeSql(null);
        return this.sqlStr;
    }

    private String buildNativeSql(ParameterList parameterList) {
        int positionT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String sqlStr = null;
        String nativeSqlStr = super.getNativeSql();
        int batchSizeT = this.getBatchSize();
        if (batchSizeT < 2) {
            sqlStr = nativeSqlStr;
            return sqlStr;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (nativeSqlStr == null) {
            sqlStr = "";
            return sqlStr;
        }
        int valuesBlockCharCountT = 0;
        int[] bindPositionsT = this.getNativeQuery()._bindPositions;
        int[] chrunkStartT = new int[1 + bindPositionsT.length];
        int[] chrunkEndT = new int[1 + bindPositionsT.length];
        chrunkStartT[0] = this.valuesBraceOpenPos;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (bindPositionsT.length == 0) {
            valuesBlockCharCountT = this.valuesBraceClosePos - this.valuesBraceOpenPos + 1;
            chrunkEndT[0] = this.valuesBraceClosePos + 1;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            chrunkEndT[0] = bindPositionsT[0];
            valuesBlockCharCountT += chrunkEndT[0] - chrunkStartT[0];
            for (int i = 0; i < bindPositionsT.length; ++i) {
                int startIndexT;
                int endIndexT;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int n = endIndexT = i < bindPositionsT.length - 1 ? bindPositionsT[i + 1] : this.valuesBraceClosePos + 1;
                for (startIndexT = bindPositionsT[i] + 2; startIndexT < endIndexT && Character.isDigit(nativeSqlStr.charAt(startIndexT)); ++startIndexT) {
                }
                chrunkStartT[i + 1] = startIndexT;
                chrunkEndT[i + 1] = endIndexT;
                valuesBlockCharCountT += chrunkEndT[i + 1] - chrunkStartT[i + 1];
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int lengthT = nativeSqlStr.length();
        lengthT += NativeQuery.calculateBindLength(bindPositionsT.length * batchSizeT);
        lengthT -= NativeQuery.calculateBindLength(bindPositionsT.length);
        StringBuilder stringBuilder = new StringBuilder(lengthT += (valuesBlockCharCountT + 1) * (batchSizeT - 1));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (bindPositionsT.length > 0 && parameterList == null) {
            stringBuilder.append(nativeSqlStr, 0, this.valuesBraceClosePos + 1);
            positionT = bindPositionsT.length + 1;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            positionT = 1;
            ++batchSizeT;
            stringBuilder.append(nativeSqlStr, 0, this.valuesBraceOpenPos);
        }
        for (int i = 2; i <= batchSizeT; ++i) {
            if (i > 2 || positionT != 1) {
                stringBuilder.append(',');
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            stringBuilder.append(nativeSqlStr, chrunkStartT[0], chrunkEndT[0]);
            for (int j = 1; j < chrunkStartT.length; ++j) {
                if (parameterList == null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    NativeQuery.appendBindName(stringBuilder, positionT++);
                } else {
                    stringBuilder.append(parameterList.toString(positionT++, true));
                }
                stringBuilder.append(nativeSqlStr, chrunkStartT[j], chrunkEndT[j]);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append(nativeSqlStr, this.valuesBraceClosePos + 1, nativeSqlStr.length());
        sqlStr = stringBuilder.toString();
        assert (parameterList != null || stringBuilder.length() == lengthT) : "Predicted length != actual: " + lengthT + " !=" + stringBuilder.length();
        return sqlStr;
    }

    @Override
    public String toString(ParameterList parameterList) {
        if (this.getBatchSize() < 2) {
            return super.toString(parameterList);
        }
        return this.buildNativeSql(parameterList);
    }
}

