/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.ReflectUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public final class StringUtil {
    public static final String EMPTY = "";
    public static final String LINE_SEPARATOR;
    public static final String LINUX_LINE_SEPARATOR = "\n";
    public static final String INVISIBLE_USERNAME = "\u2026\u2026";
    public static final String[] strYN;
    private static SecretKey[] secretKey;

    static {
        String[] stringArray;
        LINE_SEPARATOR = System.getProperty("line.separator");
        if (Locale.getDefault().equals(Locale.CHINA)) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "\u662f";
            stringArray = stringArray2;
            stringArray2[1] = "\u5426";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "Yes";
            stringArray = stringArray3;
            stringArray3[1] = "No";
        }
        strYN = stringArray;
        secretKey = null;
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String rightTrim(String str) {
        if (str == null) {
            return null;
        }
        return ("r" + str).trim().substring(1);
    }

    public static String trimToEmpty(Object obj) {
        if (obj instanceof String) {
            return StringUtil.trimToEmpty((String)obj);
        }
        return obj == null ? EMPTY : obj.toString();
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static String[] trimToEmpty(String[] strs) {
        if (strs == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < strs.length) {
            strs[i2] = StringUtil.trimToEmpty(strs[i2]);
            ++i2;
        }
        return strs;
    }

    public static String trimDeep(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        char[] cArray = str.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = cArray[n3];
            if (c2 != ' ') {
                sb.append(c2);
            }
            ++n3;
        }
        return sb.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static String substringBetween(String str, String open, String close) {
        if (str == null) {
            return EMPTY;
        }
        int iopen = -1;
        if (StringUtil.isNotEmpty(open)) {
            iopen = str.indexOf(open);
        }
        int iclose = -1;
        if (StringUtil.isNotEmpty(close)) {
            iclose = str.lastIndexOf(close);
        }
        if (iopen == -1) {
            return iclose == -1 ? EMPTY : str.substring(0, iclose);
        }
        return iclose == -1 ? str.substring(iopen + open.length()) : str.substring(iopen + open.length(), iclose);
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static boolean isDigit(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        int sz = str.length();
        int i2 = 0;
        while (i2 < sz) {
            if (!Character.isDigit(str.charAt(i2))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static boolean isNumerical(String str) {
        int begin = 0;
        boolean once = true;
        if (StringUtil.isEmpty(str = StringUtil.trimToEmpty(str))) {
            return false;
        }
        if (str.startsWith("+") || str.startsWith("-")) {
            if (str.length() == 1) {
                return false;
            }
            begin = 1;
        }
        int i2 = begin;
        while (i2 < str.length()) {
            if (!Character.isDigit(str.charAt(i2))) {
                if (str.charAt(i2) == '.' && once) {
                    once = false;
                } else {
                    return false;
                }
            }
            ++i2;
        }
        return str.length() != begin + 1 || once;
    }

    public static boolean isInteger(String str) {
        try {
            Integer.valueOf(str);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isLong(String str) {
        try {
            Long.valueOf(str);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDouble(String str) {
        try {
            Double.valueOf(str);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String join(Object[] array) {
        return StringUtil.join(array, null);
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        int arraySize = array.length;
        int bufSize = arraySize == 0 ? 0 : ((array[0] == null ? 16 : array[0].toString().length()) + separator.length()) * arraySize;
        StringBuilder buf = new StringBuilder(bufSize);
        int i2 = 0;
        while (i2 < arraySize) {
            if (i2 > 0) {
                buf.append(separator);
            }
            if (array[i2] != null) {
                buf.append(array[i2]);
            }
            ++i2;
        }
        return buf.toString();
    }

    public static String join(Object str, int count, String separator) {
        if (str == null) {
            return null;
        }
        int bufSize = count == 0 ? 0 : (str.toString().length() + separator.length()) * count;
        StringBuilder buf = new StringBuilder(bufSize);
        int i2 = 0;
        while (i2 < count) {
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(str);
            ++i2;
        }
        return buf.toString();
    }

    public static String replace(String text, String repl, String with, int maximum) {
        int max = maximum;
        if (text == null || StringUtil.isEmpty(repl) || with == null || max == 0) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max == 0) break;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String replaceAll(String text, String regex, String replacement, boolean caseSensitive) {
        Pattern pattern = !caseSensitive ? Pattern.compile(regex, 2) : Pattern.compile(regex);
        return pattern.matcher(text).replaceAll(replacement);
    }

    public static String replaceAllToUpperCase(String text, String regex, boolean caseSensitive) {
        Pattern pattern = !caseSensitive ? Pattern.compile(regex, 2) : Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        StringBuffer sb = new StringBuffer();
        int lastEndIndex = 0;
        while (matcher.find()) {
            sb.append(text.substring(lastEndIndex, matcher.start()));
            sb.append(matcher.group().toUpperCase());
            lastEndIndex = matcher.end();
        }
        sb.append(text.substring(lastEndIndex));
        return sb.toString();
    }

    public static boolean isValidIP(String ip) {
        if ("localhost".equalsIgnoreCase(ip)) {
            return true;
        }
        String regEx = "((1[0-9]{1,2}|2([0-4][0-9]|5[0-5])|[0-9\\*]{1,2})\\.(1[0-9]{1,2}|2([0-4][0-9]|5[0-5])|[0-9\\*]{1,2})\\.(1[0-9]{1,2}|2([0-4][0-9]|5[0-5])|[0-9\\*]{1,2})\\.([1][0-9]{1,2}|2([0-4][0-9]|5[0-5])|[0-9\\*]{1,2}))";
        Pattern p2 = Pattern.compile(regEx);
        Matcher m2 = p2.matcher(ip);
        if (m2.find()) {
            return m2.group().length() == ip.length();
        }
        return false;
    }

    public static boolean isValidMac(String mac) {
        Pattern macPattern = Pattern.compile("([0-9A-Fa-f]{2})(-[0-9A-Fa-f]{2}){5}");
        return macPattern.matcher(mac).matches();
    }

    public static boolean isValidEmail(String email) {
        Pattern pattern = Pattern.compile("^[A-Z0-9a-z._%+-]+@(([A-Z0-9a-z._]+\\.[A-Za-z]{2,})|(([0-9]{1,3}\\.){3}[0-9]{1,3}))$");
        return pattern.matcher(email).matches();
    }

    public static final String bytesToHexString(byte[] bs) {
        return StringUtil.bytesToHexString(bs, false);
    }

    public static final String bytesToHexString(byte[] bs, boolean pre) {
        if (bs == null) {
            return null;
        }
        if (bs.length == 0) {
            return EMPTY;
        }
        String hexDigits = "0123456789ABCDEF";
        StringBuilder ret = new StringBuilder(bs.length * 2);
        byte[] byArray = bs;
        int n2 = bs.length;
        int n3 = 0;
        while (n3 < n2) {
            byte b2 = byArray[n3];
            ret.append(hexDigits.charAt(0xF & b2 >> 4));
            ret.append(hexDigits.charAt(0xF & b2));
            ++n3;
        }
        if (pre) {
            return "0x" + ret.toString();
        }
        return ret.toString();
    }

    public static final byte[] hexStringToBytes(String s2) {
        int i2;
        char[] bsChr;
        String str = s2;
        if (str == null) {
            return null;
        }
        byte[] bs = new byte[]{};
        boolean flag = false;
        if ((str = str.trim()).indexOf("0x") == 0 || str.indexOf("0X") == 0) {
            str = str.substring(2, str.length());
        }
        if (str.length() == 0) {
            return bs;
        }
        char[] chr = str.toCharArray();
        int len = chr.length;
        if (len % 2 == 0) {
            bsChr = chr;
        } else {
            bsChr = new char[++len];
            bsChr[0] = 48;
            i2 = 0;
            while (i2 < len - 1) {
                bsChr[i2 + 1] = chr[i2];
                ++i2;
            }
        }
        bs = new byte[len / 2];
        int pos = 0;
        i2 = 0;
        while (i2 < bsChr.length) {
            byte bt = StringUtil.convertHex(bsChr[i2]);
            byte bt2 = StringUtil.convertHex(bsChr[i2 + 1]);
            if (bt == -1 || bt2 == -1) {
                flag = true;
                break;
            }
            bs[pos++] = (byte)(bt * 16 + bt2);
            i2 += 2;
        }
        if (flag) {
            bs = str.getBytes();
        }
        return bs;
    }

    private static byte convertHex(char chr) {
        byte us;
        if (chr >= '0' && chr <= '9') {
            us = (byte)(chr - 48);
        } else if (chr >= 'a' && chr <= 'f') {
            us = (byte)(chr - 97 + 10);
        } else if (chr >= 'A' && chr <= 'F') {
            us = (byte)(chr - 65 + 10);
        } else {
            return -1;
        }
        return us;
    }

    public static String md5(String s2) {
        try {
            byte[] strTemp = s2.getBytes();
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(strTemp);
            byte[] md = mdTemp.digest();
            return StringUtil.bytesToHexString(md);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encrypt(String str) {
        if (str == null) {
            return null;
        }
        try {
            byte[] abyte0 = str.getBytes();
            byte[] abyte1 = str.getBytes();
            int i2 = abyte1.length / 8;
            int j2 = 8 - (abyte1.length - i2 * 8);
            abyte1 = new byte[abyte1.length + j2];
            System.arraycopy(abyte0, 0, abyte1, 0, abyte0.length);
            int k2 = j2;
            while (k2 > 0) {
                abyte1[abyte1.length - k2] = 0;
                --k2;
            }
            byte[] encryptedData = StringUtil.getValue(1, abyte1);
            return StringUtil.bytesToHexString(encryptedData).trim();
        }
        catch (Exception e2) {
            DBError.throwRuntimeException("encrypt error", e2);
            return str;
        }
    }

    public static String decrypt(String str) {
        if (StringUtil.isEmpty(str)) {
            return EMPTY;
        }
        try {
            byte[] decryptedClassData = StringUtil.getValue(2, StringUtil.hexStringToBytes(str));
            return new String(decryptedClassData).trim();
        }
        catch (Exception e2) {
            DBError.throwRuntimeException("decrypt error", e2);
            return str;
        }
    }

    private static SecretKey[] getSecretKey() throws Exception {
        SecretKey[] secretKey = new SecretKey[3];
        byte[] rawKeyData1 = new byte[8];
        byte[] rawKeyData2 = new byte[8];
        byte[] rawKeyData3 = new byte[8];
        byte[] rawKeyData = new byte[]{123, 125, 124, 43, 95, 41, 40, 42, 38, 94, 37, 36, 35, 64, 33, 126, 113, 119, 101, 114, 116, 121, 117, 105, 111, 112, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48};
        System.arraycopy(rawKeyData, 0, rawKeyData1, 0, 8);
        System.arraycopy(rawKeyData, 8, rawKeyData2, 0, 8);
        System.arraycopy(rawKeyData, 16, rawKeyData3, 0, 8);
        DESKeySpec dks1 = new DESKeySpec(rawKeyData1);
        DESKeySpec dks2 = new DESKeySpec(rawKeyData2);
        DESKeySpec dks3 = new DESKeySpec(rawKeyData3);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        secretKey[0] = keyFactory.generateSecret(dks1);
        secretKey[1] = keyFactory.generateSecret(dks2);
        secretKey[2] = keyFactory.generateSecret(dks3);
        return secretKey;
    }

    private static byte[] getValue(int mode, byte[] data) throws Exception {
        if (secretKey == null) {
            secretKey = StringUtil.getSecretKey();
        }
        Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
        byte[] newData = new byte[data.length];
        if (mode == 1) {
            cipher.init(mode, secretKey[0]);
            cipher.doFinal(data, 0, data.length, newData);
            cipher.init(mode, secretKey[1]);
            cipher.doFinal(newData, 0, newData.length, data);
            cipher.init(mode, secretKey[2]);
            cipher.doFinal(data, 0, data.length, newData);
        } else {
            cipher.init(mode, secretKey[2]);
            cipher.doFinal(data, 0, data.length, newData);
            cipher.init(mode, secretKey[1]);
            cipher.doFinal(newData, 0, newData.length, data);
            cipher.init(mode, secretKey[0]);
            cipher.doFinal(data, 0, data.length, newData);
        }
        return newData;
    }

    public static String toChineseString(String s2) {
        byte[] bs = s2.getBytes();
        byte[] newbs = new byte[bs.length];
        int idx = 0;
        int i2 = 0;
        while (i2 < bs.length) {
            if (bs[i2] == 37) {
                newbs[idx] = (byte)(StringUtil.getIdx(bs[i2 + 1]) * 16 + StringUtil.getIdx(bs[i2 + 2]));
                i2 += 2;
            } else {
                newbs[idx] = bs[i2];
            }
            ++idx;
            ++i2;
        }
        byte[] utf8Bytes = new byte[idx];
        System.arraycopy(newbs, 0, utf8Bytes, 0, idx);
        try {
            return new String(utf8Bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return s2;
        }
    }

    private static byte getIdx(byte b2) {
        byte[] hexDigits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 97, 98, 99, 100, 101, 102};
        int i2 = 0;
        while (i2 < 16) {
            if (b2 == hexDigits[i2]) {
                return (byte)i2;
            }
            ++i2;
        }
        while (i2 < 22) {
            if (b2 == hexDigits[i2]) {
                return (byte)(i2 - 6);
            }
            ++i2;
        }
        return -1;
    }

    public static boolean startWithIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.toUpperCase().startsWith(str2.toUpperCase());
    }

    public static boolean containsIgnoreCase(String str1, String str2) {
        return str1.toUpperCase().contains(str2.toUpperCase());
    }

    public static String formatCharset(String s2, String srcCharset, String desCharset) throws UnsupportedEncodingException {
        String charset = null;
        if (srcCharset.equalsIgnoreCase("cp850")) {
            charset = "iso-8859-1";
            return new String(s2.getBytes(charset), desCharset);
        }
        return s2;
    }

    public static String formatString(String format, Object ... args) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        formatter.format(format, args);
        formatter.close();
        return sb.toString();
    }

    public static int ipToInt(String ip) {
        String[] splits = ip.split("\\.");
        return (Integer.valueOf(splits[0]) << 24) + (Integer.valueOf(splits[1]) << 16) + (Integer.valueOf(splits[2]) << 8) + Integer.valueOf(splits[3]);
    }

    public static String intToIp(int ip) {
        StringBuilder ipStr = new StringBuilder();
        ipStr.append(ip >> 24 & 0xFF);
        ipStr.append(".");
        ipStr.append(ip >> 16 & 0xFF);
        ipStr.append(".");
        ipStr.append(ip >> 8 & 0xFF);
        ipStr.append(".");
        ipStr.append(ip & 0xFF);
        return ipStr.toString();
    }

    public static String toPersent(double radio) {
        String radioStr = new Double(radio *= 100.0).toString();
        if (radioStr.length() > 6) {
            radioStr = radioStr.substring(0, 6);
        }
        return String.valueOf(radioStr) + "%";
    }

    public static String upperFirstChar(String str) {
        char firstChar = str.charAt(0);
        if (firstChar > '`' && firstChar < '{') {
            char[] strChars = str.toCharArray();
            strChars[0] = (char)(firstChar - 32);
            str = new String(strChars);
        }
        return str;
    }

    private static int compareVersion(String version1, String version2) {
        version1 = version1.replace("V", EMPTY).replace("v", EMPTY);
        version2 = version2.replace("V", EMPTY).replace("v", EMPTY);
        String[] version1Arr = version1.split("\\.");
        String[] version2Arr = version2.split("\\.");
        if (version1Arr.length == 0) {
            return -1;
        }
        int i2 = 0;
        while (i2 < version1Arr.length) {
            int version2Int;
            if (i2 == version2Arr.length) {
                return 1;
            }
            int version1Int = Integer.valueOf(version1Arr[i2]);
            if (version1Int > (version2Int = Integer.valueOf(version2Arr[i2]).intValue())) {
                return 1;
            }
            if (version1Int < version2Int) {
                return -1;
            }
            ++i2;
        }
        if (version1Arr.length < version2Arr.length) {
            return -1;
        }
        return 0;
    }

    public static boolean isLastVersion(String version1, String version2) {
        return StringUtil.compareVersion(version1, version2) >= 0;
    }

    /*
     * Unable to fully structure code
     */
    public static String getAlignNumString(int num, int maxNum) {
        sb = new StringBuilder();
        if (num < maxNum && num >= 0) ** GOTO lbl12
        return String.valueOf(num);
lbl-1000:
        // 1 sources

        {
            maxNum /= 10;
            if (num >= 1) {
                sb.append(num % 10);
                num /= 10;
                continue;
            }
            sb.append("0");
lbl12:
            // 3 sources

            ** while (maxNum >= 1)
        }
lbl13:
        // 1 sources

        return sb.reverse().toString();
    }

    public static boolean isValidTimeZone(String timeZoneStr) {
        int minute;
        int hour;
        char flagChar;
        block9: {
            String minuteStr;
            block8: {
                if (StringUtil.isEmpty(timeZoneStr)) {
                    return false;
                }
                if (timeZoneStr.length() != 6) {
                    return false;
                }
                flagChar = timeZoneStr.charAt(0);
                if (flagChar != '+' && flagChar != '-') {
                    return false;
                }
                char fgChar = timeZoneStr.charAt(3);
                if (fgChar != ':') {
                    return false;
                }
                String hourStr = timeZoneStr.substring(1, 3);
                minuteStr = timeZoneStr.substring(4, 6);
                try {
                    hour = Integer.parseInt(hourStr);
                    if (hour >= 0 && hour <= 14) break block8;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            minute = Integer.parseInt(minuteStr);
            if (minute >= 0 && minute <= 60) break block9;
            return false;
        }
        int flagInt = Integer.parseInt((flagChar == '+' ? EMPTY : "-") + (hour * 60 + minute));
        return flagInt <= 840 && flagInt >= -779;
    }

    /*
     * Unable to fully structure code
     */
    public static String removeEndSeparatorOfPath(String path, boolean isWin) {
        pathLength = path.length();
        if (isWin && pathLength == 3) {
            return path;
        }
        if (isWin || pathLength != 1) ** GOTO lbl8
        return path;
lbl-1000:
        // 1 sources

        {
            path = path.substring(0, path.length() - 1);
            pathLength = path.length();
lbl8:
            // 2 sources

            ** while (isWin && path.charAt((int)(pathLength - 1)) == '\\' || path.charAt((int)(pathLength - 1)) == '/')
        }
lbl9:
        // 1 sources

        return path;
    }

    public static String addEndSeparatorOfPath(String path, boolean isWin) {
        int pathLength = path.length();
        if (isWin && path.charAt(pathLength - 1) == '\\' || path.charAt(pathLength - 1) == '/') {
            return path;
        }
        path = String.valueOf(path) + (isWin ? "\\" : "/");
        return path;
    }

    public static String processDoubleQuoteOfName(String name) {
        return StringUtil.processQuoteOfName(name, "\"");
    }

    public static String processDoubleQuoteOfNameForLink(String name) {
        StringBuilder fullName = new StringBuilder();
        fullName.append("\"");
        fullName.append(StringUtil.processDoubleQuoteOfName(name));
        fullName.append("\"");
        return fullName.toString();
    }

    public static String processSingleQuoteOfName(String name) {
        return StringUtil.processQuoteOfName(name, "'");
    }

    public static String processQuoteOfName(String name, String quote) {
        if (StringUtil.isEmpty(quote) || name == null) {
            return name;
        }
        String temp = name;
        StringBuilder result = new StringBuilder();
        int index = -1;
        int quetoLength = quote.length();
        while ((index = temp.indexOf(quote)) != -1) {
            result.append(temp.substring(0, index + quetoLength)).append(quote);
            temp = temp.substring(index + quetoLength);
        }
        result.append(temp);
        return result.toString();
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return String.valueOf(obj);
    }

    public static boolean checkPwdComplexity(String pwdStr) {
        char[] pwdCharArray;
        boolean hasNum = false;
        boolean hasUpperChar = false;
        boolean hasLowerChar = false;
        boolean hasSpecialChar = false;
        if (pwdStr == null || pwdStr.length() == 0) {
            return false;
        }
        char[] cArray = pwdCharArray = pwdStr.toCharArray();
        int n2 = pwdCharArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char pwdChar = cArray[n3];
            if (pwdChar >= '#' && pwdChar <= '~' || pwdChar == '!') {
                if (pwdChar >= 'a' && pwdChar <= 'z') {
                    hasLowerChar = true;
                } else if (pwdChar >= 'A' && pwdChar <= 'Z') {
                    hasUpperChar = true;
                } else if (pwdChar >= '0' && pwdChar <= '9') {
                    hasNum = true;
                } else {
                    hasSpecialChar = true;
                }
            }
            if (hasNum && hasUpperChar && hasLowerChar && hasSpecialChar) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static boolean checkPwdPolicy(List<String> loginNameList, String pwd, int pwdPolicy, int pwdMinLen, int pwdMaxLen) {
        int len = pwd == null ? 0 : pwd.length();
        boolean flag3 = false;
        boolean flag4 = false;
        boolean flag5 = false;
        if (len > pwdMaxLen) {
            return false;
        }
        if (pwdPolicy == 0) {
            return true;
        }
        if ((pwdPolicy & 1) != 0 && loginNameList.contains(pwd.toUpperCase())) {
            return false;
        }
        if ((pwdPolicy & 2) != 0 && len < pwdMinLen) {
            return false;
        }
        char[] pwdCharArr = pwd.toCharArray();
        int i2 = 0;
        while (i2 < pwdCharArr.length) {
            char tmpChar = pwdCharArr[i2];
            if (tmpChar < 'a' || tmpChar > 'z') {
                if (tmpChar >= 'A' && tmpChar <= 'Z') {
                    flag3 = true;
                } else if (tmpChar >= '0' && tmpChar <= '9') {
                    flag4 = true;
                } else if (tmpChar == '~' || tmpChar == '!' || tmpChar == '@' || tmpChar == '#' || tmpChar == '$' || tmpChar == '%' || tmpChar == '^' || tmpChar == '&' || tmpChar == '*' || tmpChar == '(' || tmpChar == ')' || tmpChar == '_' || tmpChar == '+' || tmpChar == '|' || tmpChar == '`' || tmpChar == '-' || tmpChar == '=' || tmpChar == '\\' || tmpChar == '{' || tmpChar == '}' || tmpChar == '[' || tmpChar == ']' || tmpChar == ':' || tmpChar == ';' || tmpChar == '\'' || tmpChar == '<' || tmpChar == '>' || tmpChar == '?' || tmpChar == ',' || tmpChar == '.' || tmpChar == '/') {
                    flag5 = true;
                }
            }
            ++i2;
        }
        if ((pwdPolicy & 4) != 0 && !flag3) {
            return false;
        }
        if ((pwdPolicy & 8) != 0 && !flag4) {
            return false;
        }
        return (pwdPolicy & 0x10) == 0 || flag5;
    }

    private static int min(int one, int two, int three) {
        int min = one;
        if (two < min) {
            min = two;
        }
        if (three < min) {
            min = three;
        }
        return min;
    }

    public static int ld(String str1, String str2) {
        int n2 = str1.length();
        int m2 = str2.length();
        if (n2 == 0) {
            return m2;
        }
        if (m2 == 0) {
            return n2;
        }
        int[][] d2 = new int[n2 + 1][m2 + 1];
        int i2 = 0;
        while (i2 <= n2) {
            d2[i2][0] = i2;
            ++i2;
        }
        int j2 = 0;
        while (j2 <= m2) {
            d2[0][j2] = j2;
            ++j2;
        }
        i2 = 1;
        while (i2 <= n2) {
            char ch1 = str1.charAt(i2 - 1);
            j2 = 1;
            while (j2 <= m2) {
                char ch2 = str2.charAt(j2 - 1);
                int temp = ch1 == ch2 ? 0 : 1;
                d2[i2][j2] = StringUtil.min(d2[i2 - 1][j2] + 1, d2[i2][j2 - 1] + 1, d2[i2 - 1][j2 - 1] + temp);
                ++j2;
            }
            ++i2;
        }
        return d2[n2][m2];
    }

    public static double sim(String str1, String str2) {
        int ld = StringUtil.ld(str1, str2);
        return 1.0 - (double)ld / (double)Math.max(str1.length(), str2.length());
    }

    public static String format2Table(List<Map> objList, String[] titles, String[] fields, int maxColLen, boolean showAll) {
        int i2;
        int i3;
        if (objList == null || fields == null) {
            return EMPTY;
        }
        int colLen = 0;
        String colVal = null;
        int[] colLens = null;
        if (titles != null) {
            colLens = new int[titles.length];
            i3 = 0;
            while (i3 < titles.length) {
                colLens[i3] = titles[i3].length();
                ++i3;
            }
        } else {
            colLens = new int[fields.length];
            i3 = 0;
            while (i3 < fields.length) {
                colLens[i3] = fields[i3].length();
                ++i3;
            }
        }
        for (Map obj : objList) {
            i2 = 0;
            while (i2 < fields.length) {
                Object tobj = obj.get(fields[i2]);
                colVal = tobj == null ? "null" : tobj.toString();
                colLen = colVal.length();
                if (colLen > colLens[i2]) {
                    colLens[i2] = colLen;
                }
                ++i2;
            }
        }
        int i4 = 0;
        while (i4 < fields.length) {
            if (maxColLen > 0 && colLens[i4] > maxColLen) {
                colLens[i4] = maxColLen;
            }
            ++i4;
        }
        StringBuilder output = new StringBuilder();
        if (titles != null) {
            HashMap<String, String> titleMap = new HashMap<String, String>(titles.length);
            i2 = 0;
            while (i2 < titles.length) {
                titleMap.put(fields[i2], titles[i2]);
                ++i2;
            }
            objList.add(0, titleMap);
        }
        StringUtil.sepLine(output, colLens);
        for (Map obj : objList) {
            StringUtil.formateLine(output, obj, fields, colLens, showAll);
            StringUtil.sepLine(output, colLens);
        }
        return output.toString();
    }

    private static void formateLine(StringBuilder output, Map obj, String[] fields, int[] colLens, boolean showAll) {
        boolean hasMore = false;
        int colLen = 0;
        String colVal = null;
        int i2 = 0;
        while (i2 < fields.length) {
            Object tobj = obj.get(fields[i2]);
            if (tobj == null) {
                colVal = "null";
            } else {
                colVal = tobj.toString();
                colVal.replace('\t', ' ');
                colVal.replace('\n', ' ');
                colVal.replace('\r', ' ');
            }
            colLen = colVal.length();
            if (colLen <= colLens[i2]) {
                output.append('|');
                output.append(colVal);
                StringUtil.blanks(output, colLens[i2] - colLen);
                if (showAll) {
                    obj.put(fields[i2], EMPTY);
                }
            } else {
                output.append('|');
                if (showAll) {
                    output.append(colVal.substring(0, colLens[i2]));
                    obj.put(fields[i2], colVal.substring(colLens[i2]));
                    hasMore = true;
                } else {
                    output.append(String.valueOf(colVal.substring(0, colLens[i2] - 3)) + "...");
                }
            }
            ++i2;
        }
        output.append('|');
        output.append('\n');
        if (hasMore) {
            StringUtil.formateLine(output, obj, fields, colLens, showAll);
        }
    }

    private static void sepLine(StringBuilder output, int[] colLens) {
        output.append('+');
        int[] nArray = colLens;
        int n2 = colLens.length;
        int n3 = 0;
        while (n3 < n2) {
            int colLen = nArray[n3];
            int i2 = 0;
            while (i2 < colLen) {
                output.append('-');
                ++i2;
            }
            output.append('+');
            ++n3;
        }
        output.append('\n');
    }

    private static void blanks(StringBuilder output, int count) {
        while (count > 0) {
            output.append(' ');
            --count;
        }
    }

    public static long parseDBSvnNumber(String svrStr) {
        long currentSvr = 0L;
        if (StringUtil.isEmpty(svrStr)) {
            currentSvr = 0L;
        } else if (svrStr.contains("-Build(")) {
            if (svrStr.lastIndexOf("(") < 0 || svrStr.lastIndexOf(")") < 0) {
                return currentSvr;
            }
            if ((svrStr = svrStr.substring(svrStr.lastIndexOf("(") + 1, svrStr.lastIndexOf(")"))).indexOf("-") < 0) {
                return currentSvr;
            }
            svrStr = svrStr.substring(svrStr.indexOf("-") + 1, svrStr.length());
            StringBuilder sb = new StringBuilder();
            int i2 = 0;
            while (i2 < svrStr.length()) {
                if ('0' > svrStr.charAt(i2) || '9' < svrStr.charAt(i2)) break;
                sb.append(svrStr.charAt(i2));
                ++i2;
            }
            currentSvr = Long.valueOf(sb.toString());
        } else {
            String[] svnStrArr = svrStr.split("-");
            if (svnStrArr.length >= 5 && StringUtil.isLong(svnStrArr[4])) {
                currentSvr = Long.valueOf(svnStrArr[4]);
            }
        }
        return currentSvr;
    }

    public static void appendLine(StringBuilder sb) {
        sb.append(LINE_SEPARATOR);
    }

    public static void appand(StringBuilder sb, int tabNum, String str) {
        int i2 = 0;
        while (i2 < tabNum) {
            sb.append("\t");
            ++i2;
        }
        sb.append(str);
        StringUtil.appendLine(sb);
    }

    public static String replaceSpecialCharFromShell(String str) {
        if (StringUtil.isEmpty(str)) {
            return EMPTY;
        }
        StringBuilder result = new StringBuilder();
        int i2 = 0;
        while (i2 < str.length()) {
            char tmpChar = str.charAt(i2);
            if (tmpChar == '$' || tmpChar == '\"' || tmpChar == '\\') {
                result.append('\\');
            }
            result.append(tmpChar);
            ++i2;
        }
        return result.toString();
    }

    public static long getSizeWithoutUnit(String spaceStr) {
        if (StringUtil.isLong(spaceStr)) {
            return Long.valueOf(spaceStr);
        }
        if (spaceStr.length() <= 1) {
            return 0L;
        }
        String unitStr = spaceStr.substring(spaceStr.length() - 1);
        String spaceSizeStr = spaceStr.substring(0, spaceStr.length() - 1);
        if (unitStr.equalsIgnoreCase("K")) {
            return Long.parseLong(spaceSizeStr) * 1024L;
        }
        if (unitStr.equalsIgnoreCase("M")) {
            return Long.parseLong(spaceSizeStr) * 1024L * 1024L;
        }
        if (unitStr.equalsIgnoreCase("G")) {
            return Long.parseLong(spaceSizeStr) * 1024L * 1024L * 1024L;
        }
        if (unitStr.equalsIgnoreCase("T")) {
            return Long.parseLong(spaceSizeStr) * 1024L * 1024L * 1024L * 1024L;
        }
        return 0L;
    }

    public static String getSizeWithUnit(long size) {
        return StringUtil.getSizeWithUnit(size, EMPTY);
    }

    public static String getSizeWithUnit(long size, String unitStr) {
        String strSize = EMPTY;
        if (size / 1024L > 2L) {
            strSize = String.valueOf(String.valueOf(size /= 1024L)) + "K";
            if (unitStr.equalsIgnoreCase("K")) {
                return strSize;
            }
        }
        if (size / 1024L > 2L) {
            strSize = String.valueOf(String.valueOf(size /= 1024L)) + "M";
            if (unitStr.equalsIgnoreCase("M")) {
                return strSize;
            }
        }
        if (size / 1024L > 2L) {
            strSize = String.valueOf(String.valueOf(size /= 1024L)) + "G";
            if (unitStr.equalsIgnoreCase("G")) {
                return strSize;
            }
        }
        if (size / 1024L > 2L) {
            strSize = String.valueOf(String.valueOf(size /= 1024L)) + "T";
            if (unitStr.equalsIgnoreCase("T")) {
                return strSize;
            }
        }
        return strSize;
    }

    public static String[] splitString(String str, String regex) {
        if (StringUtil.isEmpty(str = StringUtil.trimToEmpty(str))) {
            return new String[0];
        }
        String[] tmpStrArr = str.split(regex);
        ArrayList<String> strList = new ArrayList<String>();
        String[] stringArray = tmpStrArr;
        int n2 = tmpStrArr.length;
        int n3 = 0;
        while (n3 < n2) {
            String tmpStr = stringArray[n3];
            if (!StringUtil.isEmpty(tmpStr = StringUtil.trimToEmpty(tmpStr))) {
                strList.add(tmpStr);
            }
            ++n3;
        }
        return strList.toArray(new String[0]);
    }

    private static boolean checkDMVersion(String dmVersion, boolean isDM8) {
        if (StringUtil.isEmpty(dmVersion)) {
            return false;
        }
        String[] versionArr = dmVersion.split("\\.");
        if (versionArr.length != 4) {
            return false;
        }
        int i2 = 0;
        while (i2 < versionArr.length) {
            String tmpStr = StringUtil.trimToEmpty(versionArr[i2]);
            if (!tmpStr.equals(versionArr[i2])) {
                return false;
            }
            if (i2 == 0) {
                if (!(tmpStr.equals("7") || isDM8 && tmpStr.equals("8"))) {
                    return false;
                }
            } else {
                if (tmpStr.length() > 1 && tmpStr.indexOf(0) == 48) {
                    return false;
                }
                if (!StringUtil.isDigit(tmpStr)) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    public static boolean isUpperCase(String str) {
        int len = str.length();
        int i2 = 0;
        while (i2 < len) {
            if (Character.isLowerCase(str.charAt(i2))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static String[] toStringArray(Object[] values) {
        if (values == null || values.length == 0) {
            return new String[0];
        }
        String[] strArrs = new String[values.length];
        int i2 = 0;
        Object[] objectArray = values;
        int n2 = values.length;
        int n3 = 0;
        while (n3 < n2) {
            Object value = objectArray[n3];
            strArrs[i2++] = value == null ? null : value.toString();
            ++n3;
        }
        return strArrs;
    }

    public static int find(String str, String subStr) {
        int count = 0;
        int off = 0;
        int ioff = 0;
        while ((ioff = str.indexOf(subStr, off)) != -1) {
            off = ioff + subStr.length();
            ++count;
        }
        return count;
    }

    public static boolean contains(String[] array, String str) {
        String[] stringArray = array;
        int n2 = array.length;
        int n3 = 0;
        while (n3 < n2) {
            String a2 = stringArray[n3];
            if (StringUtil.equals(a2, str)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String[] array, String str) {
        String[] stringArray = array;
        int n2 = array.length;
        int n3 = 0;
        while (n3 < n2) {
            String a2 = stringArray[n3];
            if (StringUtil.equalsIgnoreCase(a2, str)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static String encrypt(String data, String engine) {
        if (StringUtil.isEmpty(data)) {
            return data;
        }
        if (StringUtil.isEmpty(engine)) {
            return StringUtil.encrypt(data);
        }
        Object object = null;
        try {
            object = Class.forName(engine).newInstance();
        }
        catch (Exception e2) {
            throw new RuntimeException("create engine object fail", e2);
        }
        return (String)ReflectUtil.executeMethod(object, "encrypt", new Class[]{String.class}, new String[]{data});
    }

    public static String decrypt(String data, String engine) {
        if (StringUtil.isEmpty(data)) {
            return data;
        }
        if (StringUtil.isEmpty(engine)) {
            return StringUtil.decrypt(data);
        }
        Object object = null;
        try {
            object = Class.forName(engine).newInstance();
        }
        catch (Exception e2) {
            throw new RuntimeException("create engine object fail", e2);
        }
        return (String)ReflectUtil.executeMethod(object, "decrypt", new Class[]{String.class}, new String[]{data});
    }

    public static void main(String[] args) {
        String str = "hello wo?rld";
        System.out.println(StringUtil.find(str, "?"));
    }
}

