/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    public static final int DEFAULT_READ_BUFFER_SIZE = 4096;

    public static long lastModified(String filePath) {
        try {
            return new File(filePath).lastModified();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static byte[] readByteArrayFromResource(String resource) throws IOException {
        InputStream in;
        block3: {
            in = null;
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                if (in != null) break block3;
            }
            catch (Throwable throwable) {
                FileUtil.close(in);
                throw throwable;
            }
            FileUtil.close(in);
            return null;
        }
        byte[] byArray = FileUtil.readByteArray(in);
        FileUtil.close(in);
        return byArray;
    }

    public static byte[] readByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FileUtil.copy(input, output);
        return output.toByteArray();
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n2 = 0;
        while (-1 != (n2 = input.read(buffer))) {
            output.write(buffer, 0, n2);
            count += (long)n2;
        }
        return count;
    }

    public static String read(InputStream in) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalStateException(e2.getMessage(), e2);
        }
        return FileUtil.read(reader);
    }

    public static String read(Reader reader) {
        try {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[4096];
            int n2 = 0;
            while (-1 != (n2 = reader.read(buffer))) {
                writer.write(buffer, 0, n2);
            }
            return writer.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException("read error", ex);
        }
    }

    public static String readFromResource(String resource) throws IOException {
        String text;
        InputStream in;
        block4: {
            in = null;
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                if (in == null) {
                    in = FileUtil.class.getResourceAsStream("/" + resource);
                }
                if (in != null) break block4;
            }
            catch (Throwable throwable) {
                FileUtil.close(in);
                throw throwable;
            }
            FileUtil.close(in);
            return null;
        }
        String string = text = FileUtil.read(in);
        FileUtil.close(in);
        return string;
    }

    public static void close(Closeable x2) {
        if (x2 == null) {
            return;
        }
        try {
            x2.close();
        }
        catch (Exception exception) {}
    }

    public static List<String> readLines(File file) throws IOException {
        return FileUtil.readLines(file, null);
    }

    public static List<String> readLines(File file, String encoding) throws IOException {
        FileInputStream input = new FileInputStream(file);
        return FileUtil.readLines(input, encoding);
    }

    public static List<String> readLines(InputStream input, String encoding) throws IOException {
        ArrayList<String> arrayList;
        try {
            String line;
            InputStreamReader reader = encoding == null ? new InputStreamReader(input) : new InputStreamReader(input, encoding);
            BufferedReader br = new BufferedReader(reader);
            ArrayList<String> list = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            try {
                input.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            input.close();
        }
        catch (Exception exception) {}
        return arrayList;
    }
}

